package com.sample;

import static org.junit.Assert.*;

import java.io.ByteArrayInputStream;

import org.junit.Test;
import org.w3c.dom.Element;

public class XmlUtilTest {

	@Test
	public void testGetId() {
		String str = "<iq id=\"XXX\" to=\"user01@localhost.localdomain/Smack\" type=\"get\" from=\"user02@localhost.localdomain/Smack\">"
				+ "<query xmlns=\"jabber:iq:private\">"
				+ "<exodus xmlns=\"exodus:prefs\">" 
				+ "</exodus>" 
				+ "</query>"
				+ "</iq>";

		XmlUtil util = XmlUtil.getInstance();
		Element root = util.parse(new ByteArrayInputStream(str.getBytes()));
		String id = util.getId(root);
		assertEquals("XXX", id);
	}

	@Test
	public void testGetChild(){
		String id = "XXX";
		String result = "<iq id=\"" + id + "\" to=\"user02@localhost.localdomain/Smack\" type=\"result\"><query xmlns=\"jabber:iq:register\" /><dummy /></iq>";

		XmlUtil util = XmlUtil.getInstance();
		String str = util.getChild(new ByteArrayInputStream(result.getBytes()));
		System.out.print(str); // 手抜き
	}
}
