/*
 *  The MIT License
 *
 *  Copyright 2014 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */
package org.routine_work.simple_battery_logger.service;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.media.MediaScannerConnection;
import android.media.MediaScannerConnection.MediaScannerConnectionClient;
import android.net.Uri;
import android.text.TextUtils;
import java.util.Date;
import org.routine_work.simple_battery_logger.BatteryConstants;
import org.routine_work.util.Log;

/**
 *
 * @author sawai
 */
public class CsvFileMediaScanService extends IntentService
{

	private static final String LOG_TAG = "simple-battery-logger";

	public CsvFileMediaScanService(String name)
	{
		super(name);
	}

	public CsvFileMediaScanService()
	{
		this("CsvFileMediaScanService");
	}

	@Override
	protected void onHandleIntent(Intent intent)
	{
		Log.i(LOG_TAG, "CsvFileMediaScanService : Start at " + new Date());

		String csvFilePath = intent.getStringExtra(BatteryConstants.EXTRA_CSV_FILE_PATH);
		Log.i(LOG_TAG, "intent.EXTRA_CSV_FILE_PATH => " + csvFilePath);

		if (TextUtils.isEmpty(csvFilePath) == false)
		{
			startOneCsvFileMediaScan(csvFilePath);
		}

		Log.i(LOG_TAG, "CsvFileMediaScanService : End at " + new Date());
	}

	private void startOneCsvFileMediaScan(String csvFilePath)
	{
		Log.v(LOG_TAG, "Hello");
		OneCsvFileMediaScanClient csvFileMediaScanClient = new OneCsvFileMediaScanClient(csvFilePath);
		csvFileMediaScanClient.connectMediaScanner();
		Log.v(LOG_TAG, "Bye");
	}

	class OneCsvFileMediaScanClient implements MediaScannerConnectionClient
	{

		private MediaScannerConnection mediaScannerConnection;
		private String csvFilePath;

		public OneCsvFileMediaScanClient(String csvFilePath)
		{
			this.csvFilePath = csvFilePath;
		}

		public void connectMediaScanner()
		{
			Log.v(LOG_TAG, "Hello");
			Context context = CsvFileMediaScanService.this.getApplicationContext();
			mediaScannerConnection = new MediaScannerConnection(context, this);
			mediaScannerConnection.connect();
			Log.v(LOG_TAG, "Bye");
		}

		public void onMediaScannerConnected()
		{
			Log.v(LOG_TAG, "Hello");
			mediaScannerConnection.scanFile(csvFilePath, null);
			Log.v(LOG_TAG, "Bye");
		}

		public void onScanCompleted(String filePath, Uri uri)
		{
			Log.v(LOG_TAG, "Hello");
			Log.v(LOG_TAG, "filePath => " + filePath + ", uri => " + uri);
			mediaScannerConnection.disconnect();
			Log.v(LOG_TAG, "Bye");
		}
	}
}
