static	char	sccsid[]="%Z% %M% %I% %E% %U%";
/********************************************************************/
/* <clscr.c>                                                        */
/*                                                                  */
/********************************************************************/

#include "colmn.h"                     /* 萔`                    */
#include <sys/timeb.h>

extern condList CLcList;               /* 񃊃Xg                  */
extern CLPRTBL   CLprocTable, *pCLprocTable;
extern GlobalCt  GlobTable, *pGlobTable;

/*******************************************************/
/* _print_script_end                                   */
/*******************************************************/
static void _print_script_end(error_cod)
int error_cod;
{
	char *scrname,*fmt;
	struct timeval tval;

	/* set end time */
	aka_get_msec(&tval);
	akxe_timer_sub(&tval,&tval,&pCLprocTable->tScrTimeVal[0]);
	aka_get_inst_comment(pCLprocTable->lInstanceHandle,&scrname);
	if (!scrname) scrname = AKX_NULL_PRINT;
/*	scrname = AKX_NULL_PRINT;	*/
#if 0
	fmt = FORMAT(21);	/* *** I( %s %d.%03d sec) ret=%d */
	PRINTOUT4(fmt,scrname,tval.tv_sec,tval.tv_usec/1000,error_cod);
	DEBUGOUTL4(1,fmt,scrname,tval.tv_sec,tval.tv_usec/1000,error_cod);
#else
	fmt = FORMAT(22);	/* *** I( %s %d.%03d sec) nofree no=%d ret=%d */
/*	PRINTOUT5(fmt,scrname,tval.tv_sec,tval.tv_usec/1000,Nofree(0),error_cod);
	DEBUGOUTL5(1,fmt,scrname,tval.tv_sec,tval.tv_usec/1000,Nofree(0),error_cod);	*/
	PRDBGOUTL5(1,fmt,scrname,tval.tv_sec,tval.tv_usec/1000,Nofree(0),error_cod);
#endif
}

/*******************************************************/
/* cl_get_cmd_id                                          */
/*******************************************************/
unsigned int cl_get_cmd_id()
{
	TrmToSrv *pPacket;
	AKAMSGCOM *tpMsgCom;
	char buf[5];

	if (!pCLprocTable->CmdPacketp) return(-1);
	tpMsgCom = (AKAMSGCOM *)pCLprocTable->CmdPacketp;

	if (!(pPacket = (TrmToSrv *)tpMsgCom->msg_pmsg)) return -1;

	if (tpMsgCom->msg_mlen < sizeof(TrmToSrv)) {
		/* *** clscr: bZ[W(%d)sł */
		ERROROUT1(FORMAT(23),tpMsgCom->msg_mlen);
		return -1;
	}
	if (!memcmp(pPacket,"DB",2)) {
		strnzcpy(buf,pPacket,4);
		/* *** clscr: bZ[W̐擪'%s'ł */
		ERROROUT1(FORMAT(24),buf);
		return -1;
	}

	memcpy(GlobTable.usrcod,pPacket->userid,sizeof(GlobTable.usrcod));
	memcpy(GlobTable.usrinf,pPacket->userid,sizeof(pPacket->userid));
#ifdef	DEBUG_OFF
	printf("pCLprocTable->CmdPacketp->userid = %s\n",GlobTable.usrcod);
#endif
	return(ntohl(pPacket->commandid));
}

/*******************************************************/
/* clParmSet                                           */
/*******************************************************/
int cl_parameter_set()
{
	TrmToSrv *pPacket;
	int  rc;
	int	len;
	int	num;
	AKAMSGCOM *tpMsgCom ;

	rc = 0;

	if (pCLprocTable->CmdPacketp == NULL) return(-1);
	tpMsgCom = (AKAMSGCOM *)pCLprocTable->CmdPacketp;
	if (!(pPacket = (TrmToSrv *)tpMsgCom->msg_pmsg)) return -1;
	len = tpMsgCom->msg_mlen - sizeof(TrmToSrv);
	num = ntohl(pPacket->parmnum);
	pPacket++;
	rc = cl_parm_data_set(num,pPacket,len);

	return(rc);
}

/*******************************************************/
/* cl_parm_shift                                       */
/*******************************************************/
int cl_parm_shift(pInfoParm)
tdtInfoParm *pInfoParm;
{
	TrmToSrv *pPacket;
	AKAMSGCOM *tpMsgCom ;
	int  num,len,ret;
	char *p;

	if (tpMsgCom = (AKAMSGCOM *)pCLprocTable->CmdPacketp) {
		if (pPacket = (TrmToSrv *)tpMsgCom->msg_pmsg) {
			if ((len=tpMsgCom->msg_mlen-sizeof(TrmToSrv)) > 0) {
				if ((num=ntohl(pPacket->parmnum)) > 0) {
					if (len < num*2) return -1;
					p = (char *)(pPacket + 1);
					if ((ret = cmn_get_data(p,pInfoParm)) < 0) return ret;
					if ((len -= pInfoParm->pi_len) < 0) return -1;
					memcpy(p,p+pInfoParm->pi_len,len);
					pPacket->parmnum = htonl(--num);
					return 0;
				}
			}
		}
	}
	return -1;
}

/*******************************************************/
/* cl_script_error                                     */
/*******************************************************/
int cl_script_error()
{
	int rc,error_cod;

	error_cod = pGlobTable->Return;
	rc = cl_make_return_packet();
	if (rc != NormalEnd ) {
		ERROROUT("Return Packet Error");
		pGlobTable->Return = rc;
		if (pCLprocTable->ListPBody) {
			cl_list_pac_clear(pCLprocTable->ListPBody);
			pCLprocTable->ListPBody = NULL ;
		}
		rc = cl_make_return_packet();
	}
	cl_ct_clear();
	pGlobTable->Return = 0;
	pGlobTable->error  = 0;
	pGlobTable->exception = 0;
	cmn_set_stat(COM_PR,&pCLprocTable->PrSt,L_OFF);
	cmn_set_stat(SCR_PR,&pCLprocTable->PrSt,L_OFF);
	cmn_set_stat(RTN_PR,&pCLprocTable->PrSt,L_OFF);
	cmn_set_stat(UPD_PR,&pCLprocTable->PrSt,L_OFF);
	pCLprocTable->iThread = -2;
	pCLprocTable->SlstatusSW = 0;
	_print_script_end(error_cod);
	return 0;
}

/*******************************************************/
/* cl_script_main                                      */
/*******************************************************/
int cl_script_main()
{
	int  rc             = 0 ;
	unsigned int cmdid = 0 ;
	char *scrname       = (char *)NULL ;
	long wkl;
#if 1
	char	*buf_p;
#endif
#if 1
	TrmToSrv		*pPacket;	/* [[T[oI/F */
#endif
	struct timeval tval;
	ScrPrCT *scrct;
	AKAMSGCOM *tpMsgCom;
	int error_cod;

	if (cmn_chk_stat(SCR_EX,&pCLprocTable->ScrSt) == L_OFF) {
		/* set start time */
		aka_get_msec(&pCLprocTable->tScrTimeVal[0]);
		/* set script name(null) to Instance Comment */
		aka_set_inst_comment(pCLprocTable->lInstanceHandle, NULL);

		cmdid = cl_get_cmd_id();
		if (cmdid == 0xffffffff) {
			pGlobTable->Return = -1;
			cl_script_error();
			return 0;
		}
#if 1
		cmdid &= 0x0fffffff;
#endif
	/*  0x00000000̓vZXNɎsR}hɕύX
		Coalł́A0x00000000́A1p[^XNvgƂR}hɕύX
		          vZXNɎsR}h́A0x0ffffff0
		if (!cmdid) {
			clSetSystemParm();
			cl_script_error();
			return(0);
		}
	*/
		CLcList.option = 0;
		rc  = cl_get_script_name((char *)&cmdid);
		if (rc != NormalEnd) {
			ERROROUT1("*** clscr:script name is not defined for cmdid=%08x",
			          cmdid);
			pGlobTable->Return = rc;
			cl_script_error();
			return rc ;
		}

		/* set script name to Instance Comment */
		if (!(scrname = cl_set_script_name_extension(CLcList.fname,strlen(CLcList.fname)))) return -1;
		aka_set_inst_comment(pCLprocTable->lInstanceHandle,scrname);
#ifdef TIME
akb_ptime('S',"cl_exe_scr_init");
#endif
		if (CLcList.option & D_SCRPT_MEMORY)
			rc = cl_exe_scr_mem_init(CLcList.rbuf,CLcList.line,NULL,NULL);
		else
			rc = cl_exe_scr_init(CLcList.fname,NULL,NULL);
#ifdef TIME
akb_ptime('E',"cl_exe_scr_init");
#endif
/*
printf("cl_exe_scr_init ret=%d\n",rc);
*/
		if (rc != NormalEnd ) {
			if (rc != ECL_EX_EXEC_TREE) ERROROUT("Script initial process Error");
			pGlobTable->Return = rc;
			cl_script_error();
			memset(&pCLprocTable->ScrSt,0,1);
			return rc;
		}
		cmn_set_stat(SCR_EX,&pCLprocTable->ScrSt,L_ON);
	}

#ifdef TIME
akb_ptime('S',"cl_execute_script");
#endif
    rc = cl_execute_script();
#ifdef TIME
akb_ptime('E',"cl_execute_script");
#endif
	while (rc == NormalEnd &&
			cmn_chk_stat(SCR_ED,&pCLprocTable->ScrSt) == L_OFF &&
			cmn_chk_stat(RTN_PR,&pCLprocTable->PrSt) == L_OFF) {
#ifdef TIME
akb_ptime('S',"cl_execute_script");
#endif
    	rc = cl_execute_script();
#ifdef TIME
akb_ptime('E',"cl_execute_script");
#endif
	}
	error_cod = pGlobTable->error;
	if (rc != NormalEnd) {
		ERROROUT("Error ocurred at Script process");
		pGlobTable->Return = rc;
		cmn_set_stat(RLL_BK,&pCLprocTable->PrSt,L_OFF);
		if (cmn_chk_stat(UPD_PR,&pCLprocTable->PrSt) != L_OFF) {
		/*
			cl_process_rollback();
		*/
			cmn_set_stat(RLL_BK,&pCLprocTable->PrSt,L_ON);
			return NormalEnd;
		}
		cl_script_error();
		memset(&pCLprocTable->ScrSt,0,1);
		PRINTOUT("*** clscr error end");
		return(rc);
	}

	if (cmn_chk_stat(SCR_ED,&pCLprocTable->ScrSt) != L_OFF) {
                       /* script terminate process running */
/*
		if ( cmn_chk_stat(SEL_ED,&pCLprocTable->SearchSt) == L_OFF) {
*/
                       /* search process igai */
			if (pGlobTable->error != 0)
				pGlobTable->Return = pGlobTable->error;
#ifdef TIME
akb_ptime('S',"cl_make_return_packet");
#endif
			rc = cl_make_return_packet();
#ifdef TIME
akb_ptime('E',"cl_make_return_packet");
#endif
			if (rc != NormalEnd ) {
				ERROROUT("Return Packet Error");
				pGlobTable->Return = rc;
				if (pCLprocTable->ListPBody) {
					cl_list_pac_clear(pCLprocTable->ListPBody);
					pCLprocTable->ListPBody = NULL ;
				}
				rc = cl_make_return_packet();
				pGlobTable->Return = 0;
			}
/*
		}
*/
#ifdef TIME
akb_ptime('S',"cl_ct_clear");
#endif
		cl_ct_clear();
#ifdef TIME
akb_ptime('E',"cl_ct_clear");
#endif
		cmn_set_stat(SCR_PR,&pCLprocTable->PrSt,L_OFF);
		cmn_set_stat(COM_PR,&pCLprocTable->PrSt,L_OFF);
		cmn_set_stat(UPD_PR,&pCLprocTable->PrSt,L_OFF);
		memset(&pCLprocTable->ScrSt,0,1);
		memset(&pCLprocTable->SearchSt,0,1);

		pCLprocTable->iThread = -3;
		pCLprocTable->SlstatusSW = 0;

#if 1
		/* R}hhc̐擪rbgƂ */
		tpMsgCom = (AKAMSGCOM *)pCLprocTable->WrPacketp;
		if (pPacket = (TrmToSrv *)tpMsgCom->msg_pmsg) {
/* printf("Command ID(End) : %08x\n",pPacket->commandid);	*/
		/*	pPacket->commandid &= 0x0fffffff;	*/
			wkl = ntohl(pPacket->commandid);
			pPacket->commandid = htonl(wkl & 0x0fffffff);
/* printf("Command ID(Wrt) : %08x\n",pPacket->commandid);	*/
		}
#endif
		_print_script_end(error_cod);

	}
#if 0
	else if ( cmn_chk_stat( SCR_LV, &pCLprocTable->ScrSt) == L_ON )
#else
	else if ( cmn_chk_stat( SCR_LV, &pCLprocTable->ScrSt) == SCR_LV )
#endif
	{
		/* ݎs̃XNvg̏ & e[ȕ */
		cl_ct_clear();

		/* tO̐ݒ */
		cmn_set_stat(SCR_PR,&pCLprocTable->PrSt,L_OFF);
		cmn_set_stat(COM_PR,&pCLprocTable->PrSt,L_OFF);
		cmn_set_stat(UPD_PR,&pCLprocTable->PrSt,L_OFF);
		memset(&pCLprocTable->ScrSt,0,1);
		memset(&pCLprocTable->SearchSt,0,1);
		cmn_set_stat(RTN_PR,&pCLprocTable->PrSt,L_OFF);
		cmn_set_stat(SCR_ED,&pCLprocTable->ScrSt,L_ON);

		pCLprocTable->iThread = -4;
		pCLprocTable->SlstatusSW = 0;
	}

	tpMsgCom = (AKAMSGCOM *)pCLprocTable->WrPacketp;
	if (tpMsgCom->msg_pmsg == NULL) {
		ERROROUT("You have not set write packet ,please check your script");
		ERROROUT("I guess you forget RETURN command in your script");
		pGlobTable->Return = ECL_SCRIPT_ERROR;
		cl_script_error();
		memset(&pCLprocTable->ScrSt,0,1);
	}

	return(rc);
}
