static char sccsid[]="%Z% %M% %I% %E% %U%";
/************************************************/
/*												*/
/*	akasendmsg.c								*/
/*												*/
/*			coded by A.Kobayashi 2010/6/10		*/
/*												*/
/************************************************/
#include "akacommon.h"

extern tdtMsgCtl         tMsgCtl;
extern tdtClassCtlHead   tClassHead;

/********************************************************/
/*      L[ɓAbZ[Wo͂              */
/********************************************************/
static int _set_que_and_output(cpPacket,iSendLen,iSend)
char *cpPacket;
int  iSendLen,iSend;
{
	pSdPacketTable  pNew;
/*
printf("_set_que_and_output: cpPacket=%08x iSendLen=%d\n",cpPacket,iSendLen);
*/
	if (iSend) {
		ERROROUT("_set_que_and_output: socket closed");
		return akb_set_rb_pack_err_cd(0,cpPacket,tMsgCtl.pRbRCtl,D_ERR_SOCKET_CLOSED);
	}
	if (!(pNew = akb_packet_tbl_new(0))) {
		Free(cpPacket);
		return -18506201;
	}
	pNew->pContent = cpPacket;
	pNew->iLen     = iSendLen;

DEBUGOUTL3(AKA_LOG_GROUP|250,
"_set_que_and_output:iLen=%d iCh=%d offset=%d",
pNew->iLen,pNew->iCh,pNew->offset);
/*
printf("_set_que_and_output: pNew=%08x\n",pNew);
*/

	/* L[ɓ */
	if (!akxs_rb_set_n(tMsgCtl.pRbRCtl,pNew)) {
		Free(cpPacket);
		Free(pNew);
		return -18506202;
	}
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int _create_pk_data(tpHead,tpSendMsgCom,cppPacket)
qCommPackHead   *tpHead;
AKAMSGCOM       *tpSendMsgCom;
char            **cppPacket;
{
	int lPackLen;

	lPackLen = akb_create_pk_data(NULL,tpHead,tpSendMsgCom,cppPacket);
	if (lPackLen < 0) lPackLen -= 18506300;
	return lPackLen;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int _timer_proc(iTimerId,cpTimerName,cpParm,pttime)
int iTimerId;
char *cpTimerName,*cpParm;
struct timeval *pttime;
{
	akb_set_rb_pack_err_cd(0,cpParm,tMsgCtl.pRbRCtl,0);
	return -1;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int _send_or_post_msg(lInstanceHandle,tpSendMsg,iSend,iWaitTime)
long       lInstanceHandle;	/* CX^Xʔԍ */
AKAMSGCOM *tpSendMsg;		/* bZ[WMp\̂ւ̃|C^ */
int iSend;		/* 0/1 = Post / Send */
int iWaitTime;	/* >=0 :bZ[W̃^CAEg(msec) */
{
	qCommPackHead   tHead,*pHead;
	int             iThread;
	char            *cpPacket,*name;
	int             iSendLen,iRc;

	if (!tpSendMsg) return -18506402;

	iThread  = 1;

	/* pPbgg */
	if (tpSendMsg->usDisposition>255) return -18506407;
	/* NULLNXo̓`FbN */
	tHead.PrtclId.cSendPrtcl = tpSendMsg->ucPackForm & AKA_PFM_INDIRECT;
	tHead.PrtclId.sCommand = htons(AKB_CMD_SEND);
	tHead.SrcInf.ucDispos  = tpSendMsg->usDisposition;
	tHead.SrcInf.ucThread  = iThread;
	tHead.SrcInf.sPacketNo = 0;

	tHead.PrtclId.cVer     = 'C';
	tHead.DestInf.ucThread = 0;
	tHead.DestInf.ucDispos = tpSendMsg->ucAkbOption & AKA_AKO_NOREPLY;
	tHead.DestInf.sPacketNo= 0;
	tHead.lPackLen = 0 ;

	pHead = &tHead;
	if ((iSendLen=_create_pk_data(pHead,tpSendMsg,&cpPacket))<=0) {
		ERROROUT1("_send_or_post_msg:_create_pk_data ret=%d",iSendLen);
		if (iSendLen<0) return iSendLen;
		return -18506408;
	}
	if (iWaitTime > 0) {
		iRc = akxe_register_timer(tMsgCtl.pTimerCtl,"sleep",_timer_proc,iWaitTime,cpPacket);
		if (iRc > 0) iRc = 0;
	}
	else iRc = _set_que_and_output(cpPacket,iSendLen,iSend);
	return iRc;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_send_msg(lInstanceHandle,tpSendMsg)
long       lInstanceHandle ;	/* CX^Xʔԍ */
AKAMSGCOM *tpSendMsg    ;	/* bZ[WMp\̂ւ̃|C^ */
{
	return _send_or_post_msg(lInstanceHandle,tpSendMsg,1,-1);
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_post_msg(lInstanceHandle,tpSendMsg)
long       lInstanceHandle ;	/* CX^Xʔԍ */
AKAMSGCOM *tpSendMsg    ;	/* bZ[WMp\̂ւ̃|C^ */
{
	return _send_or_post_msg(lInstanceHandle,tpSendMsg,0,-1);
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_send_msg_wait_time(lInstanceHandle,tpSendMsg,iWaitTime)
long       lInstanceHandle ;	/* CX^Xʔԍ */
AKAMSGCOM *tpSendMsg    ;	/* bZ[WMp\̂ւ̃|C^ */
int        iWaitTime;	/* >=0 :bZ[W̃^CAEg(msec) */
{
	return _send_or_post_msg(lInstanceHandle,tpSendMsg,1,iWaitTime);
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_recv_msg(lInstanceHandle,tpInst,iWaitTime,iOptions)
long         lInstanceHandle;
tdtInstance *tpInst;
int          iWaitTime;	/* msec */
int          iOptions;	/* 0/1/2 */
{
	struct timeval tmtime;
	uchar  ucStatus;
	int    iRc;
	char   *p;
	tdtRbCtl *pRbTmp;

	if (!tpInst) return -18507302;
	if (iOptions < 0 || iOptions > 2) return -18507306;

	/* ^C}̕ۑƃNA */
	akxe_timer_set(&tmtime, &tMsgCtl.tGetMsgTimeOut);
	ucStatus = tMsgCtl.ucRsv1;
	timerclear(&tMsgCtl.tGetMsgTimeOut);
	tMsgCtl.ucRsv1 = 0;

	if (iWaitTime < 0) iWaitTime = tMsgCtl.iSendMsgTimeOut;
	iWaitTime /= 100;	/* msec --> 1/10sec */

	/* Iv܂Ń[v */
	while ((iRc=aka_get_msg(iWaitTime)) > 0) {
		if (iRc=aka_dispatch_recv_msg(tpInst)) break;
	}
	if (iRc == AKB_CMD_RECVMSG) {
		iRc = 0;
	}
	else if (!iRc) iRc = PACKET_TIMEOUT_ERROR;

	/* ^C}̕ */
	akxe_timer_set(&tMsgCtl.tGetMsgTimeOut, &tmtime);
	tMsgCtl.ucRsv1 = ucStatus;

	return iRc;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_post_msg_wait_time(lInstanceHandle,tpPostMsgCom,iWaitTime)
long       lInstanceHandle ;	/* CX^Xʔԍ */
AKAMSGCOM *tpPostMsgCom    ;	/* bZ[WMp\̂ւ̃|C^ */
int        iWaitTime;	/* >=0 :bZ[W̃^CAEg(msec) */
{
	return _send_or_post_msg(lInstanceHandle,tpPostMsgCom,0,iWaitTime);
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_set_sleep(lInstanceHandle,iDisposition,iSleepTime)
long lInstanceHandle;	/* CX^Xʔԍ */
int  iDisposition;
int  iSleepTime;	/* >=0 :bZ[W̃^CAEg(msec) */
{
	AKAMSGCOM tSendMsg;

	memset(&tSendMsg,0,sizeof(AKAMSGCOM));
	tSendMsg.usDisposition = iDisposition;
	return aka_post_msg_wait_time(lInstanceHandle,&tSendMsg,iSleepTime);
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_set_inst_comment(lInstanceHandle, cpText)
long  lInstanceHandle;
char  *cpText;
{
	int iRc;
	tdtClassCtl *tpClass;
	tdtInstance *tpIns;
	char *p;

	if (tMsgCtl.iSd<0) return -18508101;

	if (lInstanceHandle) {
		tpClass = tClassHead.tpClass;
		if (tpIns = tpClass->tpInstance) {
			if (cpText) {
				if (!(p = Strdup(cpText))) return -18508109;
			}
			else p = NULL;

			if (tpIns->cpComment) Free(tpIns->cpComment);
			tpIns->cpComment = p;
		}
		else return -18508108;
	}
	else return -18508107;

	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_get_inst_comment(lInstanceHandle, cppText)
long  lInstanceHandle;
char  **cppText;
{
	int iRc;
	tdtClassCtl *tpClass;
	tdtInstance *tpIns;
	char *p;

	if (!cppText) return -18508209;
	*cppText = NULL;
	if (tMsgCtl.iSd<0) return -18508201;

	if (lInstanceHandle) {
		tpClass = tClassHead.tpClass;
		if (tpIns = tpClass->tpInstance) {
			*cppText = tpIns->cpComment;
		}
		else return -18508208;
	}
	else return -18508107;

	return 0;
}
