static char sccsid[]="%Z% %M% %I% %E% %U%";
/********************************************/
/*											*/
/*	  coded by A.Kobayashi() 2010.5.27		*/
/*	  error code : -18620101`-18629999		*/
/********************************************/
#include "akxcommon.h"
#include <math.h>

static MPA *_sMMAX=NULL;
static MPA _MMAX = {
	MPA_ID1,MPA_ID2,
	 0, /* opt  */
	40,	/* alen */
  NMPA,	/* len  */
MAXEXP,	/* exp  */
	 0,	/* sign */
	 0,	/* zero */
	 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
	 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
	 99, 99, 99, 99, 99, 99, 99, 0};

static MPA *_sM0=NULL;
static MPA _M0 = {
	MPA_ID1,MPA_ID2,
	0,  /* opt  */
	40,	/* alen */
	0,	/* len  */
	0,	/* exp */
	0,	/* sign */
	1,	/* zero */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0};

static MPA *sMPA_LOG2=NULL;
static MPA MPA_LOG2z = {
	MPA_ID1,MPA_ID2,0,40,27,-1,0,0,
#if 1	/* 2021.10.13 */
	69,31,47,18, 5,59,94,53, 9,41,
	72,32,12,14,58,17,65,68, 7,55,
	 0,13,43,60,25,52,54, 0};
#else
	69,31,47,18, 5,59,94,53, 9,41,
	70,73,59,34,29,86,19,81,35,84,
	39,12,39,24,20, 3,45, 0};
#endif
static MPA *MPA_LOG2 = &MPA_LOG2z;

static MPA *sMPA_LOG10=NULL;
static MPA MPA_LOG10 = {
	MPA_ID1,MPA_ID2,0,40,27,0,0,0,
#if 1	/* 2021.10.13 */
	 2,30,25,85, 9,29,94, 4,56,84,
	 1,79,91,45,46,84,36,42, 7,60,
	11, 1,48,86,28,80, 0, 0};
#else
	 2,30,25,85, 9,29,94, 4,56,84,
	 1,75,15,87, 5,99,42, 4,47,44,
	99,18,45,73,20,60,81, 0};
#endif

static MPA *sMPA_1DLOG10=NULL;
static MPA MPA_1DLOG10 = {
	MPA_ID1,MPA_ID2,0,40,27,-1,0,0,
#if 1	/* 2021.10.13 */
	43,42,94,48,19, 3,25,18,27,65,
	11,28,91,89,16,60,50,82,29,43,
	97, 0,58, 3,66, 0, 0, 0};
#else
	43,42,94,48,19, 3,25,18,27,65,
	12,18,61,96,37,93,80,40,44,59,
	73,30,90,92,83,98, 1, 0};
#endif

static MPA *sMPA_INTMAX=NULL;
static MPA MPA_INTMAX = {
	MPA_ID1,MPA_ID2,
	0,  /* opt  */
	40,	/* alen */
	5,	/* len  */
	4,	/* exp */
	0,	/* sign */
	0,	/* zero */
	21,47,48,36,47, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0};

static MPA *sMPA_INTMIN=NULL;
static MPA MPA_INTMIN = {
	MPA_ID1,MPA_ID2,
	0,  /* opt  */
	40,	/* alen */
	5,	/* len  */
	4,	/* exp */
	1,	/* sign */
	0,	/* zero */
	21,47,48,36,48, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0};

static MPA *sMPA_UINTMAX=NULL;
static MPA MPA_UINTMAX = {
	MPA_ID1,MPA_ID2,
	0,  /* opt  */
	40,	/* alen */
	5,	/* len  */
	4,	/* exp */
	0,	/* sign */
	0,	/* zero */
	42,94,96,72,95, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0};

#if defined(_LP64)
static MPA *sMPA_LONGMAX=NULL;
static MPA MPA_LONGMAX = {
	MPA_ID1,MPA_ID2,
	0,  /* opt  */
	40,	/* alen */
	10,	/* len  */
	9,	/* exp */
	0,	/* sign */
	0,	/* zero */
	9,22,33,72, 3,68,54,77,58, 7,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0};

static MPA *sMPA_LONGMIN=NULL;
static MPA MPA_LONGMIN = {
	MPA_ID1,MPA_ID2,
	0,  /* opt  */
	40,	/* alen */
	10,	/* len  */
	9,	/* exp */
	1,	/* sign */
	0,	/* zero */
	9,22,33,72, 3,68,54,77,58, 8,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0};

static MPA *sMPA_ULONGMAX=NULL;
static MPA MPA_ULONGMAX = {
	MPA_ID1,MPA_ID2,
	0,  /* opt  */
	40,	/* alen */
	10,	/* len  */
	9,	/* exp */
	0,	/* sign */
	0,	/* zero */
	18,44,67,44, 7,37, 9,55,16,15,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0};
#endif

static int giG_MI=0;
static MPA *sG_MI[RADIX],G_MIz[RADIX],*G_MI[RADIX];

static int giNMPA2  = NMPA2;
static int giNMPA1  = NMPA1;
static int giNMPA   = NMPA;
static int giNMPA10 = NMPA10;
static int gisizeofMPA    = NMPA1+12;
static int gisizeofMPA10W = NMPA2+8;

/********************************/
/*								*/
/********************************/
int m_set_nmpa10(int m)
{
	giNMPA10 = m;
	if (m <= 0) giNMPA10 = NMPA10;
	else if (giNMPA10 < MIN_NMPA10) giNMPA10 = MIN_NMPA10;
/*	else if (giNMPA10 > NMPA10) giNMPA10 = NMPA10;	*/
	giNMPA  = (giNMPA10+1)/2;
	giNMPA10 = giNMPA + giNMPA;
	giNMPA1 = giNMPA + 1;
	giNMPA2 = giNMPA1 + giNMPA1;
	gisizeofMPA = giNMPA1+12;
	gisizeofMPA = ((gisizeofMPA+sizeof(int)-1)/sizeof(int))*sizeof(int);
	if (gisizeofMPA < sizeof(MPA)) gisizeofMPA = sizeof(MPA);
	gisizeofMPA10W = giNMPA2+8;
	gisizeofMPA10W = ((gisizeofMPA10W+sizeof(int)-1)/sizeof(int))*sizeof(int);
	if (gisizeofMPA10W < sizeof(MPA10W)) gisizeofMPA10W = sizeof(MPA10W);
/*
printf("m_set_nmpa10: giNMPA10=%d giNMPA=%d giNMPA1=%d giNMPA2=%d\n",
giNMPA10,giNMPA,giNMPA1,giNMPA2);
printf("m_set_nmpa10: gisizeofMPA=%d gisizeofMPA10W=%d\n",gisizeofMPA,gisizeofMPA10W);
*/
	if (giNMPA10 > NMPA10) {
		MPA_LOG2 = get_tmpMPA(&sMPA_LOG2,&MPA_LOG2z);
		m_set_a(MPA_LOG2,MPA_LOG2_STR); /* log(2) */
	}
	return giNMPA10;
}

/********************************/
/*								*/
/********************************/
int m_get_nmpa10()
{
	return giNMPA10;
}

/********************************/
/*								*/
/********************************/
int sizeofMPA()
{
	return gisizeofMPA;
}

/********************************/
/*								*/
/********************************/
int sizeofMPA10W()
{
	return gisizeofMPA10W;
}

/********************************/
/*								*/
/********************************/
MPA *get_tmpMPA(MPA **sa,MPA *az)
{
	MPA *aa;

	if (giNMPA10<=NMPA10 && az) aa = az;
	else {
		aa = (MPA *)MRealloc(*sa,gisizeofMPA);
		memset(aa,0,gisizeofMPA);
		*sa = aa;
	}
	memcpy(aa->id,MPA_ID,2);
	aa->alen = gisizeofMPA;
	return aa;
}

/********************************/
/*								*/
/********************************/
MPA10W *get_tmpMPA10W(MPA10W **sw,MPA10W *wz)
{
	MPA10W *ww;

	if (giNMPA10<=NMPA10 && wz) ww = wz;
	else {
		ww = (MPA10W *)MRealloc(*sw,gisizeofMPA10W);
		memset(ww,0,gisizeofMPA10W);
		*sw = ww;
	}
	return ww;
}

/********************************/
/*								*/
/********************************/
MPA *m_get_i(int i)
{
	MPA *a;

	if (!giG_MI) {
		mem_set_addr(sG_MI,NULL,RADIX);
		giG_MI = 1;
	}
	if (i<0 || i>RADIX-1) i = 0;
	a = get_tmpMPA(&sG_MI[i],&G_MIz[i]);
/*	*a = _M0;	*/
	if (i > 0) {
		a->zero = 0;
		a->len = 1;
		a->num[0] = i;
	}
	else a->zero = 1;
	return a;
}

/********************************/
/*								*/
/********************************/
MPA *m_get_MMAX()
{
	MPA *a;
	

	if (giNMPA10 <= NMPA10) a = &_MMAX;
	else {
		a = get_tmpMPA(&_sMMAX,NULL);
		*a = _MMAX;
		a->alen = gisizeofMPA;
		memset(a->num+NMPA,99,giNMPA1-NMPA1);
	}
	return a;
}

/********************************/
/*								*/
/********************************/
MPA *m_get_INTMAX(sign)
int sign;
{
	MPA *a;

	if (giNMPA10 <= NMPA10) {
		if (sign >= 0) a = &MPA_INTMAX;
		else a = &MPA_INTMIN;
	}
	else {
		if (sign >= 0) {
			a = get_tmpMPA(&sMPA_INTMAX,NULL);
			*a = MPA_INTMAX;
		}
		else {
			a = get_tmpMPA(&sMPA_INTMIN,NULL);
			*a = MPA_INTMIN;
		}
		a->alen = gisizeofMPA;
	}
	return a;
}

/********************************/
/*								*/
/********************************/
MPA *m_get_UINTMAX()
{
	MPA *a;

	if (giNMPA10 <= NMPA10) a = &MPA_UINTMAX;
	else {
		a = get_tmpMPA(&sMPA_UINTMAX,NULL);
		*a = MPA_UINTMAX;
		a->alen = gisizeofMPA;
	}
	return a;
}

/********************************/
/*								*/
/********************************/
MPA *m_get_LONGMAX(sign)
int sign;
{
	MPA *a;

#if defined(_LP64)
	if (giNMPA10 <= NMPA10) {
		if (sign >= 0) a = &MPA_LONGMAX;
		else a = &MPA_LONGMIN;
	}
	else {
		if (sign >= 0) {
			a = get_tmpMPA(&sMPA_LONGMAX,NULL);
			*a = MPA_LONGMAX;
		}
		else {
			a = get_tmpMPA(&sMPA_LONGMIN,NULL);
			*a = MPA_LONGMIN;
		}
		a->alen = gisizeofMPA;
	}
#else
	a = m_get_INTMAX(sign);
#endif
	return a;
}

/********************************/
/*								*/
/********************************/
MPA *m_get_ULONGMAX()
{
	MPA *a;

#if defined(_LP64)
	if (giNMPA10 <= NMPA10) a = &MPA_ULONGMAX;
	else {
		a = get_tmpMPA(&sMPA_ULONGMAX,NULL);
		*a = MPA_ULONGMAX;
		a->alen = gisizeofMPA;
	}
#else
	a = m_get_UINTMAX();
#endif
	return a;
}

/********************************/
/*								*/
/********************************/
MPA *m_cpy(MPA *d,MPA *s,int iCHK_DLEN)
{
	int slen,dlen;
/*
printf("m_cpy: d->alen=%d s->alen=%d iCHK_DLEN=%d\n",d->alen,s->alen,iCHK_DLEN);
*/
#if 1
	memcpy(d,s,gisizeofMPA);
#else
	if (!(slen=s->alen)) slen = gisizeofMPA;
	if (iCHK_DLEN) {
		dlen = d->alen;
		if (!(dlen=d->alen)) dlen = gisizeofMPA;
		if (slen > dlen) slen = dlen;
	}
	memcpy(d,s,slen);
#endif
	return d;
}

/********************************/
/*	m_is_mpa0					*/
/********************************/
int m_is_mpa0(MPA *a)
{
	if (!a) return 0;
	return a->zero;
}

/**01****1*********2*********3*********4*********5***/
/*	m_an_to_mpa10_opt	MPA10 <-- "123"				*/
/*  : IN	: opt								*/
/* 					= 0x20 : J}𖳎		*/
/*					= 0x40 : 			*/
/****************************************************/
int m_an_to_mpa10_opt(MPA10W *w, char *s, int len_s, int opt)
{
	char *p,cc,*pnum;
	int c, exp, i, pflag, sign, nzflag, pos, n, j, syo, lens, ret, at;
	char *q;
	int opt2,comma,chk_comma,parm[5];
/*
printf("m_an_to_mpa10_opt: opt=%08x len_s=%d s=[%s]\n",opt,len_s,s);
*/
	if (!w || !s) return -18620101;
#if 1	/* 2018.5.26 */
	ret = 0;
	memset(w,0,gisizeofMPA10W);
	w->zero = 1;
	if ((at=akxqsign(s,len_s,parm,NULL,opt)) < 0) return at;
	if (!(opt & AKX_CNVN_OPT_MSIGN)) ret = parm[2];
	if (at>len_s && !parm[3]) ret = -18620102;
	if (ret) return ret;
	lens = len_s - at + 1;
	p = s + at - 1;
	sign = (1-parm[0])/2;
	nzflag = parm[4];
/*
printf("m_an_to_mpa10_opt: at=%d lens=%d sign=%d,nzflag=%d\n",at,lens,sign,nzflag);
*/
#else
	lens = len_s;
	p = s;
	ret = at = sign = 0;
	nzflag = 1;
	while ((lens > 0) && (cc = *p)) {
		at++;
		if (nzflag == 1) {
			if (cc == '-') {
				if (sign) {
					ret = at;
					break;
				}
				sign = 1;
			}
			else if (cc == '+') {
				if (sign) {
					ret = at;
					break;
				}
				sign = -1;
			}
			else if (cc == '0') nzflag = 0;
			else if (cc!=' ' && cc!='\t') break;
		}
		else {
			if (cc != '0') break;
		}
		p++;
		lens--;
	}
	if (ret) return ret;
	if (sign < 0) sign = 0;
#endif
	opt2 = opt & AKX_CNVN_OPT_COMMA;
	memset(w,0,gisizeofMPA10W);
	pnum = w->num + 1;
	pos = exp = syo = comma = chk_comma = 0;
#if 1	/* 2018.5.22 */
	pflag = 0;
#else
	pflag = nzflag = 0;
#endif
	while ((lens-- > 0) && (cc = *p++)) {
		at++;
		if (cc == '.') {
			if (pflag || comma) {
				ret = at;
				break;
			}
#if 1	/* 2018.5.22 */
			if (!nzflag) syo--;
#else
			if (at==1) syo--;
#endif
			pflag = 1;
			chk_comma = 0;
		}
		else if (cc=='E' || cc=='e') {
			exp += atoi(p);
			break;
		}
		else if (cc == '+' || cc == '-') {
			exp += atoi(p-1);
			break;
		}
		else if (opt2 && cc==',') {
			if (pflag || comma) {
				ret = at;
				break;
			}
			comma = 3;
			chk_comma = 1;
		}
		else {
			c = cc - '0';
			if (c<0 || c>9) {
				ret = at;
				break;
			}
			if (c) nzflag = 1;
			if (nzflag) {
				if (pos < giNMPA10) pnum[pos++] = c;
				else break;		/* add 2021.10.11 */
			}
			else if (syo) syo--;
			if (!pflag) exp++;
			if (chk_comma) comma--;
		}
/*
printf("m_an_to_mpa10_opt: lens=%d cc=%c exp=%d pos=%d syo=%d pflag=%d nzflag=%d\n",lens,cc,exp,pos,syo,pflag,nzflag);
*/
	}
/*
printf("m_an_to_mpa10_opt: sign=%d exp=%d pos=%d syo=%d comma=%d\n",sign,exp,pos,syo,comma);
*/
	if (comma) ret = at;
	if (syo) exp += syo;
	else exp--;
	w->exp  = exp;
	w->sign = sign;
	w->len  = pos+1;
/*
m10w_print("m_an_to_mpa10_opt: ",w,0);
*/
	return ret;
}

/**02************************************/
/*	m_an_to_mpa_opt		MPA <-- "123"	*/
/****************************************/
int m_an_to_mpa_opt(MPA *a, char *s, int len_s, int opt)
{
	static MPA10W *sw=NULL;
	MPA10W wz,*w;
	int ret,at,rc;

	w = get_tmpMPA10W(&sw,&wz);
	ret = m_an_to_mpa10_opt(w,s,len_s,opt);
#if 1 /* 2018.6.17 */
#if 1 /* 2020.6.30 */
	rc = m_10to100(a,w);
	if (rc) ret = rc;
	else {
		rc = m_normalize(a);
		if (rc) ret = rc;
		else if (ret > 0) ret = MPA_ERR_INVALID;
	}
#else
	if (ret > 0) ret = MPA_ERR_INVALID;
	else if (!ret) {
		ret = m_10to100(a,&w);
		if (!ret) {
			ret = m_normalize(a);
		}
	}
#endif
#else
	m_10to100(a,&w);
	if ((at=m_normalize(a)) < 0) ret = at;
#endif
/*
m_print("m_an_to_mpa_opt: ",a,0);
*/
	return ret;
}

/**03********************************/
/*	m_set_an_opt	MPA <-- "123"	*/
/************************************/
int m_set_an_opt(MPA *a, char *s, int len_s, int opt)
{
	return  m_an_to_mpa_opt(a,s,len_s,opt);
}

/**04****************************/
/*	m_set_an	MPA <-- "123"	*/
/********************************/
int m_set_an(MPA *a, char *s, int len_s)
{
	return m_set_an_opt(a, s, len_s, 0);
}

/**05****************************/
/*	m_set_a		MPA <-- "123"	*/
/********************************/
int m_set_a(MPA *a, char *s)
{
	if (!s) return -1;
	return m_set_an(a,s,strlen(s));
}

/**06****************************/
/*	m_pset_an	*MPA <-- "123"	*/
/********************************/
MPA *m_pset_an(MPA *a, char *s, int len)
{
	int ret;
	ret = m_set_an(a,s,len);
	if (ret) return m_get_i(0);
	return a;
}

/**07****************************/
/*	m_pset_a	*MPA <-- "123"	*/
/********************************/
MPA *m_pset_a(MPA *a, char *s)
{
	if (!s) return m_get_i(0);
	return m_pset_an(a,s,strlen(s));
}

/**08****1*********2*********3*********4*********5*********6*********/
/*	@\ : m_mpa10_to_an	"123" <-- mpa10							*/
/*	 : IN : w     : ϊmpa10								*/
/*				s	  ; ϊ̈									*/
/*				len_s : ϊ̈̒(oCg)					*/
/*				opt   : IvV									*/
/*						0x00: _ȉȂƂɏ_ȉ	*/
/*							  \Ȃ							*/
/*						0x01: P̂Ƃɍŏ̂O\ȂB	*/
/*						0x02: _ȉȂƂɏ_\*/
/*						0x04: _ȉȂƂɏPʂ0	*/
/*							  \B							*/
/*						0x20: RɃJ}t				*/
/*	ԋp : >= 0 : ϊ (oCg)								*/
/*		   = -1 : |C^NULL									*/
/*		   = -2 : len_s <= 0										*/
/*	쐬 : 2010/05/27 Akito Kobayashi								*/
/********************************************************************/
int m_mpa10_to_an(MPA10W *w, char *s, int len_s, int opt)
{
	char *p;
	int lens,exp,len,opt20,comma,i0;
	char *pan,c;
/*	MPA10W w;	*/
/*
m10w_print("m_mpa10_to_an: ",w,0);
*/
/*
printf("m_mpa10_to_an:Enter w.zero=%d w.exp=%d w.len=%d\n",w->zero,w->exp,w->len);
*/
	p = s;
	if (!w || !p) return -18620801;
	if ((lens=len_s) <= 0) return -18620802;
	*p = '\0';
	lens--;
	if (w->zero && !w->len) {
		if (opt&0x01) {
			if (lens > 0) {
				if (lens == 1) *p++ = '0';
				else if (lens >= 2) {
					*p++ = '.';
					*p++ = '0';
				}
			}
		}
		else {
			if (lens-- > 0) *p++ = '0';
			if ((opt&(0x02|0x04)) && lens-- > 0) *p++ = '.';
			if ((opt&0x04) && lens-- > 0) *p++ = '0';
		}
	}
	else {
	/*	m_100to10(a,&w); */
		if (w->sign && lens-- > 0) *p++ = '-';
		len = w->len;
/*
printf("m_mpa10_to_an: len=%d\n",len);
*/
#if 1
		if (len > giNMPA2) len = giNMPA2;
#else
		if (len > giNMPA10) len = giNMPA10;
#endif
		len--;	/* Add 2019.7.22 */
		i0 = 1;
		if (w->num[0]) {
			i0 = 0;
			len++;
		}
		pan = w->num + i0;
		if ((exp=w->exp) < 0) {
			if (!(opt&0x01) && lens-- > 0) *p++ = '0';
			if (lens-- > 0) *p++ = '.';
			exp++;
			while (exp++ < 0 && lens-- > 0) *p++ = '0';
			while (len-- > 0 && lens-- > 0) *p++ = *pan++ + '0';
		}
		else {
			if (opt20 = opt & 0x20) {
				if (!(comma = (exp+1) % 3)) comma = 3;
			}
			while (exp-- >= 0 && lens-- > 0) {
				if (len > 0) {
					c = *pan++ + '0';
					len--;
				}
				else c = '0';
				*p++ = c;
				if (opt20) {
					comma--;
					if (comma <= 0) {
						*p++ = ',';
						lens--;
						comma = 3;
					}
				}
			}
			if (*(p-1) == ',') {
				p--;
				lens++;
			}
 			if ((len>0||(opt&(0x02|0x04))) && lens-- > 0) *p++ = '.';
			if (len > 0) {
				while (len-- > 0 && lens-- > 0) *p++ = *pan++ + '0';
			}
			else if ((opt&0x04) && lens>0) *p++ = '0';
		}
	}
	*p = '\0';
/*
printf("m_mpa10_to_an:Exit s=[%s]\n",s);
*/
	return strlen(s);
}

/**09********************************/
/*	m_mpa2an		"123" <-- mpa	*/
/************************************/
int m_mpa2an(MPA *a, char *s, int len_s, int opt)
{
	static MPA10W *sw=NULL;
	MPA10W wz,*w;
	int ret;

	w = get_tmpMPA10W(&sw,&wz);
	if (!(ret=m_100to10(a,w))) ret = m_mpa10_to_an(w,s,len_s,opt);
	return ret;
}

/**10****************************/
/*	m_mpa2scastr				*/
/********************************/
char *m_mpa2scastr(MPA *a, char *s, int len_s, int scale, int opt)
{
	static char buf[70];

	if (!s) {
		s = buf;
		len_s = sizeof(buf);
	}
	m_mpa2ansca(a,s,len_s,scale,opt);
	return s;
}

/**11****1*********2*********3*********4*********5*********6*********/
/*	@\ : m_mpa2an_exp	"1.23E+45" <-- mpa							*/
/*	 : IN : a     : ϊmpa									*/
/*				s     ; ϊ̈									*/
/*				len_s : ϊ̈̒(oCg)					*/
/*						ő pre+10 Kv (-1.2345E+12345)			*/
/*				pre   : ̌(oCg)						*/
/*				inx   : w̌(oCg)						*/
/*				opt   : IvV									*/
/*						0x0004: _ȉȂƂɏPʂ	*/
/*							    0 \B						*/
/*						0x0XXX: ľܓ							*/
/*						0x1XXX: ؎̂								*/
/*						0x2XXX: ؏グ (D)						*/
/*						0x0100: ̉E0TvX			*/
/*	ԋp : >= 0 : ϊ (oCg)								*/
/*		   = -1 : |C^NULL									*/
/*		   = -2 : len_s < 5											*/
/*		   = -3 : pre > 0 ̂Ƃ sca < 0							*/
/*		   = -4 : len_s 									*/
/*	쐬 : 2010/05/27 A.Kobayashi									*/
/*	XV : 2019/09/21 A.Kobayashi Mod not use m_scale()				*/
/*								  Add opt 0x80						*/
/********************************************************************/
int m_mpa2an_exp(MPA *a, char *s, int len_s, int pre, int inx, int opt)
{
	static MPA10W *sw10=NULL;
	MPA10W *w10,w10z;
	int ret;

	w10 = get_tmpMPA10W(&sw10,&w10z);
	if (!a || !s) ret = -18621101;
	else if (!(ret=m_100to10(a,w10))) ret =  m_mpa10_to_exp(w10,s,len_s,pre,inx,opt);
	return ret;
}
/**12**/
int m_mpa10_to_exp(MPA10W *w10, char *s, int len_s, int pre, int inx, int opt)
{
	char *p;
	int lens,exp,len,optw,lenw,scale,len_pre,i,k,n,i0;
	char *pan,c,wrk[12],ww[12];
/*
printf("m_mpa2an_exp:Enter len_s=%d pre=%d sca=%d opt=%08x\n",len_s,pre,inx,opt);
*/
	p = s;
	if (!w10 || !p) return -18621201;
	if ((lens=len_s) < 5) return -18621202;	/* -1E1 */
	if (pre > 0) {
		if (inx < 0) return -18621203;
		else {
			if (pre > giNMPA10) pre = giNMPA10;
			if (lens < (pre+5)) return -18621204;	/* -1.2345E1 */
		}
	}
	*p = '\0';
	p = s + 1;
	m_precision_10(w10,pre,opt);
	len_pre = w10->len;
	/* add 2021.10.13 */
	if (w10->zero && !w10->len) ;
	else {
		if (w10->num[0]) i0 = 0;
		else {
			len_pre--;
			i0 = 1;
		}
	}
	*p++ = w10->num[i0] + '0';
	*p++ = '.';
	lens -= 4;
	if (len_pre > 0) lenw = X_MIN(lens,len_pre-1);
	else lenw = 0;
	if ((opt & 0x04) && lenw<1) lenw = 1;
/*
printf("m_mpa2an_exp:1 lens=%d len=%d len_pre=%d lenw=%d\n",lens,len,len_pre,lenw);
*/
	if (w10->zero) {
		memset(p,'0',lenw);
		p += lenw;
	}
	else {
		i = i0 + 1;
		n = lenw;
		while (n-- > 0) {
			*p++ = w10->num[i++] + '0';
		}
	}
	lens -= lenw;
/*
printf("m_mpa2an_exp:2 lens=%d\n",lens);
*/
	*p = '\0';
	if (inx > 0) {
		if (inx < 5) sprintf(ww,"E+%%0%dd",inx);
		else strcpy(ww,"E+%05d");
		exp = X_ABS(w10->exp);
		if (w10->exp < 0) ww[1] = '-';
		sprintf(wrk,ww,exp);
	}
	else {
		sprintf(wrk,"E%d",w10->exp);
	}
	lenw = strlen(wrk);
/*
printf("m_mpa2an_exp: lenw=%d wrk=[%s]\n",lenw,wrk);
*/
	if (lenw > lens) return -4;
	memcpy(p,wrk,lenw+1);
	if (w10->sign) *s = '-';
	else *s = ' ';
/*
printf("m_mpa2an_exp:Exit s=[%s]\n",s);
*/
	return strlen(s);
}

/**13****************************/
/*	m_mpa2str_exp				*/
/********************************/
char *m_mpa2str_exp(MPA *a, int pre, int inx, int opt)
{
	static char *buf=NULL;
	int ret,len;

	len = pre + inx;
/*
printf("m_mpa2str_exp: len=%d a->len=%d\n",ret,a->len);
*/
	if (pre <= 0) len += a->len*2 + 2;
	if (inx <= 0) len += 6;
	len += 6;
	buf = MRealloc(buf,len);
	ret = m_mpa2an_exp(a, buf, len, pre, inx, opt);
/*
printf("m_mpa2str_exp: ret=%d buf=[%s]\n",ret,buf);
*/
	return buf;
}

/**14****************************/
/*	m_10to100		a <-- w		*/
/********************************/
int m_10to100(MPA *a, MPA10W *w)
{
	int i,ii,exp,n,d,wlen,d0;
	char *p;

	if (!a || !w) return -18621401;
	*a = *m_get_i(0);
/*
	a->exp = w->exp;
*/
	a->len = w->len;
	a->sign = w->sign;
	a->zero = w->zero;
	if (w->zero && !w->len) return 0;
	p = w->num;
	wlen = w->len;
/*
printf("m_10to100: exp=%d wlen=%d\n",w->exp,wlen);
*/
#if 1
	if (wlen > giNMPA2) wlen = giNMPA2;
#else
	if (wlen > giNMPA10) wlen = giNMPA10;
#endif
	wlen--;						/* Add 2019.7.28 */
	if ((exp=w->exp) % 2) {
		p++;
		n = (wlen+1)/2;
		ii = 2;
	}
	else {
		n = wlen/2 + 1;
		ii = 1;
	}
	if (w->num[0]) {
		ii--;
		p--;
	}
	if (n > giNMPA1) n = giNMPA1;	/* Add 2019.7.24 */
	for (i=0;i<n;i++) {
		if (ii <= wlen) d = *(p+1);
		else d = 0;
		if (ii) d0 = *p;
		else d0 = 0;
		a->num[i] = d0*RADIX10 + d;
		p += 2;
		ii += 2;
	}
	if (exp < 0) exp--;
	exp /= 2;
	a->len = n;
/*
printf("m_10to100: exp=%d n=%d\n",exp,n);
*/
	return m_chk_over_under(a,exp);
}

/**15****************************/
/*	m_100to10		a --> w		*/
/********************************/
int m_100to10(MPA *a, MPA10W *w)
{
	int i,exp,v,n,i_p,nn;
	char *p,*q;
/*
printf("m_100to10:Enter exp=%d len=%d zero=%d\n",a->exp,a->len,a->zero);
*/
	if (!a || !w) return -18621501;
	if (memcmp(a->id,MPA_ID,2)) return -18621502;
/*	memset(w->num,0,sizeof(w->num));	*/
	memset(w->num,0,giNMPA2);
	w->exp = a->exp;
	w->len = a->len;
	w->sign = a->sign;
	w->zero = a->zero;
	if (a->zero && !a->len) return 0;
	n = a->len;
	if (n <= 0) return -18621503;
#if 1
	else if (n > giNMPA1) n = giNMPA1;
#else
	else if (n > giNMPA) n = giNMPA;
#endif
	exp = a->exp*2;
	nn = giNMPA2 - (n*2);
	p = w->num;
	i_p = 0;
	if (a->num[0] >= RADIX10) {
		*p++ = '\0';
		i_p++;
		exp++;
		nn--;
	}
	q = a->num;
	for (i=0;i<n;i++) {
		*p++ = (v=*q++)/RADIX10;
		i_p++;
		if (i_p >= giNMPA2) break;	/* 2021.10.11 */
		*p++= v % RADIX10;
		i_p++;
	}
/*	i_p += n*2;	*/
/*
printf("m_100to10: i_p=%d nn=%d\n",i_p,nn);
*/
	n = i_p;
	if (n>2 && !*(p-1)) n--;
	w->exp = exp;
/*	w->len = n - 1;	*/
	if (n > giNMPA2) n = giNMPA2;	/* Add 2019.7.24 */
	w->len = n;		/* Mod 2019.7.22 */
	if (nn > 0) memset(p,0,nn);
/*
printf("m_100to10:Exit w.exp=%d w.len=%d\n",w->exp,w->len);
*/
	return 0;
}

/**16****************************/
/*	m_mul_10					*/
/********************************/
int m_mul_10(MPA *a, int m)
{
	static MPA10W *sw=NULL;
	MPA10W wz,*w;
	int ret;

	w = get_tmpMPA10W(&sw,&wz);
	if (!(ret=m_100to10(a,w))) {
		w->exp += m;
		ret = m_10to100(a,w);
	}
	return ret;
}

/**17****************************/
/*	m_normalize					*/
/********************************/
int m_normalize(MPA *a)
{
	int pos,i,n,exp,sgn;
	char *q,*r;

	if (!a) return -18621701;
	if (memcmp(a->id,MPA_ID,2)) return -18621702;
	sgn = a->sign;
	exp = a->exp;
	pos = a->len;
#if 1
	if (pos > giNMPA1) pos = giNMPA1;
#else
	if (pos > giNMPA) pos = giNMPA;
#endif
	q = a->num + pos - 1;
	while (pos>0 && !*q--) pos--;
	if (pos) {
		i = 0;
		q = a->num;
		while (i<pos && !*q) {
			i++;
			q++;
		}
		if (i > 0) {
			n = i;
			r = a->num;
			for (;i<pos;i++) {
				*r++ = *q;
				*q++ = 0;
			}
			pos -= n;
			exp -= n;
		}
	}
	else {
		a->sign = 0;
		exp  = 0;
		a->zero = 1;
	}
/*	2019.7.17
	if (pos > giNMPA) {
		pos = giNMPA;
		a->num[pos] = 0;
	}
*/
	a->len  = pos;
/*
m_print("m_normalize: ",a,0);
*/
#if 1
	return m_chk_over_under(a,exp);
#else
	if (exp > MAXEXP) {
		*a = _MMAX;
		a->sign = sgn;
		return MPA_ERR_OVERFLOW;
	}
	else if(exp < MINEXP) {
		*a = m_get_i(0);
		return MPA_ERR_UNDERFLOW;
	}
	a->exp = exp;
	return 0;
#endif
}

/**18****************************/
/*								*/
/********************************/
int m_chk_over_under(MPA *a, int exp)
{
	int ret;
	char sgn;

	if (exp > MAXEXP) {
		sgn = a->sign;
		*a = *m_get_MMAX();
		a->sign = sgn;
		ret = MPA_ERR_OVERFLOW;
	}
	else if(exp < MINEXP) {
		*a = *m_get_i(0);
		ret = MPA_ERR_UNDERFLOW;
	}
	else {
		a->exp = exp;
		ret = 0;
	}
	return ret;
}

/**19****************************/
/*								*/
/********************************/
int m_cmp(MPA *a, MPA *b)
{
	int mca;

	if (!a || !b) return -18621901;
	if (memcmp(a->id,MPA_ID,2) || memcmp(b->id,MPA_ID,2)) return -18621902;
	if (a->zero) {
		if (b->zero) return 0;
		return (b->sign)? 1: -1;
	}
	if (b->zero) return (a->sign)? -1: 1;
	if (a->sign == b->sign) {
		mca = m_cmp_a(a, b);
		return (a->sign)? -mca: mca;
	}
	return (a->sign)? -1: 1;
}

/**20************************************/
/*	m_cmp_a		compare |MPA| vs |MPA|	*/
/****************************************/
int m_cmp_a(MPA *aa, MPA *bb)
{
	int i,a_exp,b_exp;
	char *p, *q;

	if (!aa || !bb) return -18622001;
	if (memcmp(aa->id,MPA_ID,2) || memcmp(bb->id,MPA_ID,2)) return -18622002;
	if (aa->zero) return (bb->zero)? 0: -1;
	if (bb->zero) return 1;
	if ((a_exp=aa->exp) > (b_exp=bb->exp)) return 1;
	else if (a_exp < b_exp) return -1;

	for(i = 0, p = aa->num, q = bb->num; i <= giNMPA; i++, p++, q++)
		if(*p != *q) return (*p > *q)? 1: -1;
	return 0;
}

/**21************************************/
/*	m_add		MPA c <-- MPA a + MPA b	*/
/****************************************/
int m_add(MPA *c, MPA *a, MPA *b)
{
	int cmp,ret;
/*
m_print("m_add:a: ",a,0);
m_print("m_add:b: ",b,0);
*/
	if (!a || !b) return -18622101;
	if (memcmp(a->id,MPA_ID,2) || memcmp(b->id,MPA_ID,2)) return -18622102;
	if(a->zero)	{
		m_cpy(c,b,0);
		return 0;
	}
	else if (b->zero) {
		m_cpy(c,a,0);
		return 0;
	}
	ret = 0;
	if (a->sign == b->sign) {
		ret = m_add_a(c, a, b);
		c->sign = a->sign;
	}
	else {
		cmp = m_cmp_a(a, b);
		if(!cmp) {
			*c = *m_get_i(0);
			return 0;
		}
		else if (cmp > 0) {
			ret = m_sub_a(c, a, b);
			c->sign = a->sign;
		}
		else {
			ret = m_sub_a(c, b, a);
			c->sign = b->sign;
		}
	}
/*
m_print("m_add:c: ",c,0);
*/
	return ret;
}

/**22************************************/
/*	m_sub		MPA c <-- MPA a - MPA b	*/
/****************************************/
int m_sub(MPA *c, MPA *a, MPA *b)
{
	int cmp,ret;

	if (!a || !b) return -18622201;
	if (memcmp(a->id,MPA_ID,2) || memcmp(b->id,MPA_ID,2)) return -18622202;
	if (a->zero) {
		if (b->zero) {
			*c = *m_get_i(0);
			return 0;
		}
		m_cpy(c,b,0);
		c->sign = 1 - c->sign;
		return 0;
	}
	if (b->zero) {
		m_cpy(c,a,0);
		return 0;
	}
	else if (a->sign != b->sign) {
		ret = m_add_a(c, a, b);
		c->sign = a->sign;
		return ret;
	}
	cmp = m_cmp_a(a, b);
	if (!cmp) {
		*c = *m_get_i(0);
		return 0;
	}
	else if (cmp > 0) {
		ret = m_sub_a(c, a, b);
		c->sign = a->sign;
		return ret;
	}
	ret = m_sub_a(c, b, a);
	c->sign = 1 - b->sign;
	return ret;
}

/**23********************************************/
/*	m_add_a		MPA ans <-- |MPA a| + |MPA b|	*/
/************************************************/
int m_add_a(MPA *ans, MPA *a, MPA *b)
{
	static MPA *sc=NULL;
	MPA cz,*c,*pc,*pa,*pb;
	char *pan,*pbn;
	int i, u, n, ia, ib, ia1, len1;

	if (!ans || !a || !b) return -18622301;
	if (memcmp(a->id,MPA_ID,2) || memcmp(b->id,MPA_ID,2)) return -18622302;
	if (a->zero) {
		m_cpy(ans,b,0);
		return 0;
	}
	if (b->zero) {
		m_cpy(ans,a,0);
		return 0;
	}
	c = get_tmpMPA(&sc,&cz);
	if (a->exp >= b->exp) {
		m_cpy(c,a,0);
		pb = b;
	}
	else {
		m_cpy(c,b,0);
		pb = a;
	}
	pa = c;
	c->zero = 0;
	ib = pb->len - 1;
	if ((ia=pa->exp-pb->exp+ib) > giNMPA) {
		ib -= ia-giNMPA;
		ia = giNMPA;
	}
	if (ib < 0) {
		m_cpy(ans,c,0);
		return 0;
	}
	len1 = pa->len - 1;
	ia1 = ia + 1;
	pbn = pb->num + ib;
	pan = pa->num + ia;
	u = 0;
	while (ib-- >= 0) {
		u += *pbn--;
		if (ia-- <= len1) u += *pan;
		if ((n=u) >= RADIX) {
			n = u - RADIX;
			u = 1;
		}
		else u = 0;
		*pan-- = n;
	}
	if (u) {
		while (ia-- >= 0) {
			u += *pan;
			if ((n=u) >= RADIX) {
				*pan-- = u - RADIX;
				u = 1;
			}
			else {
				*pan-- = n;
				u = 0;
				break;
			}
		}
		if (u) {
#if 1
			if (ia1 > pa->len) pa->len = ia1;
#endif
			if (pa->len < giNMPA) pa->len++;
			i = pa->len - 1;
			pan = pa->num + i;
			pbn = pan - 1;
			while (i-- > 0) *pan-- = *pbn--;
			pa->num[0] = u;
			pa->exp++;
		}
	}
	if (ia1 > pa->len) pa->len = ia1;
	m_cpy(ans,c,0);
/*
m_print("m_add_a:ans: ",ans,0);
*/
	return m_normalize(ans);
}

/**24********************************************/
/*	m_sub_a		MPA ans <-- |MPA a| - |MPA b|	*/
/************************************************/
int m_sub_a(MPA *ans, MPA *a, MPA *b)
{
	static MPA *sc=NULL;
	MPA cz,*c,*pc,*pa,*pb;
	char *pan,*pbn;;
	int u, n, ia, ib, ia1, len1, len;

	if (!ans || !a || !b) return -18622401;
	if (memcmp(a->id,MPA_ID,2) || memcmp(b->id,MPA_ID,2)) return -18622402;
	c = get_tmpMPA(&sc,&cz);
	pa = c;
	pb = b;
	m_cpy(c,a,0);
	ib = pb->len - 1;
	if ((ia=pa->exp-pb->exp+ib) > giNMPA) {
		ib -= ia-giNMPA;
		ia = giNMPA;
	}
	if (ib < 0) {
		m_cpy(ans,c,0);
		return 0;
	}
	len = pa->len;
	len1 = len - 1;
	ia1 = ia + 1;
	u = 0;
	pbn = pb->num + ib;
	pan = pa->num + ia;
	while (ib-- >= 0) {
		u -= *pbn--;
		if (ia-- <= len1) u += *pan;
		if ((n=u) < 0) {
			n = u + RADIX;
			u = -1;
		}
		else u = 0;
		*pan-- = n;
	}
	if (u) {
		while (ia-- >=0) {
			u = *pan + u;
			if ((n=u) < 0) {
				*pan-- = u + RADIX;
				u = -1;
			}
			else {
				*pan-- = n;
				u = 0;
				break;
			}
		}
		if (u) {
			*ans = *m_get_i(0);
/*
m_print("*** a ***",a,0);
m_print("*** b ***",b,0);
*/
			return MPA_ERR_A_LT_B;
		}
	}
	if (ia1 > len) pa->len = ia1;
	m_cpy(ans,c,0);
	return m_normalize(ans);
}

/**25****************************/
/*	m_add1		MPA a += MPA b	*/
/********************************/
int m_add1(MPA *a, MPA *b)
{
	return m_add(a,a,b);
}

/**26****************************/
/*	m_sub1		MPA a -= MPA b	*/
/********************************/
int m_sub1(MPA *a, MPA *b)
{
	return m_sub(a,a,b);
}

/**27********************************/
/*	m_add1_a.c	|MPA a| += |MPA b|	*/
/************************************/
int m_add1_a(MPA *a, MPA *b)
{
	return m_add_a(a,a,b);
}

/**28********************************/
/*	m_sub1_a	|MPA a| -= |MPA b|	*/
/************************************/
int m_sub1_a(MPA *a, MPA *b)
{
	return m_sub_a(a,a,b);
}

/**29****************************************/
/*	m_mul		MPA ans <-- MPA a * MPA b	*/
/********************************************/
int m_mul(MPA *ans, MPA *a, MPA *b)
{
	static MPA *sc=NULL;
	static int *sx=NULL;
	MPA cz,*c;
	int i, j, m, *r, *xp, u, v, exp, ret;
	int xz[NMPA2],*x;
	char *p, *q;

	if (!ans || !a || !b) return -18622901;
	if (memcmp(a->id,MPA_ID,2) || memcmp(b->id,MPA_ID,2)) return -18622902;
	if (a->zero || b->zero) {
		*ans = *m_get_i(0);
		return 0;
	}
/*
m_print("m_mul:a: ",a,0);
m_print("m_mul:b: ",b,0);
*/
	if (giNMPA10 <= NMPA10) x = xz;
	else {
		sx = (int *)MRealloc(sx,giNMPA2*sizeof(int));
		x = sx;
	}
	c = get_tmpMPA(&sc,&cz);
  if (b->len==1 && ((v=b->num[0])==1 || v==10)) {
	m_cpy(c,a,0);
  	if (v == 10) m_mul_10(c,1);
	exp = (int)c->exp + (int)b->exp;
  }
  else if (a->len==1 && ((v=a->num[0])==1 || v==10)) {
  	m_cpy(c,b,0);
  	if (v == 10) m_mul_10(c,1);
	exp = (int)a->exp + (int)c->exp;
  }
  else {
	mem_set_int(x,0,giNMPA2);
/*	memset(x,0,sizeof(x));	*/
	m = a->len + b->len - 1;
	if (m >= giNMPA2) m = giNMPA2 - 1;
	for (i=b->len-1, xp=x+m, p=b->num+i; i>=0; i--, xp--, p--) {
		if ((v = *p)) {
			j = a->len - 1;
			q = a->num + j;
			r = xp;
			if (v == 1) {
				while (j-- >= 0) *r-- += *q--;
			}
			else if (v == 2) {
				while (j-- >= 0) {
					u = *q--;
					if (u) *r += u<<1;
					r--;
				}
			}
			else if (v == 4) {
				while (j-- >= 0) {
					u = *q--;
					if (u) *r += u<<2;
					r--;
				}
			}
			else if (v == 8) {
				while (j-- >= 0) {
					u = *q--;
					if (u) *r += u<<3;
					r--;
				}
			}
			else if (v == 16) {
				while (j-- >= 0) {
					u = *q--;
					if (u) *r += u<<4;
					r--;
				}
			}
			else if (v == 32) {
				while (j-- >= 0) {
					u = *q--;
					if (u) *r += u<<5;
					r--;
				}
			}
			else if (v == 64) {
				while (j-- >= 0) {
					u = *q--;
					if (u) *r += u<<6;
					r--;
				}
			}
			else {
				while (j-- >= 0) {
					u = *q--;
					if (u) *r += u * v;
					r--;
				}
			}
		}
	}
	*c = *m_get_i(0);
	i = m;
	xp = x + i;
	p = c->num + i;
	u = 0;
	while (i >= 0) {
		if (i == giNMPA) u += 5;
		*xp += u;
		if (*xp >= RADIX) {
			u = *xp/RADIX;
			*xp %= RADIX;
		}
		else u = 0;
		if (i-- < giNMPA) *p = *xp;
		p--;
		xp--;
	}
	if ((c->len=m+1) > giNMPA1) c->len = giNMPA1;
	exp = (int)a->exp + (int)b->exp + 1;
  }
	c->zero = 0;
	c->sign = (a->sign == b->sign)? 0: 1;
#if 1
	m_cpy(ans,c,0);
	if (ret = m_chk_over_under(ans,exp)) return ret;
#else
	if (exp > MAXEXP) {
		*ans = _MMAX;
		return MPA_ERR_OVERFLOW;
	}
	else if(exp < MINEXP) {
		*ans = *m_get_i(0);
		return MPA_ERR_UNDERFLOW;
	}
	c->exp = exp;
	m_cpy(ans,c,0);
#endif
	return m_normalize(ans);
}

/**30****************************************/
/*	m_div		MPA ans <-- MPA a / MPA b	*/
/********************************************/
int m_div(MPA *ans, MPA *aa, MPA *bb)
{
	static int init_smd=0;
	static MPA *sc=NULL, *sa=NULL, *sb=NULL, *smd[RADIX];
	MPA cz, az, bz, mdz[RADIX];
	MPA *c, *a, *b, *md[RADIX];
	int d, i, exp, zmd[RADIX+1], anm, bnm, ret;
	char *pcn;
	short sign;

	if (!ans || !aa || !bb) return -18623001;
	if (memcmp(aa->id,MPA_ID,2) || memcmp(bb->id,MPA_ID,2)) return -18623002;
	b = get_tmpMPA(&sb,&bz);
	m_cpy(b,bb,0);
	if ((ret=m_normalize(b))==-18621701 || ret==-18621702) return ret;
	if (b->zero)	{
		*ans = _MMAX;
		return MPA_ERR_ZERODIVIDE;
	}
	a = get_tmpMPA(&sa,&az);
	m_cpy(a,aa,0);
	if ((ret=m_normalize(a))==-18621701 || ret==-18621702) return ret;
	if (a->zero)	{
		*ans = *m_get_i(0);
		return 0;
	}
	c = get_tmpMPA(&sc,&cz);
	*c = *m_get_i(0);
	c->zero = 0;
	sign = (a->sign == b->sign)? 0: 1;
	a->sign = b->sign = 0;

	exp = (int)a->exp - (int)b->exp;
#if 1
	ans->sign = sign;
	if (ret = m_chk_over_under(ans,exp)) return ret;
#else
	if (exp > MAXEXP) {
		*ans = _MMAX;
		ans->sign = sign;
		return MPA_ERR_OVERFLOW;
	}
	else if(exp < MINEXP) {
		*ans = *m_get_i(0);
		return MPA_ERR_UNDERFLOW;
	}
#endif

  if (b->len==1 && ((d=b->num[0])==1 || d==10)) {
  	m_cpy(c,a,0);
	c->exp = exp;
	if (d == 10) {
		m_mul_10(c,-1);
	/*	c.exp -= b.exp;	*/
	}
  }
  else {
	if (!init_smd) {
		mem_set_addr(smd,NULL,RADIX);
		init_smd = 1;
	}
	memset(zmd,0,sizeof(zmd));
	bnm = b->num[0]*RADIX + b->num[1];
	c->exp = exp;
	a->exp = b->exp = 0;
	for (i=0,pcn=c->num;i<=giNMPA;) {
/*
m_print("*** a ***",&a,0);
*/
		anm = a->num[0]*RADIX + a->num[1];
#if 1	/* 2018.6.26 */
		if (anm<bnm && a->exp==1)
#else
		if (a->exp == 1)
#endif
			anm = anm*RADIX + a->num[2];
		d = anm/bnm;
/*
printf("m_div: i=%d anm=%d bnm=%d d=%d\n",i,anm,bnm,d);
*/
		if (d > 0) {
			while (d > 0) {
/*
printf("m_div: i=%d anm=%d bnm=%d d=%d\n",i,anm,bnm,d);
*/
				if (!zmd[d]) {
					md[d] = get_tmpMPA(&smd[d],&mdz[d]);
					if (d == 1) m_cpy(md[d],b,0);
					else if (d < RADIX) m_mul(md[d],b,m_get_i(d));
					else {
						m_cpy(md[d],b,0);
						md[d]->exp++;
					}
					zmd[d] = 1;
/*
m_print("*** md[d] ***",md[d],0);
*/
				}
				if (m_cmp(a,md[d]) >= 0) {
					m_sub1(a,md[d]);
					break;
				}
				d--;
			}
		}
		a->exp++;
		*pcn++ = d;
		i++;
		if (a->zero) break;
	}
	c->len = i;
  }
  	c->sign = sign;
	m_cpy(ans,c,0);
	ret = m_normalize(ans);
	return ret;
}

/**31****************************/
/*	m_mul1		MPA a *= MPA b	*/
/********************************/
int m_mul1(MPA *a, MPA *b)
{
	return m_mul(a,a,b);
}

/**32****************************/
/*	m_div1		MPA a /= MPA b	*/
/********************************/
int m_div1(MPA *a, MPA *b)
{
	return m_div(a,a,b);
}

/**33********************************/
/*	m_pack			DEC a <-- MPA b	*/
/************************************/
#if 1
int m_pack(char *a, int precision, int scale, int opt, MPA *b)
{
#if 1	/* 2021.1.2 */
	int i;
	static MPA *sbb=NULL;
	MPA bbz,*bb;

	if (!a || !b) return -18623301;
	if (memcmp(b->id,MPA_ID,2)) return -18623302;
	bb = get_tmpMPA(&sbb,&bbz);
	m_cpy(bb,b,0);
	if ((i=m_scale(bb,precision,scale,opt)) < 0) return i;
	return m_pack_size(a,bb,precision,scale);
#else
	int i,size,pos,dsize,mode;
	char *pam,*pbm,c1,c2;
	MPA bb;
	MPA10W w;

	if (!a || !b) return -1;
	bb = *b;
	if ((i=m_scale(&bb,precision,scale,opt)) < 0) return i;
	m_100to10(&bb,&w);
	pos = precision - (w.exp + 1);
	if (scale > 0) pos -= scale;
	if (pos < 0) return -2;

	pam = a;
	pbm = w.num + 1;
	dsize = (precision+2)/2;
	memset(pam,0,dsize);
	if (!(precision % 2)) pos++;
	mode = pos % 2;
	pos >>= 1;
	pam += pos;
	c1 = 0;
	for (i=0;i<w.len;i++) {
		if (mode) {
			*pam++ = c1<<4 | *pbm++;
			mode = 0;
			pos++;
			if (pos >= dsize) return -3;
		}
		else {
			c1 = *pbm++;
			mode = 1;
		}
	}
	if (mode) *pam = c1<<4;
	if (bb.sign) c2 = 0x0d;
	else c2 = 0x0c;
	pam = a + dsize - 1;
	*pam |= c2;
	return dsize;
#endif
}
#else
int m_pack(char *a, int dec_size, int scale, int opt, MPA *b)
{
	int i,len,size,ret,dsize;
	char *pam,*pbm,c1,c2;
	static MPA10W *w=NULL;

	if (!a || !b) return -1;
	w = MRealloc(w,gisizeofMPA10W);
	m_100to10(b,w);
	pam = a;
/*	pbm = b->num;	*/
	pbm = w->num + 1;
	size = w->len;
	len = size/2;
	ret = len + 1;
	if (dec_size > 0) {
		if (size > dec_size) return MPA_ERR_SIZE_OVER;
		dsize = dec_size/2 + 1;
		for (i=0;i<dsize-ret;i++) *pam++ = '\0';
	}
	else dsize = ret;
	if (!(size % 2)) {
		c1 = *pbm++;
		*pam++ = c1 & 0x0f;
		len--;
	}
	for (i=0;i<len;i++) {
		c1 = *pbm++;
		c2 = *pbm++;
		*pam++ = c1<<4 | (c2 & 0x0f);
	}
	c1 = *pbm;
	if (b->sign) c2 = 0x0d;
	else c2 = 0x0c;
	*pam = c1<<4 | (c2 & 0x0f);
	return dsize;
}
#endif

/**34********************************/
/*	m_pack_size		DEC a <-- MPA b	*/
/* scale<-NMPA10 ̂Ƃ́AscalegpȂ*/
/************************************/
#if 1	/* 2021.1.2 */
int m_pack_size(char *a, MPA *b, int dec_size, int scale)
#else
int m_pack_size(char *a, int dec_size, MPA *b)
#endif
{
	int i,len,size,ret,dsize;
	char *pam,*pbm,c1,c2;
	static MPA10W *sw=NULL;
	MPA10W wz,*w;

	if (!a || !b) return -18623401;
	if (memcmp(b->id,MPA_ID,2)) return -18623402;
	w = get_tmpMPA10W(&sw,&wz);
	m_100to10(b,w);
m10w_print("m_pack_size: b10w=",w,0);
	pam = a;
/*	pbm = b->num;	*/
	pbm = w->num + 1;
	if (scale >= -giNMPA10) {	/* 2021.4.3 */
		size = w->exp + scale + 1;
		if (size <= 0) {
			dsize = dec_size/2 + 1;
			memset(a,0,dsize);
			a[dsize-1] = 0x0c;
			return dsize;
		}
	}
	else size = w->len - 1;

	len = size/2;
	ret = len + 1;
	if (dec_size > 0) {
#if 0	/* 2020.11.29 */ /* 2021.1.2 1-->0 */
		if (size > dec_size) {
			size = dec_size;
			len = size/2;
			ret = len + 1;
		}
#else
		if (size > dec_size) return MPA_ERR_SIZE_OVER;
#endif
		dsize = dec_size/2 + 1;
		for (i=0;i<dsize-ret;i++) *pam++ = '\0';
	}
	else dsize = ret;
	if (!(size % 2)) {
		c1 = *pbm++;
		*pam++ = c1 & 0x0f;
		len--;
	}
	for (i=0;i<len;i++) {
		c1 = *pbm++;
		c2 = *pbm++;
		*pam++ = c1<<4 | (c2 & 0x0f);
	}
	c1 = *pbm;
	if (b->sign) c2 = 0x0d;
	else c2 = 0x0c;
	*pam = c1<<4 | (c2 & 0x0f);
	return dsize;
}

/**35********************************/
/*	m_unpack	MPA a <-- DEC b		*/
/************************************/
int m_unpack(MPA *a, char *b, int size, int scale)
{
	int i,len,a_len,a_exp;
	char *pam,*pbm,c,d,m;
	static MPA10W *sw=NULL;
	MPA10W wz,*w;

	if (!a || !b) return -18623501;
	*a = *m_get_i(0);
	m = '\0';
	w = get_tmpMPA10W(&sw,&wz);
/*	pam = a->num;	*/
	pam = w->num + 1;
	w->num[0] = '\0';
	pbm = b;
	len = size/2;
	if (!(size % 2)) {
		c = *pbm++;
		*pam++ = d = c & 0x0f;
		if (d > 9) return MPA_ERR_INVALID;
		len--;
		m |= c;
	}
	for (i=0;i<len;i++) {
		c = *pbm++;
		*pam++ = d = c>>4 & 0x0f;
		if (d > 9) return MPA_ERR_INVALID;
		*pam++ = d = c & 0x0f;
		if (d > 9) return MPA_ERR_INVALID;
		m |= c;
	}
	c = *pbm;
	*pam = d = c>>4 & 0x0f;
	if (d > 9) return MPA_ERR_INVALID;
	m |= d;
	c &= 0x0f;
	if (c == 0x0d) w->sign = 1;
	else if (c==0x0c || !c) w->sign = 0;
	else return -1;
	w->exp = size - scale - 1;
	w->len = size + 1;
	if (m) w->zero = 0;
	else w->zero = 1;
	m_10to100(a,w);
	return m_normalize(a);
}

/**36****************************/
/*	m_mpa2d						*/
/********************************/
int m_mpa2d(MPA *a, double *dval)
{
	double d;
	int i,exp,ret;
	char *p, *q;

	if (!a) return -18623601;
	if (memcmp(a->id,MPA_ID,2)) return -18623602;
	if (a->zero) {
		*dval = 0.0;
		return 0;
	}
	exp = a->exp;
/*
printf("m_mpa2d: exp=%d\n",exp);
*/
	if (exp<-162 || exp>154) {
		if (exp < -162) {
			d = MINREGDBL;
			ret = MPA_ERR_UNDERFLOW;
		}
		else {
			d = MAXDOUBLE;
			ret = MPA_ERR_OVERFLOW;
		}
		if (a->sign) d = -d;
		*dval = d;
		return ret;
	}
	p = a->num;
	i = a->len - 1;
	if (i > 17) i = 17;
	d = (double)*p++;
	while (i-- > 0) {
		d = d * (double)RADIX + (double)*p++;
		exp--;
	}
	ret = 0;
	if (exp) {
		if (exp>=-MAXEXPLOOP && exp<=MAXEXPLOOP) {
			while (exp > 0) {
				d *= (double)RADIX;
				exp--;
			}
			while (exp < 0) {
				d /= (double)RADIX;
				exp++;
			}
		}
		else {
			d *= pow((double)RADIX,(double)exp);
			if (isinf(d)) {
				d = MAXDOUBLE;
				ret = MPA_ERR_OVERFLOW;
			}
			else if (d == 0.0) {
				ret = MPA_ERR_UNDERFLOW;
			}
/*
printf("m_mpa2d: exp=%d d=%e\n",exp,d);
*/
		}
	}
	if (a->sign) d = -d;
	*dval = d;
	return ret;
}

/**37**/
int m_dset(double *dval, MPA *a)
{
	return m_mpa2d(a, dval);
}

/**38****************************/
/*	m_mpa2l					*/
/********************************/
int m_mpa2l(MPA *a, long *val)
{
	int ret, i, exp;
	long d,pre_long_max,pre_long_max10;
	char *p,c;

	if (!a || !val) return -18623801;
	if (memcmp(a->id,MPA_ID,2)) return -18623802;
	*val = 0;
	if (a->zero || a->exp < 0) return 0;
	exp = a->exp;
	p = a->num;
	i = a->len - 1;
	d = *p++;
	ret = 0;
	pre_long_max = LONG_MAX/RADIX +1;
	pre_long_max10 = LONG_MAX/RADIX10 +1;
	while (exp-- > 0) {
		if (d >= pre_long_max) {
			if (d >= pre_long_max10) {
				ret = MPA_ERR_OVERFLOW_I;
				break;
			}
			if (d*RADIX10 >= pre_long_max10) {
				ret = MPA_ERR_OVERFLOW_I;
				break;
			}
		}
		d *= RADIX;
		if (i-- > 0) d += *p++;
		if (d < 0) {
			ret = MPA_ERR_OVERFLOW_I;
			break;
		}
	}
	if (ret) {
		if (a->sign) d = LONG_MIN;
		else d = LONG_MAX;
	}
	else if (a->sign) d = -d;
	*val = d;
	return ret;
}

/**39****************************/
/*	m_mpa2i						*/
/********************************/
int m_mpa2i(MPA *a, int *val)
{
	int ret,rc;
	long l=0;

	ret = m_mpa2l(a,&l);
/*	*val = l;	*/
	if (rc = akx_chk_int_over(l,val)) ret = MPA_ERR_OVERFLOW;
	return ret;
}

/**40****************************/
/*	m_l2mpau					*/
/********************************/
int m_l2mpau(long val, MPA *a, int iU)
{
	long n;
	ulong un;
	int  exp, len, w, adjust;
	char *p, *q;

	*a = *m_get_i(0);
	if(!(n=val)) return 0;
	un = n;
	a->zero = 0;
	if (!iU) {
		adjust = 0;
		if (n < 0) {
			a->sign = 1;
			if (n == LONG_MIN) {
				n += 1;
				adjust = 1;
			}
			n = -n;
		}
	}
	exp = len = 0;
	p = q = a->num;
	while (n && un) {
		if (iU) {
			*p++ = un % RADIX;
			un /= RADIX;
		}
		else {
			*p++ = n % RADIX + adjust;
			n /= RADIX;
			adjust = 0;
		}
		exp++;
		len++;
	}
	exp--;
	p--;
	while(q < p) {
		w = *p;
		*p-- = *q;
		*q++ = w;
	}
	a->exp = exp;
	a->len = len;
	return m_normalize(a);
}

/**41****************************/
/*	m_i2mpa						*/
/********************************/
int m_i2mpa(int val, MPA *a)
{
	return m_l2mpa((long)val, a);
}

/**42****************************/
/*	m_ll2mpa					*/
/********************************/
int m_ll2mpa(off_t val, MPA *a)
{
	off_t n;
	int exp, len, w, adjust;
	long v[2], v1, v2;
	char *p, *q;

	if (sizeof(off_t) == sizeof(long)) return m_l2mpa(val,a);
	*a = *m_get_i(0);
	if(!(n=val)) return 0;
	a->zero = 0;
	adjust = 0;
	if (n < 0) {
		a->sign = 1;
		if (n == MPA_LONG_MIN) {
			n += 1;
			adjust = 1;
		}
		n = -n;
	}

	memcpy(v,&n,sizeof(off_t));
	if (1 == htonl(1)) {
		v1 = v[0];
		v2 = v[1];
	}
	else {
		v1 = v[1];
		v2 = v[0];
	}
	if (!v1) return m_l2mpa(v2,a);

	exp = len = 0;
	p = q = a->num;
	while (n) {
		*p++ = n % RADIX + adjust;
		n /= RADIX;
		exp++;
		len++;
		adjust = 0;
	}
	exp--;
	p--;
	while(q < p) {
		w = *p;
		*p-- = *q;
		*q++ = w;
	}
	a->exp = exp;
	a->len = len;
	return m_normalize(a);
}

/**43****************************/
/*	m_d2mpa						*/
/********************************/
int m_d2mpa(double d, MPA *m)
{
	int i,exp;
	char *p;
	double a,a1;

	a = d;
	*m = *m_get_i(0);
	if (a == 0.) return 0;
	m->zero = 0;
	if (a < 0.) {
		m->sign = 1;
		a = - a;
	}
#if 1	/* 2022.8.20 */
  exp = log(a)/log((double)RADIX);
  if (exp>=-MAXEXPLOOP && exp<=MAXEXPLOOP) {
#endif
	exp = 0;
	while (a >= (double)RADIX) {
		exp++;
		a /= (double)RADIX;
	}
	while (a < 1.) {
		exp--;
		a *= (double)RADIX;
	}
#if 1	/* 2022.8.20 */
  }
  else {
	if (exp > 0) {
	/*	exp--;	*/
		a /= pow((double)RADIX,(double)exp);
	}
	else if (exp < 0) {
	/*	exp++;	*/
		a /= pow((double)RADIX,(double)(exp));
	}
/*
printf("m_d2mpa: exp=%d a=%e\n",exp,a);
*/
  }
#endif
	p = m->num;
	i = 0;
	a1 = a * 1.0e-16;
/*
printf("m_d2mpa: a=%e\n",a);
*/
	do {
		i++;
		*p = (int)a;
		a -= (double)*p++;
/*
printf("m_d2mpa: i=%d a=%e\n",i,a);
*/
		if (a <= a1) break;
		a *= (double)RADIX;
	} while(a != 0. && i <= 8);	/* giNMPA); */
	m->len = i;
	for (i++; i <= giNMPA; i++) *p++ = 0;
	m->exp = exp;
	return m_normalize(m);
}

/**44****************************/
/*	m_scale						*/
/********************************/
int m_scale(MPA *mpa,int pre_size,int scale,int opt)
/* opt=0x00:ľܓ/0x01:؎̂/0x02:؏グ  */
/*	   0x10 : I[o[t[Al͂̂܂܂ƂB*/
{
	static MPA *sp5=NULL;
	MPA p5z,*p5;
	static MPA10W *sw=NULL,*sp5w=NULL;
	MPA10W wz,*w,p5wz,*p5w;
	int pre_exp,i,sign,len,exp,precision,ret;
	char *p;

XPRINTOUTL3(100,"m_scale:Enter pre_sixe=%d scale=%d opt=%08x",pre_size,scale,opt);

	if (!mpa) return -1001;
	if (memcmp(mpa->id,MPA_ID,2)) return -1005;
#if 0
	if (!pre_size) return 0;
	precision = X_ABS(pre_size);
#else
	precision = pre_size;
	if (precision<=0 || precision>giNMPA10) return -1002;
#endif
#if 1
	if (scale >= 0) {
		if (scale > precision) return -1003;
	}
	else {
		if (-scale >= precision) return -1004;
	}
#endif

m_print("m_scale:Enter mpa", mpa,0);

	w = get_tmpMPA10W(&sw,&wz);
	m_100to10(mpa,w);

m10w_print("m_scale:Enter w", w,0);

/*
printf("m_scale: zero=%d exp=%d len=%d precision=%d scale=%d\n",w.zero,w.exp,w.len,precision,scale);
*/
#if 1
	if (w->zero) {
		w->zero = 0;
		w->exp = -scale;
		if (w->exp > 0) w->exp++;
	/*	else if (w->exp < 0) w->exp--;	*/
		w->len = 2;
		w->num[1] = 0;
		m_10to100(mpa,w);
		mpa->zero = 1;
/*
printf("m_scale: zero=%d exp=%d len=%d\n",mpa->zero,mpa->exp,mpa->len);
*/
		return 0;
	}
#else
	if (mpa->zero) return 0;
#endif
	if ((opt & 0x03) != 0x01) {
		p5 = get_tmpMPA(&sp5,&p5z);
		p5w = get_tmpMPA10W(&sp5w,&p5wz);
		memcpy(p5,m_get_i(1),gisizeofMPA);
		p5->sign = w->sign;
		m_100to10(p5,p5w);
		if (opt & 0x02) {
			i = w->exp + 2 + scale;	/* 2021.7.16 1-->2 */
			p = w->num + i;
			i = w->len - i;
			while (i-- > 0) {
				if (*p++) {
					p5w->exp = -scale;
					m_10to100(p5,p5w);
					m_add1(mpa,p5);	/* ؏グ */
					break;
				}
			}
		}
		else {
			p5w->exp = -(scale+1);
			p5w->num[1] = 5;
			m_10to100(p5,p5w);
			if (w->exp >= p5w->exp) m_add1(mpa,p5);	/* ľܓ */
		}
		if (mpa->zero)/* return 0;	*/
			return m_scale(mpa,precision,scale,0);
		m_100to10(mpa,w);
	}
	pre_exp = precision - 1;
	if (scale > 0) pre_exp -= scale;
	exp = w->exp;

m10w_print("m_scale: mpa10 w", w,0);
/*
printf("m_scale: exp=%d pre_exp=%d precision=%d scale=%d\n",exp,pre_exp,precision,scale);
*/
XPRINTOUTL4(100,"m_scale: exp=%d pre_exp=%d precision=%d scale=%d",exp,pre_exp,precision,scale);
	ret = 0;
	if (exp > pre_exp) {	/* OverFlow */
		ret = MPA_ERR_OVERFLOW;
		if (!(opt & 0x10)) {
			sign = w->sign;
			memset(mpa,0,sizeof(MPA));
			w->exp = pre_exp;
			w->sign = sign;
			w->len = precision + 1;	/* 2019.11.14 add +1 */
			p = w->num + 1;
			if (scale < 0) {
				precision += scale;
				memset(p+precision,0,-scale);
			}
			memset(p,9,precision);
/*
m10w_print("m_scale: OverFlow w", &w,0);
*/
			m_10to100(mpa,w);
/*
m_print("m_scale: OverFlow mpa", mpa,0);
*/
			return ret;
		}
	}
	else if ((len=scale+exp+1) <= 0) {
		if (!(opt & 0x10)) {
			memcpy(mpa,m_get_i(0),sizeof(MPA));
			return m_scale(mpa,precision,scale,0);
		/*	return 12;	*/
		}
	}
	else {
	/*	i = w->len - len;	*/
		i = w->len - 1 - len;	/* Mod 2019.7.28 */
		if (i > 0) {
			p = w->num + 1 + len;
		}
		else if (i < 0) {
			p = w->num + 1 + w->len;
			i = -i;
		}
	/*	w->len = len;	*/
		w->len = len + 1;	/* Mod 2019.7.28 */
		while (i-- > 0) *p++ = 0;
	}
/*
m10w_print("m_scale:Exit mpa10 w", &w,0);
*/
	m_10to100(mpa,w);

m_print("m_scale:Exit mpa", mpa,0);

	return ret;
}

/**45****************************/
/*	m_precision					*/
/********************************/
int m_precision(MPA *a, int pre, int opt)
{
	int ret;
	static MPA10W *sw10=NULL;
	MPA10W w10z,*w10;

	if (!a) return -18624501;
	w10 = get_tmpMPA10W(&sw10,&w10z);
	if (!(ret=m_100to10(a,w10))) {
		ret = m_precision_10(w10,pre,opt);
		if (!ret) m_10to100(a,w10);
		else if (ret > 0) ret = 0;
m_print("m_precision:Exit a",a,0);
	}
	return ret;
}

/**46****************************************************************/
/*	m_precision_10													*/
/*				opt   : IvV									*/
/*						0x0XXX: ľܓ							*/
/*						0x1XXX: ؎̂								*/
/*						0x2XXX: ؏グ (D)						*/
/*						0x0100: ̉E0TvX			*/
/********************************************************************/
int m_precision_10(MPA10W *w10, int pre, int opt)
{
	int exp,len,len_pre,i,k,n;
/*
printf("m_precision_10:Enter pre=%d opt=%08x\n",pre,opt);
m10w_print("m_precision_10:Enter w10",w10,0);
*/
	if (!w10) return -18624601;
	if (pre > 0) {
		if (pre > giNMPA10) pre = giNMPA10;
	}
	else {
		if (pre < 0) return -18624602;
		else return 1;
	}
	len = w10->len - 1;
	if (len < 1) len = 1;
	len_pre = pre;
	if (opt & 0x0100) {
		if (len < pre) len_pre = len;
	}
	if ((len>len_pre) && ((opt & 0x2000) || !(opt & 0x1000))) {
		n = w10->num[len_pre+1];
/*
printf("m_precision_10: len=%d pre+1=%d len-len_pre=%d\n",len,pre+1,len-len_pre);
*/
		memset(w10->num+pre+1,0,len-len_pre);	/* 2021.10.11 len+1-len_pre */
		k = 0;
		if (opt & 0x2000) {
			if (n) k = 1;
		}
		else if (n >= 5) k = 1;
/*
printf("m_precision_10: i=pre+1 n=%d k=%d\n",n,k);
*/
		for (i=pre;i>=1;i--) {
/*
printf("m_precision_10: i=%d k=%d\n",i,k);
*/
			if (!k) break;
			n = w10->num[i] + k;
			if (n >= 10) {
				n -= 10;
				k = 1;
			}
			else k = 0;
			w10->num[i] = n;
/*
printf("m_precision_10: n=%d k=%d\n",n,k);
*/
		}
		w10->len = len_pre + 1;
		if (k) {
			w10->num[0] = k;
			w10->exp++;
			w10->len--;
		}
	}
	else w10->len = len_pre + 1;
/*
m10w_print("m_precision_10:w10",w10,0);
printf("m_precision_10: len=%d\n",w10->len);
*/
	if (opt & 0x0100) {
		len = w10->len - 1 ;
		for (i=len;i>=2;i--) {
			if (w10->num[i]) break;
		}
		w10->len = i + 1;
	}
/*
m10w_print("m_precision_10:Exit w10",w10,0);
printf("m_precision_10:Exit len=%d\n",w10->len);
*/
	return 0;
}

/**47********************************/
/*	m_str2pack	DEC a <-- char b[]	*/
/************************************/
int m_str2pack(char *dec, int precision, int scale, int opt, char *s, int s_len0)
{
	char wrk[128],*p;
	int  len,lend,lens,s_len,ret;
	static MPA *sa=NULL;
	MPA az,*a;

	if (!s || !dec) return -18624701;
	if ((s_len=s_len0)<=0 || precision<=0) return -18624702;
	if (scale >= 0) {
		if (scale > precision) return -18624703;
	}
	else {
		if (-scale >= precision) return -18624704;
	}
	a = get_tmpMPA(&sa,&az);
	if (!(ret=m_an_to_mpa_opt(a,s,s_len0,opt))) {
		ret = m_pack_size(dec,a,precision,scale);
	}

	return ret;
}

/**48********************************/
/*	_to_hex		char s[] <-- DEC b	*/
/************************************/
static int _to_hex(char *s, char *dec, int len)
{
	int i;
	char  *a;
	uchar c;

	a = s;
	for (i=0; i<len;i++) {
		c = (uchar)*dec++;
		*a++ = ((c >> 4) & 0x0f) + '0';
		*a++ = (c & 0x0f) + '0';
	}
	if (len > 0) {
		*(a-1) = (*(dec-1) & 0x0f) - 0x0c + 'C';
	}
	return len*2;
}

/**49********************************/
/*	m_pack2str	char a[] <-- DEC b	*/
/************************************/
int m_pack2str(char *s, int s_len0, char *dec, int precision, int scale)
{
	char wrk[128],*p;
	int  len,lend,lens,s_len;

	if (!s || !dec) return -18624901;
	if ((s_len=s_len0)<=0 || precision<=0) return -18624902;
	if (scale >= 0) {
		if (scale > precision) return -18624903;
	}
	else {
		if (-scale >= precision) return -18624904;
	}
	len = (precision+2)/2;
	len = _to_hex(wrk,dec,len);
	len--;
	lens = 0;
	if (wrk[len] == 'D') {
		*s++ = '-';
		lens++;
		s_len--;
	}
	p = wrk;
	if (!(precision % 2)) {
		p++;
		len--;
	}
	if (s_len < len) {
		p += (len-s_len);
		len = s_len;
	}
	lend = len;
	lens += lend;
	if (scale >0) lend -= scale;
	if (lend < 0) return -4;
	memcpy(s,p,lend);
	s += lend;
	if (scale >0) {
		*s++ = '.';
		lens++;
		memcpy(s,p+lend,scale);
		s += scale;
	}
	if (lens < s_len0) *s = '\0';
	return lens;
}

/**50****************/
/*	m_set_array	 	*/
/********************/
int m_set_array(MPA *a_ary, MPA *val, int n)
{
	MPA *a,*b;

	if (!a_ary || !val) return -18625001;
	a = a_ary;
	b = val;
	while (n--) {
		m_cpy(a,b,0);
		a = (MPA *)((char *)a + gisizeofMPA);
	}
	return n;
}

/**51****************************/
/*	m_print						*/
/********************************/
void m_print(char *s, MPA *a, int _short)
{
	int i;
	char *p;

#if 1
	char wrk[256],*w;

if (XLOGLEVELCHK(X_LOG_NO_PRINT,100)) {
	XPRINTOUTL2(0,"%s %08x",s,a);
	XPRINTOUTL3(0,"exp=%d zero=%d len=%d", a->exp, a->zero, a->len);
	w = wrk;
	if(a->sign)	*w = '-';
	else		*w = '+';
	w++;
	for (i = 0, p = a->num; i < giNMPA1; i++) {
		sprintf(w,"%02d ",*p++);
		w += strlen(w);
	}
	XPRINTOUTL1(0,"%s",wrk);
}
#else
	printf("%s\n", s);
	printf("exp=%d zero=%d len=%d\n", a->exp, a->zero, a->len);
	if(a->sign)	putchar('-');
	else		putchar('+');
	for (i = 0, p = a->num; i < giNMPA1; i++) {
		printf("%02d ",*p++);
	}
	putchar('\n');
#endif
	return;
}

/**52****************************/
/*	m10w_print					*/
/********************************/
void m10w_print(char *s, MPA10W *a, int _short)
{
	int i;
	char *p;

#if 1
	char wrk[256],*w;

if (XLOGLEVELCHK(X_LOG_NO_PRINT,100)) {
	XPRINTOUTL1(0,"%s",s);
	XPRINTOUTL3(0,"exp=%d zero=%d len=%d", a->exp, a->zero, a->len);
	w = wrk;
	if(a->sign)	*w = '-';
	else		*w = '+';
	w++;
	for (i = 0, p = a->num; i < giNMPA2; i++) {
		sprintf(w,"%d ",*p++);
		w += strlen(w);
	}
	XPRINTOUTL1(0,"%s",wrk);
}
#else
	printf("%s\n", s);
	printf("exp=%d zero=%d len=%d\n", a->exp, a->zero, a->len);
	if(a->sign)	putchar('-');
	else		putchar('+');
	for (i = 0, p = a->num; i < giNMPA2; i++) {
		printf("%d ",*p++);
	}
	putchar('\n');
#endif
	return;
}

/**53****************************/
/*	m_print_exp2				*/
/********************************/
void m_print_exp2(char *s, MPA *a, int pre, int inx, int opt, int val1, int val2)
{
	char buf[70],wrk[65],*argv[2],*p;

if (XLOGLEVELCHK(X_LOG_NO_PRINT,100)) {
	p = m_mpa2str_exp(a,pre,inx,opt);
	argv[0] = argv[1] = NULL;
	akxa_log_printf_len(buf,60,s,2,argv);
/*
printf("m_print_exp2: s=[%s] buf=[%s]\n",s,buf);
*/
	sprintf(wrk,buf,val1,val2);
	strcpy(wrk+strlen(wrk),"%s");
/*
printf("m_print_exp2: wrk=[%s]\n",work);
*/
	XPRINTOUTL1(100,wrk,p);
/*	XPRINTOUTL1(100,wrk,m_mpa2str_exp(a,pre,inx,opt));	*/
}
}

/**54****************************/
/*	m_print_exp					*/
/********************************/
void m_print_exp(char *s, MPA *a, int pre, int inx, int opt)
{
	m_print_exp2(s,a,pre,inx,opt,0,0);
}

/**55****************************/
/*	m_mod						*/
/********************************/
int m_mod(MPA *ans, MPA *aa, MPA *bb)
{
	int i,ret,w10exp,n;
	static MPA *sa=NULL,*sb=NULL,*sc=NULL;
	MPA az,*a,bz,*b,cz,*c;

	if (!ans || !aa || !bb) return -18625501;
	ret=0;
	ret=m_div(ans,aa,bb);
	if (ret < 0) return ret;
	a = get_tmpMPA(&sa,&az);
	b = get_tmpMPA(&sb,&bz);
	c = get_tmpMPA(&sc,&cz);
	m_cpy(b,bb,0);
	m_normalize(b);
	m_cpy(a,aa,0);
	m_normalize(a);
	m_cpy(c,ans,0);
	ret = m_scale(c,giNMPA10,0,1);
	ret = m_mul1(c,b);
	ret = m_sub(ans, a, c);
	return ret;
}

/**56****************************/
/*	m_sqrt						*/
/********************************/
int m_sqrt(MPA *x, MPA *b)
{
	int i,ret,w10exp,n;
	static MPA10W *sw10=NULL;
	static MPA *sx0=NULL,*sy=NULL,*sd=NULL,*sc4=NULL,*sc05=NULL,*sx1=NULL,*sgosa=NULL,*sgosa5=NULL;
	MPA *x0,*y,*d,*c4,*c05,*x1,*gosa,*gosa5;
	MPA x0z,yz,dz,c4z,c05z,x1z,gosaz,gosa5z;
	MPA10W w10z,*w10;

	if (!x || !b) return -18625601;

	ret = 0;
	m_cpy(x,b,0);
	if (b->sign) ret = -18625602;
	else if (!b->zero) {
		w10 = get_tmpMPA10W(&sw10,&w10z);
		x0 = get_tmpMPA(&sx0,&x0z);
		y = get_tmpMPA(&sy,&yz);
		d = get_tmpMPA(&sd,&dz);
		c4 = get_tmpMPA(&sc4,&c4z);
		c05 = get_tmpMPA(&sc05,&c05z);
		x1 = get_tmpMPA(&sx1,&x1z);
		gosa = get_tmpMPA(&sgosa,&gosaz);
		gosa5 = get_tmpMPA(&sgosa5,&gosa5z);
		m_cpy(x0,b,0);
		m_100to10(x0,w10);
		w10exp = w10->exp;
/*
printf("m_sqrt: w10exp=%d (w10exp %% 2)=%d\n",w10exp,w10exp % 2);
*/
		w10->exp = x0->exp;
		m_10to100(x0,w10);
/*
printf("m_sqrt: x0=%s\n",m_mpa2str_exp(&x0,0,0,0));
*/
		if (w10->len>2 || w10->num[1]>1 || (w10exp % 2)) {
			m_set_a(gosa,"1.0e-50");
/*
printf("m_sqrt: gosa=%s\n",m_mpa2str_exp(&gosa,0,0,0));
*/
		/*	m_mul(&gosa5,&gosa,m_get_i(5));	*/
/*
printf("m_sqrt: gosa5=%s\n",m_mpa2str_exp(&gosa5,0,0,0));
*/
			*c4 = *m_get_i(4);
			for (i=1;i<=10;i++) {
			/*	d = ((y=x0*x0)-b)/(x0+x0);	*/
				m_mul(y,x0,x0);
				m_sub1(y,b);
				m_add_a(x1,x0,x0);
				m_div(d,y,x1);
/*
printf("m_sqrt: i=%d d=%s\n",i,m_mpa2str_exp(&d,20,2,0x0100));
*/
				m_sub1(x0,d);
/*
m_print_exp2("m_sqrt: i=%d x0=",&x0,20,0,0,i,0);
*/
				m_cpy(y,d,0);
				y->sign = 0;
				if (m_cmp_a(y,gosa) <= 0) {
			/*	if (abs(d) <= 1.0e-50) then	*/
			/*		x0+=5.0e-50;	*/
				/*	m_add1_a(&x0,&gosa5);	*/
					break;
				}
			}
/*
printf("m_sqrt: d=%s\n",m_mpa2str_exp(&d,20,2,0x0100));
*/
		}
		m_cpy(x,x0,0);
	}
	ret = m_precision(x,49,0x0100);
	return ret;
}

/**57****************************/
/*	m_cbrt						*/
/********************************/
int m_cbrt(MPA *x, MPA *b)
{
	static MPA *sx0=NULL,*sx1=NULL,*sxx=NULL,*sx2=NULL,*sy=NULL,*sd=NULL,*sc3=NULL,*sc52=NULL,*sgosa=NULL;
	static MPA10W *sw10=NULL;
	int i,ret,s,exp10;
	MPA x0z,x1z,xxz,x2z,yz,dz,c3z,c52z,gosaz;
	MPA *x0,*x1,*xx,*x2,*y,*d,*c3,*c52,*gosa;
	MPA10W w10z,*w10;

	if (!x || !b) return -18625701;

	ret = 0;
	m_cpy(x,b,0);
	if (!b->zero) {
		w10 = get_tmpMPA10W(&sw10,&w10z);
		x0 = get_tmpMPA(&sx0,&x0z);
		x1 = get_tmpMPA(&sx1,&x1z);
		xx = get_tmpMPA(&sxx,&xxz);
		x2 = get_tmpMPA(&sx2,&x2z);
		y = get_tmpMPA(&sy,&yz);
		d =  get_tmpMPA(&sd,&dz);
		c3 = get_tmpMPA(&sc3,&c3z);
	/*	c52 = get_tmpMPA(&sc52,&c52z);	*/
		gosa = get_tmpMPA(&sgosa,&gosaz);
		m_cpy(x0,b,0);
		s = x0->sign;
		x0->sign = 0;
		m_100to10(x0,w10);
		exp10 = X_ABS(w10->exp);
		exp10 = exp10/3 + (exp10 % 3);
		if (w10->exp < 0) exp10 = -exp10;
		w10->exp = exp10;
		m_10to100(x0,w10);
		*c3 = *m_get_i(3);
		m_set_a(gosa,"1.0e-50");
	/*	m_set_a(&c52,"5.2");
		if (m_cmp(&x0,&c52) >= 0) m_div1(&x0,&c3);	*/
m_print_exp("m_cbrt: x0=",x0,0,0,0);
		for (i=1;i<=20;i++) {
		/*	xx=x0*x0;	*/
			m_mul(xx,x0,x0);
		/*	x1 = (x0+x0+b/xx)/3.0;	*/
			m_add(x2,x0,x0);
			m_div(y,b,xx);
			m_add(x1,x2,y);
			m_div1(x1,c3);
m_print_exp2("m_cbrt: i=%d x1=",x1,20,0,0,i,0);
		/*	d = abs((x0-x1)/x0);	*/
			m_sub(d,x0,x1);
			m_div1(d,x0);
			d->sign = 0;
m_print_exp("m_cbrt: d=",d,0,0,0);
			m_cpy(x0,x1,0);
			if (m_cmp(d,gosa) <= 0) break;
		}
		x0->sign = s;
		m_cpy(x,x0,0);
	}
	ret = m_precision(x,49,0x0100);
	return ret;
}

/**58****************************/
/*	m_log10						*/
/********************************/
int m_log10(MPA *xx, MPA *b)
{
	static MPA *sx0=NULL,*sx1=NULL,*sx2=NULL,*sx3=NULL,*sc1=NULL;
	static MPA10W *sw10=NULL;
	int ret,w10exp;
	MPA x0z,x1z,x2z,x3z,c1z,*x0,*x1,*x2,*x3,*c1;
	MPA10W w10z,*w10;

	if (!xx || !b) return -18625801;

m_print_exp("m_log10:Enter b=",b,0,0,0);
	ret = 0;
	if (b->sign || b->zero) {
		*xx = *m_get_i(0);
m_print_exp("m_log10:Exit xx=",xx,0,0,0);
		return -18625802;
	}

	w10 = get_tmpMPA10W(&sw10,&w10z);
	m_100to10(b,w10);
	w10exp = w10->exp;
	m_i2mpa(w10exp,xx);
	if (w10->len>2 || w10->num[1]>1) {
		x0 = get_tmpMPA(&sx0,&x0z);
		x1 = get_tmpMPA(&sx1,&x1z);
		x2 = get_tmpMPA(&sx2,&x2z);
		x3 = get_tmpMPA(&sx3,&x3z);
		m_cpy(x3,xx,0);
		m_cpy(x0,b,0);
		w10->exp = 0;
		m_10to100(x0,w10);
		if (!(ret=m_ln(x1,x0))) {
#if 1
			*x2 = MPA_1DLOG10;
			if (!(ret=m_mul(xx,x1,x2))) {
#else
#if 1
			*x2 = MPA_LOG10;
#else
			m_set_a(x2,MPA_LOG10_STR);	/* log(10) */
#endif
			if (!(ret=m_div(xx,x1,x2))) {
#endif
				m_add1(xx,x3);
			}
		}
	}
m_print_exp("m_log10:Exit xx=",xx,0,0,0);
	return ret;
}

/**59****************************/
/*	m_ln						*/
/********************************/
int m_ln(MPA *xx, MPA *b)
{
	static MPA *sx0=NULL,*sn=NULL,*sx=NULL,*sy=NULL,*sc1=NULL,*sc05=NULL,*sx1=NULL,*sx2=NULL,*sc10=NULL,*scd10=NULL;
	int i,ret,sig;
	MPA x0z,nz,xz,yz,c1z,c05z,x1z,x2z,c10z,cd10z;
	MPA *x0,*n,*x,*y,*c1,*c05,*x1,*x2,*c10,*cd10;

	if (!xx || !b) return -18625901;

m_print_exp("m_ln:Enter b=",b,0,0,0);
	ret = 0;
	if (b->sign || b->zero) {
		*xx = *m_get_i(0);
m_print_exp("m_ln:Exit xx=",xx,0,0,0);
		return -18625902;
	}
	c1 = get_tmpMPA(&sc1,&c1z);
	*c1 = *m_get_i(1);
	if (!m_cmp(b,c1)) {
		*xx = *m_get_i(0);
		return 0;
	}
	c10  = get_tmpMPA(&sc10,&c10z);
	cd10 = get_tmpMPA(&scd10,&cd10z);
	*c10 = *m_get_i(10);
	m_cpy(cd10,c10,0);
	cd10->exp = -1;
	if (!m_cmp(b,c10) || !m_cmp(b,cd10)) {
#if 1
		*xx = MPA_LOG10;	/* ln(10) */
#else
		m_set_a(xx,MPA_LOG10_STR);	/* ln(10) */
#endif
		if (b->exp < 0) xx->sign = 1;
m_print_exp("m_ln:Exit const 10 or 1/10=",xx,0,0,0);
		return 0;
	}
	c05 = get_tmpMPA(&sc05,&c05z);
	n = get_tmpMPA(&sn,&nz);
	m_set_a(c05,"0.5");
	*n = *m_get_i(2);
	if (!m_cmp(b,n) || !m_cmp(b,c05)) {
		m_cpy(xx,MPA_LOG2,0);
		if (b->exp < 0) xx->sign = 1;
m_print_exp("m_ln:Exit const 2 or 1/2=",xx,0,0,0);
		return 0;
	}
	x1 = get_tmpMPA(&sx1,&x1z);
	x2 = get_tmpMPA(&sx2,&x2z);
	if (m_cmp(b,c10)>0 || m_cmp(b,cd10)<0) {
		m_log10(x1,b);
#if 1
		*x2 = MPA_LOG10;		/* ln(10) */
#else
		m_set_a(x2,MPA_LOG10_STR);	/* ln(10) */
#endif
		m_mul(xx,x1,x2);
		if (b->exp < 0) xx->sign = 1;
m_print_exp("m_ln:Exit xx=",xx,0,0,0);
		return 0;
	}
	x0 = get_tmpMPA(&sx0,&x0z);
	x = get_tmpMPA(&sx,&xz);
	y = get_tmpMPA(&sy,&yz);
	sig= 0;
	m_cpy(x0,b,0);
	if (m_cmp(b,c1) < 0) {
		m_div(x0,c1,b);
		sig = 1;
	}
/*	*n = *m_get_i(2);	*/
#if 1
	m_cpy(x2,MPA_LOG2,0);
#else
	m_set_a(x2,MPA_LOG2_STR); /* log(2) */
#endif
	if (!m_cmp(x0,n))
		m_cpy(x,x2,0);
	else if (m_cmp(x0,n) < 0)
		m_ln_sub(x,x0);
	else {
	/*	m_set_a(c05,"0.5");	*/
	/*	m_ln_sub(&x2,&n);	*/
m_print_exp("m_ln: x2=",x2,0,0,0);
		m_cpy(x1,x0,0);
		*x = *m_get_i(0);
		while (m_cmp(x1,n) > 0) {
			m_mul1(x1,c05);
m_print_exp("m_ln: x1=",x1,0,0,0);
			m_add1(x,x2);
m_print_exp("m_ln: x=",x,0,0,0);
		}
		m_ln_sub(y,x1);
		m_add1(x,y);
	}
	x->sign = sig;
m_print_exp("m_ln:Exit x=",x,0,0,0);
	m_cpy(xx,x,0);
	return 0;
}

/**60****************************/
/*	m_ln_sub					*/
/********************************/
int m_ln_sub(MPA *xx, MPA *b)
{
	static MPA *sX=NULL,*sY=NULL,*sy=NULL,*sc1=NULL,*sc2=NULL,*sx1=NULL,*sgosa=NULL,*sxm1=NULL,*sxp1=NULL,*sa=NULL;
	int i,ret;
	MPA Xz,Yz,yz,c1z,c2z,x1z,gosaz,xm1z,xp1z,az;
	MPA *X,*Y,*y,*c1,*c2,*x1,*gosa,*xm1,*xp1,*a;

	if (!xx || !b) return -18626001;
m_print_exp("m_ln_sub:Enter b=",b,0,0,0);
	if (b->sign || b->zero) {
		*xx = *m_get_i(0);
		return -18626002;
	}
	X  = get_tmpMPA(&sX,&Xz);
	Y = get_tmpMPA(&sY,&Yz);
	y = get_tmpMPA(&sy,&yz);
	c1 = get_tmpMPA(&sc1,&c1z);
	c2 = get_tmpMPA(&sc2,&c1z);
	x1 = get_tmpMPA(&sx1,&x1z);
	gosa = get_tmpMPA(&sgosa,&gosaz);
	xm1 = get_tmpMPA(&sxm1,&xm1z);
	xp1 = get_tmpMPA(&sxp1,&xp1z);
	a = get_tmpMPA(&sa,&az);
	ret = 0;
	m_set_a(gosa,"1.0e-54");
	*c1 = *m_get_i(1);
	*c2 = *m_get_i(2);
/*	X = (b-1.0)/(b+1.0); */
	m_sub(xm1,b,c1);
	m_add(xp1,b,c1);
	m_div(X,xm1,xp1);
m_print_exp("m_ln_sub: X=",X,0,0,0);
	m_cpy(Y,X,0);
	m_cpy(x1,Y,0);
	*a = *m_get_i(3);
	m_mul1(X,X);
m_print_exp("m_ln_sub: X=",X,0,0,0);
	for (i=1;i<=100;i++) {
		m_mul1(Y,X);
m_print_exp("m_ln_sub: Y=",Y,0,0,0);
		m_div(y,Y,a);
		m_add1(x1,y);
m_print_exp2("m_ln_sub: i=%d x1=",x1,0,0,0,i,0);
m_print_exp("m_ln_sub: a=",a,0,0,0);
m_print_exp("m_ln_sub: y=",y,30,2,0);
		y->sign = 0;
		if (m_cmp(y,gosa) <= 0) break;
		m_add1(a,c2);
	}
	m_add(xx,x1,x1);
	return 0;
}

/**61****************************/
/*	m_mpa2ul					*/
/********************************/
int m_mpa2ul(MPA *a, ulong *val)
{
	int ret, i, exp;
	ulong d,d0,pre_ulong_max,pre_ulong_max10;
	char *p,c;
	MPA b;

	if (!a || !val) return -18623801;
	if (memcmp(a->id,MPA_ID,2)) return -18623802;
	*val = 0;
	if (a->zero || a->exp < 0) return 0;
#if 1	/* 2023.6.28 */
	if (a->sign) {
/*
m_print_exp("m_mpa2ul: a=",a,0,0,0);
*/
		*val = 0;
		return MPA_ERR_OVERFLOW_I;
	}
	else if (m_cmp(a,m_get_ULONGMAX()) > 0) {
		*val = ULONG_MAX;
		return MPA_ERR_OVERFLOW_I;
	}
#endif
	exp = a->exp;
	p = a->num;
	i = a->len - 1;
	d0 = d = *p++;
	ret = 0;
/*	pre_ulong_max = ULONG_MAX/RADIX +1;
	pre_ulong_max10 = ULONG_MAX/RADIX10 +1;	*/
	while (exp-- > 0) {
#if 0	/* 2023.6.29 */
		if (d >= pre_ulong_max) {
			if (d >= pre_ulong_max10) {
				ret = MPA_ERR_OVERFLOW_I;
				break;
			}
			if (d*RADIX10 >= pre_ulong_max10) {
				ret = MPA_ERR_OVERFLOW_I;
				break;
			}
		}
#endif
		d *= RADIX;
		if (i-- > 0) d += *p++;
		if (d < d0) {
			ret = MPA_ERR_OVERFLOW_I;
			break;
		}
		d0 = d;
	}
	if (ret) d = ULONG_MAX;
	*val = d;
	return ret;
}

/**62****************************/
/*	m_mpa2ui					*/
/********************************/
int m_mpa2ui(MPA *a, uint *val)
{
	int ret,rc;
	ulong l=0;

	ret = m_mpa2ul(a,&l);
/*	*val = l;	*/
	if (rc = akx_chk_uint_over(l,val)) ret = MPA_ERR_OVERFLOW;
	return ret;
}

/**63****************************/
/*	m_l2mpa						*/
/********************************/
int m_l2mpa(long val, MPA *a)
{
	return m_l2mpau(val,a,0);
}

/**64****************************/
/*	m_ul2mpa					*/
/********************************/
int m_ul2mpa(ulong val, MPA *a)
{
	return m_l2mpau(val,a, 1);
}

/**65****************************/
/*	m_ui2mpa					*/
/********************************/
int m_ui2mpa(uint val, MPA *a)
{
	return m_ul2mpa((ulong)val, a);
}

/**66********************************/
/*	m_mpa2ansca	   "123.45" <-- mpa */
/* len_s : I[null܂		*/
/************************************/
int m_mpa2ansca(MPA *a, char *s, int len_s, int scale, int opt)
{
	int len,pos0,pos,len1,lenm;

	if ((len=m_mpa2an(a,s,len_s,opt))>=0 && scale>=0) {
		len_s--;
		if (!(pos = pos0 = instrchar(s,'.'))) {	/* _ȂƂ͍Ōɕt */
			if (len < len_s) {
				strcpy(s+len,".");
				len++;
				len_s--;
			}
			pos = len;
		}
		len1 = len - pos;
		lenm = len_s - len;
		len1 = scale - len1;
/*
printf("m_mpa2ansca: len=%d s=[%s] pos=%d len1=%d lenm=%d\n",len,s,pos,len1,lenm);
*/
		if (len1>0 && lenm>0) {	/* GAɗ]TA_ȉ̌
								   scale菬Ƃscale܂0t */
			if (len1 > lenm) len1 = lenm;	/* GA̗]肪scale菬Ƃ
											  ܂łɂ */
			memset(s+len,'0',len1);
			len += len1;
			*(s+len) = '\0';
		}
		else if (len1 < 0) {	/* m_scaleĂ炸A_ȉ̌
								   scale傫ƂsacleŐ؂̂Ă */
			*(s+pos+scale) = '\0';
			len += len1;
		}
	}
	return len;
}

/**67****************************/
/*	m_mpa2str					*/
/********************************/
char *m_mpa2str(MPA *a, char *s, int len_s, int opt)
{
	return m_mpa2scastr(a,s,len_s,-1,opt);
}
