static	char	sccsid[]="%Z% %M% %I% %E% %U%";
/****************************************************/
/* <clprbreak.c>									*/
/*		break process								*/
/****************************************************/

#include "colmn.h"

/************************************/
/*									*/
/************************************/
static int _push_break(leaf,proc,n,cid)
Leaf   *leaf;
ProcCT *proc;
int n,cid;
{
	static Leaf	Retleaf;
	Leaf	*retleaf;
/*
printf("_push_break: n=%d cmd=%08x %s\n",n,cid,cl_gets_cmd_name(cid));
*/
	retleaf = &Retleaf;
	memcpy(retleaf,leaf,sizeof(Leaf));
	retleaf->rightleaf = NULL;
	retleaf->leftleaf  = NULL;
	cl_copy_cmd(&(retleaf->cmd),&(leaf->cmd));
	retleaf->cmd.sub_cid = cid;
	retleaf->cmd.parnum = n;
	retleaf->cmd.prmnum = 0;
	retleaf->cmd.prmp = NULL;
	cl_ret_leaf_push(proc,retleaf);
	return 0;
}

/************************************/
/*									*/
/************************************/
int cl_pop_finally(proc,pcrLCB)
ProcCT *proc;
BlockCB *pcrLCB;
{
	static int try_cida[]={C_CATCH,C_FINALLY,C_ENDTRY,0};
	Leaf    *leafw;

	if (!(leafw=cl_ret_leaf_pop_search(proc,try_cida,3))) return -1;
	while (leafw) {
		if (leafw->cmd.cid == C_FINALLY) {
			proc->pcrBlockCB = pcrLCB;
			proc->Nextleaf = leafw;
			return C_FINALLY;
		}
		leafw=leafw->rightleaf;
	}
	/* OTRYԂɖ߂ */
	proc->pFlag = pcrLCB->pFlag;
	proc->ucExcept = pcrLCB->ucExcept;
	return 0;
}

/************************************/
/* _check_in_loop					*/
/************************************/
static int _check_in_loop(proc)
ProcCT  *proc;
{
	if (!cmn_chk_stat(LOP_PR,&proc->ptype)) {
		ERROROUT("Outside of loop !!");
		return ECL_SCRIPT_ERROR;
	}
	return 0;
}

/************************************/
/* _check_in_loop_switch			*/
/************************************/
BlockCB *_check_in_loop_switch(proc)
ProcCT  *proc;
{
	BlockCB *pcrLCB;
	int cmd;

	pcrLCB = proc->pcrBlockCB;
	while (pcrLCB) {
		cmd = pcrLCB->cid;
/*
printf("_check_in_loop_switch: cmd=%08x %s\n",cmd,cl_gets_cmd_name(cmd));
*/
		if (cmd==C_LOOP || cmd==C_FOR || cmd==C_DO || cmd==C_SWITCH) return pcrLCB;
		pcrLCB = pcrLCB->preBlockCB;
	}
	return NULL;
}


/************************************/
/* _set_up_level					*/
/************************************/
static int _set_up_level(leaf,proc,ip,msg,err,cmd)
Leaf    *leaf;
ProcCT  *proc;
int      ip;
char    *msg;
int      err;
int      cmd;
{
	int rc,level,n,cid;
	char *nam,*p;
	uchar c;
	BlockCB *pcrLCB;
	tdtInfoParm InfoParm;
/*
printf("_set_up_level: cmd=%08x %s parnum=%d\n",
cmd,cl_gets_cmd_name(cmd),leaf->cmd.parnum);
*/
	nam = NULL;
	if (leaf->cmd.sub_cid > 0) {
		level = leaf->cmd.parnum;
	}
	else if (leaf->cmd.prmnum > ip) {
		level = 0;
		/* 2021.4.7 */
		rc = cl_arg_to_char_num(leaf->cmd.prmp[ip],proc->Obj,&InfoParm,msg,0,0);

DEBUGOUT_InfoParm(110,"_set_up_level: rc=%d",&InfoParm,rc,0);

		if (rc) {
			if (rc == ECL_NULL_DATA) level = 1;
			else return rc;
		}
		else if (InfoParm.pi_attr == DEF_ZOK_CHAR) {
			if (cl_is_name((p=InfoParm.pi_data),InfoParm.pi_dlen) > 0) nam = p;
/*
printf("_set_up_level: dlen=%d data=[%s]\n",InfoParm.pi_dlen,p);
*/
		}
		if (!level && !nam) {
			if (rc=cl_get_parm_long(&InfoParm,&level,msg)) return rc;

DEBUGOUTL1(110,"_set_up_level: level=%d",level);

			if (level < 0) {
				ERROROUT2(FORMAT(411),msg,level);	/* %sx(%d)słB */
				return err;
			}
			else if (!level) return C_SKIP_COMMAND;
		}
	}
	else level = 1;

	pcrLCB = proc->pcrBlockCB;
	n = level;
	for (;;) {
		if (!pcrLCB) {
			if (nam)
				ERROROUT2("%s[%s]ubN܂B",msg,nam);
			else
				ERROROUT2(FORMAT(412),msg,level);	/* %sx(%d)I[ołB */
			return err;
		}

DEBUGOUTL4(200,"_set_up_level: pcrLCB=%08x n=%d cid=%08x %s",pcrLCB,n,pcrLCB->cid,cl_gets_cmd_name(pcrLCB->cid));

		if ((cid=pcrLCB->cid)==C_TRY) {
			rc = cl_pop_finally(proc,pcrLCB);
			if (rc) {
				if (rc == C_FINALLY) {
					_push_break(leaf,proc,n,cmd);
				}
				return rc;
			}
		}
		else if (cid==C_LOOP || cid==C_FOR || cid==C_DO || cid==C_SWITCH) {
			if (nam && (p=pcrLCB->BlockName)) {
				if (!strcmp(nam,p)) break;
			}
			else
			if (--n <= 0) break;
		}
		pcrLCB->iUsed = 0;
		pcrLCB = pcrLCB->preBlockCB;
	}

DEBUGOUTL1(110,"_set_up_level: pcrLCB->Blockleaf=%08x",pcrLCB->Blockleaf);

	proc->pcrBlockCB = pcrLCB;
	return 0;
}

/************************************/
/* cl_process_break					*/
/************************************/
int cl_process_break(leaf, proc)
Leaf    *leaf;
ProcCT  *proc;
{
	return cl_pr_break(leaf,proc,0);
}

/************************************/
/* cl_pr_break						*/
/************************************/
int cl_pr_break(leaf, proc, ip)
Leaf    *leaf;
ProcCT  *proc;
int      ip;
{
	int rc,cmd;
	BlockCB *pIfCB;
/*
printf("cl_pr_break: leaf=%08x proc=%08x\n",leaf,proc);
*/
	if (!leaf || !proc) return ECL_SYSTEM_ERROR;

DEBUGOUTL5(110,"cl_process_break: cmd=%08x %s sub_cmd=%08x %s parnum=%d",
leaf->cmd.cid,cl_gets_cmd_name(leaf->cmd.cid),
leaf->cmd.sub_cid,cl_gets_cmd_name(leaf->cmd.sub_cid),leaf->cmd.parnum);

	rc = 0;
	if ((cmd=leaf->cmd.sub_cid) > 0) ;
	else {
		if (!(pIfCB = _check_in_loop_switch(proc))) {
			ERROROUT("Outside of loop or switch!!");
			rc = ECL_SCRIPT_ERROR;
		}
		cmd = pIfCB->cid;
	}
	if (!rc) {
		rc = _set_up_level(leaf,proc,0,"cl_process_break: ",ECL_EX_BREAK,cmd);

DEBUGOUTL1(110,"cl_process_break: rc=%d",rc);

		if (!rc) {
			if (!(pIfCB = proc->pcrBlockCB)) return -1;
			if (pIfCB->cid == C_SWITCH) {
				pIfCB->iLoopMax = C_BREAK;
				rc = cl_set_continue(leaf,proc);
			}
			else {
				pIfCB->iLoopCounter = 0x7ffffffe;
				cmn_set_stat(BRK_PR,&proc->ptype,L_ON);
				rc = cl_set_continue(leaf,proc);
			}
		}
		else if (rc == C_SKIP_COMMAND) rc = 0;
		else if (rc == C_FINALLY) {
			cmn_set_stat(BRK_PR,&proc->ptype,L_ON);
			rc = 0;
		}
	}
	return rc;
}

/************************************/
/* cl_set_continue					*/
/************************************/
int cl_set_continue(leaf,proc)
Leaf    *leaf;
ProcCT  *proc;
{
	int rc;
	BlockCB *pcrLCB;
	Leaf   *loop_leaf,*leafw;

	loop_leaf = NULL;
	if (pcrLCB=proc->pcrBlockCB) {
		if (pcrLCB->iUsed) loop_leaf = pcrLCB->Blockleaf;
	}

DEBUGOUTL3(110,"cl_set_continue: pcrLCB=%08x iUsed=%d loop_leaf=%08x",pcrLCB,pcrLCB->iUsed,loop_leaf);

	if (loop_leaf) {
		while (leafw=cl_ret_leaf_pop(proc)) {

DEBUGOUTL1(190,"cl_set_continue: leafw=%08x",leafw);

			if (leafw == loop_leaf) break;
		}
		if (leafw) {
			proc->Nextleaf = loop_leaf;
DEBUGOUTL1(110,"cl_set_continue: found leaf=%08x",loop_leaf);
			rc = 0;
		}
		else rc = ECL_SYSTEM_ERROR;
	}
	else rc = ECL_SYSTEM_ERROR;
	return rc;
}

/************************************/
/* cl_process_continue				*/
/************************************/
int cl_process_continue(leaf, proc)
Leaf    *leaf;
ProcCT  *proc;
{
	return cl_pr_continue(leaf,proc,0);
}

/************************************/
/* cl_pr_continue					*/
/************************************/
int cl_pr_continue(leaf, proc, ip)
Leaf    *leaf;
ProcCT  *proc;
int      ip;
{
	int rc;
	BlockCB *pIfCB;

	if (leaf && proc) {

DEBUGOUTL5(110,"cl_pr_continue: cmd=%08x %s sub_cmd=%08x %s parnum=%d",
leaf->cmd.cid,cl_gets_cmd_name(leaf->cmd.cid),
leaf->cmd.sub_cid,cl_gets_cmd_name(leaf->cmd.sub_cid),leaf->cmd.parnum);

		/* 2017.3.12 */
		if (!(pIfCB = _check_in_loop_switch(proc))) {
			ERROROUT("Outside of loop or switch!!");
			rc = ECL_SCRIPT_ERROR;
		}
		else {
			rc = _set_up_level(leaf,proc,ip,"cl_pr_continue: ",ECL_EX_CONTINUE,0);
			/* 2017.3.12 */
			if (!rc) {
				if (!(pIfCB = proc->pcrBlockCB)) return -1;
				if (pIfCB->cid == C_SWITCH) {
					pIfCB->iLoopMax = C_BREAK;
					rc = cl_set_continue(leaf,proc);
				}
				else
					rc = cl_set_continue(leaf,proc);
			}
 			else if (rc == C_SKIP_COMMAND) rc = 0;
			else if (rc == C_FINALLY) {
				cmn_set_stat(BRK_PR,&proc->ptype,L_ON);
				rc = 0;
			}
		}
	}
	else rc = ECL_SYSTEM_ERROR;

	return rc;
}

/************************************/
/* _check_label						*/
/************************************/
static int _check_label(rleaf,lbl_goto)
Leaf *rleaf;
char *lbl_goto;
{
	int rc,par_len;
	char *lbl;
	ParList *pal;

	rc = 0;
	if (rleaf->lf_label) {
		if (!strcmp(lbl_goto,rleaf->lf_label)) rc = 1;
	}
	else if (rleaf->cmd.cid == C_LABEL) {
		lbl = rleaf->cmd.prmp[0]->prp;
/*
printf("cl_pr_goto: label=[%s]\n",lbl);
*/
		if (!strcmp(lbl_goto,lbl)) rc = 1;
	}
	else {
		pal = &rleaf->cmd.parl[D_LEAF_LABEL];
		if (lbl = pal->par) {
			if (!strcmp(lbl_goto,lbl)) rc = 1;
		}
	}
	return rc;
}

/************************************/
/* _check_right						*/
/************************************/
static Leaf *_check_right(leaf,lbl_goto)
Leaf *leaf;
char *lbl_goto;
{
	int rc,type;
	Leaf *rleaf,*pre_leaf,*cur_leaf,*ret_leaf;

	ret_leaf = NULL;
	rleaf = leaf;
	while (rleaf=rleaf->rightleaf) {
/*
printf("_check_right:right cmd=[%s]\n",cl_gets_cmd_name(rleaf->cmd.cid));
*/
		if (rc=_check_label(rleaf,lbl_goto)) return rleaf;
	}
	cur_leaf = leaf;
	while (pre_leaf=cur_leaf->preleaf) {
		type = (pre_leaf->cmd.type>>4) & 0x0f;
/*
printf("_check_right:pre   type=%d cmd=[%s]\n",type,cl_gets_cmd_name(pre_leaf->cmd.cid));
*/
		if (type == 1) break;
		else if (type==2 && pre_leaf->leftleaf==cur_leaf) {
			/* (right)T */
			ret_leaf=_check_right(pre_leaf,lbl_goto);
			break;
		}
		if (rc=_check_label(pre_leaf,lbl_goto)) {
			ret_leaf = pre_leaf;
			break;
		}
		cur_leaf = pre_leaf;
	}
	return ret_leaf;
}

/************************************/
/* cl_pr_goto						*/
/************************************/
int cl_pr_goto(leaf,proc,ip)
Leaf    *leaf;
ProcCT  *proc;
int      ip;
{
	static char *_fn_="cl_pr_goto";
	int rc,atr,loop_max,ret,iMaxLoopWhile;
	cmdInfo *pcmd;
	parmList **prmp;
	Leaf *rleaf;
	char *lbl_goto,*lbl;
	MCAT2 *pLabel;
	tdtGotoLabel tLabel;
	tdtInfoParm tInfoParm;

	if (!leaf || !proc) return -1;
	rc = 0;
	pcmd = &leaf->cmd;
	prmp = pcmd->prmp;
/*
printf("cl_pr_goto: prmnum=%d prp=[%s] [%s]\n",pcmd->prmnum,prmp[0]->prp,prmp[1]->prp);
*/
	if ((rc=cl_arg_to_char_num(prmp[1],proc->Obj,&tInfoParm,_fn_,0,2)) < 0) return rc;
	if ((atr=tInfoParm.pi_attr) == DEF_ZOK_CHAR)
		lbl_goto = tInfoParm.pi_data;
	else {
		ERROROUT2(FORMAT(318),_fn_,prmp[1]->prp);	/* %s: %s͎gpł܂B*/
		return ECL_SCRIPT_ERROR;
	}
	if (pLabel=proc->pro_pLabel) {
		memset(tLabel.label,0,sizeof(tLabel.label));
		strnzcpy(tLabel.label,lbl_goto,MAX_LEN_LABEL);
		tLabel.cur_leaf = leaf;
		if ((rc=akxs_mseq_r(pLabel,&tLabel)) < 0) return rc;
		else if (rc > 0) {
			if ((loop_max=cl_get_loop_max(&iMaxLoopWhile)) < 0) return loop_max;
/*
printf("%s: rc=%d count=%d loop_max=%d\n",_fn_,rc,tLabel.gl_count,loop_max);
*/
			if (tLabel.gl_count >= loop_max) {
				if ((cl_get_option(27,0) & 0x01) || iMaxLoopWhile==MAX_LOOP_WHILE)
					ERROROUT2(FORMAT(646),_fn_,iMaxLoopWhile);	/* %s: [vJEgA%d ɒB܂B*/
			}
			else {
				proc->Nextleaf = tLabel.lbl_leaf;
				tLabel.gl_count++;
				if ((ret=akxs_mseq_s(pLabel,&tLabel)) < 0) return ret;
			}
/*
printf("%s:1 goto lbl=[%s]\n",_fn_,tLabel.label);
*/
		}
	}
	if (!rc) {
		if (rleaf=_check_right(leaf,lbl_goto)) {	/* labelT */
			proc->Nextleaf = rleaf;
			if (!(pLabel=proc->pro_pLabel)) {
				/* xłGOTÖʒuGOTOłȂẍʒû
				   xGOTÖʒuL[Ƃ */
				if (!(pLabel=akxs_mseq2_new(sizeof(tdtGotoLabel),-16,sizeof(Leaf *)+sizeof(long),NULL,NULL))) return ECL_MALLOC_ERROR;
				proc->pro_pLabel = pLabel;
/*
printf("%s:2 proc=%08x pLabel=%08x\n",_fn_,proc,pLabel);
*/
			}
			strnzcpy(tLabel.label,lbl_goto,MAX_LEN_LABEL);
/*
printf("%s:2 goto lbl=[%s]\n",_fn_,tLabel.label);
*/
			tLabel.cur_leaf = leaf;
			tLabel.lbl_leaf = rleaf;
			tLabel.gl_count = 1;
			if ((rc=akxs_mseq_s(pLabel,&tLabel)) < 0) return rc;
			/* 0 ͕ԂȂ */
/*
printf("%s: rc=%d\n",_fn_,rc);
*/
		}
		else rc = -1;
	}
	if (rc < 0) {
				/* %s: x(%s)ȂAGOTOłȂxłB*/
		ERROROUT2(FORMAT(661),_fn_,lbl_goto);
		rc = ECL_SCRIPT_ERROR;
	}
	else if (rc > 0) rc = 0;
	return rc;
}

/************************************/
/* cl_pr_label						*/
/************************************/
int cl_pr_label(leaf,proc)
Leaf    *leaf;
ProcCT  *proc;
{
	int rc;
	cmdInfo *pcmd;
	parmList **prmp;
	char *lbl,buf[65];
	MCAT2 *pLabel;

	rc = 0;
	return rc;
}
