#"%Z% %M% %I% %E% %U%"

include ../../os_depend.mk
include ../../unix_command.mk
include ../../directory.mk
include ../../flags.mk

#---------------------------------------------------------------
#			for coal client
#---------------------------------------------------------------
COALHOME	= ../../..
COALSRC		= $(COALHOME)/src
COALBIN		= $(COALHOME)/bin
COALINC		= $(COALSRC)/include
COALAPL		= $(COALSRC)/appl
APLINC		= $(COALAPL)/include
APLCOM		= $(COALAPL)/cmn
LIBCOAL		= $(COALAPL)/coal
LIBCLTREE	= $(LIBCOAL)/tree
LIBCLCMD	= $(LIBCOAL)/cmd
LIBCLBEXP	= $(LIBCOAL)/bexp
LIBCLFUNC	= $(LIBCOAL)/func
LIBCLEP		= $(LIBCOAL)/ep

#---------------------------------------------------------------
#			include paths
#---------------------------------------------------------------
INCLUDES		= \
				-I$(LIBINC) \
				-I$(APLINC)

#				-I/usr/include 
#---------------------------------------------------------------
#			apl options
#---------------------------------------------------------------
APLOPTS	= -DCOAL -DUSE_ICONV -DCYGWIN_U8

#---------------------------------------------------------------
#			C Compiler Options
#---------------------------------------------------------------
CFLAGS			= -O -finput-charset=CP932 \
				$(OSDEPEND) \
				$(INCLUDES) \
				$(APLOPTS) \
				$(DEBUGOPTS) 

#---------------------------------------------------------------
#
#		Objects
#
#---------------------------------------------------------------

#---------------------------------------------------------------
#			object files for coss Component
#---------------------------------------------------------------
HEADERS						=	\
							$(APLINC)/colmn.h \
							$(APLINC)/clconst.h \
							$(APLINC)/cllocal.h \
							$(APLINC)/clprot.h \
							$(APLINC)/cmmacro.h \
							$(APLINC)/cmprot.h \
							$(APLINC)/cmconst.h \
							$(APLINC)/cmerror.h \
							$(APLINC)/cmstruct.h

OBJS	=	\
clglobal.o \
coalmain.o \
colinit.o \
coalanal.o \
cl_packet_check.o \
clscr.o \
cl_make_error_packet.o \
cl_make_return_packet.o \
cl_get_script_name.o \
clexescr.o \
cl_execute_proc.o \
cl_ex_get_proc_name.o \
cl_parm_data_set.o \
cl_scparmset.o \
clnode.o \
clmkproc.o \
clmkscpt.o \
clerproc.o \
clerscpt.o \
clclear.o \
cl_code_trans.o \
cl_const_mem_get.o \
clmessage.o \
cllog.o \
clterm.o \
date.o vers.o \

AKBCOMLIB		=	\
				$(LIBCLTREE)/libcltree.a \
				$(LIBCLCMD)/libclcmd.a \
				$(LIBCLBEXP)/libclbexp.a \
				$(LIBCLFUNC)/libclfunc.a \
				$(LIBCLEP)/libclep.a \
				$(LIBAKA)/libaka.a \
				$(LIBAKB)/libakb.a \
				$(LIBAKX)/libakx.a

APLCOMLIB		= $(APLCOM)/aplcom.a

OTHERLIB  = -liconv

#---------------------------------------------------------------
#
#			LINKER target file
#
#---------------------------------------------------------------
TARGETFILE			= coal

#---------------------------------------------------------------
#
#		rules
#
#---------------------------------------------------------------
all : $(TARGETFILE)

#---------------------------------------------------------------
#		rules for TARGETFILE
#---------------------------------------------------------------
$(TARGETFILE) : $(OBJS) $(AKBCOMLIB) $(APLCOMLIB)
	$(CC) $(LDFLAGS) -o $@ \
		$(OBJS) $(AKBCOMLIB) $(APLCOMLIB) $(OTHERLIB)
		@\rm -f date.o vers.o date.c

release : $(OBJS) $(AKBCOMLIB) $(APLCOMLIB)
	$(CC) $(LDFLAGS) -o $@ \
		$(OBJS) $(AKBCOMLIB) $(APLCOMLIB) $(OTHERLIB)
		@\rm -f date.o vers.o date.c vers.c 

link :	date.o vers.o
	$(CC) $(LDFLAGS) -o $@ \
		$(OBJS) $(AKBCOMLIB) $(APLCOMLIB) $(OTHERLIB)
		@\rm -f date.o vers.o date.c

date.c : $(CONFDIR)/newdate.sh
		@sh $(CONFDIR)/newdate.sh

vers.c : $(CONFDIR)/newvers.sh
		@sh $(CONFDIR)/newvers.sh

#---------------------------------------------------------------
#
#			basic sufixes
#
#---------------------------------------------------------------
.c.o : $(HEADERS)
		$(CC) $(CFLAGS) -c $*.c

#---------------------------------------------------------------
#
#		other rules
#
#---------------------------------------------------------------
install : $(TARGETFILE)
		$(INSTALL) $(INSTFLGS) $(TARGETFILE) $(COALBIN)

include ../../other_rules.mk
