#!/usr/local/bin/luac53 -p --
--[[
--@brief  Quasi Robot Language; LuaChip
--@date   Sun,28 Oct,2018
--@date   Sun,02 Dec,2018
--@date   Tue,01 Jan,2019
--@date   Sun,20 Jan,2019
--@date   Sat,16 Feb,2019
--@date   Sat,18 Apr,2020
--@date   Tue,28 Apr,2020
--@date   Sat,30 Oct,2021
--@date   Fri,11 Mar,2022
--@date   Mon,09 Jan,2023
--@date   Mon,26 Jun,2023
--@date   Tue,27 Jun,2023
--@author Copyright(C)2018-2023 G-HAL
--]]

-- ##begin##
-- name : Move Mode
-- size : 2 , 2
-- footprint :
-- ##
-- ##
-- address :
-- chip_coordinates_tag : ##010##
-- chip_number_tag : ##011##
-- chip_number : 
-- chip_footprint_tag : ##012##
-- next_address_condition_true_coordinates_tag : ##020##
-- next_address_condition_true_tag : ##021##
-- next_address_condition_true : 0010023
-- argument : 1
-- argument_comment[1] : Move Mode
-- argument[1] : Walk
-- argument_tag[1] : ##111##
-- argument_type[1] : list
-- argument_list[1] : Walk , Roll , Skim , Fly
-- argument_geometry[1] : x:16 , y:81 , w:111 , h:46
-- ##body##

function qrl_chip##011##(Mek, GB)
  PrintTraceMessage(GB, Mek, '##010##:##011##:Move_Mode');
  PrintTracer(GB, Mek, '##012##');
  if enable_debugger then
    dbg();
  end;
  g_QRL_SystemVariable["ExecQueue_Type"]          = c_ExecQueue_Type_MoveMode;
  g_QRL_SystemVariable["ExecQueue_Type_MoveMode"] = MM_##111##;
  return '##021##';
end;

-- ##end##
-- [ End of File ]
