#!/usr/local/bin/luac53 -p --
--[[
--@brief  Quasi Robot Language; LuaChip
--@date   Sun,31 Jan,2021
--@date   Sat,30 Oct,2021
--@date   Sun,06 Mar,2022
--@date   Fri,11 Mar,2022
--@date   Mon,09 Jan,2023
--@date   Mon,26 Jun,2023
--@author Copyright(C)2021-2023 G-HAL
--]]

-- ##begin##
-- name : Repair
-- size : 3 , 2
-- footprint :
-- ###
-- ###
-- address :
-- chip_coordinates_tag : ##010##
-- chip_number_tag : ##011##
-- chip_number : 
-- chip_footprint_tag : ##012##
-- next_address_condition_true_coordinates_tag : ##020##
-- next_address_condition_true_tag : ##021##
-- next_address_condition_true : 0010023
-- next_address_condition_false_coordinates_tag : ##030##
-- next_address_condition_false_tag : ##031##
-- next_address_condition_false : 0020023
-- argument : 2
-- argument_comment[1] : Skill
-- argument[1] : MechaTech
-- argument_tag[1] : ##111##
-- argument_type[1] : list
-- argument_list[1] : MechaTech , Medicine , FirstAid, BioTech , General
-- argument_geometry[1] : x:16 , y:60 , w:192 , h:31
-- argument_comment[2] : Target
-- argument[2] : mek
-- argument_tag[2] : ##121##
-- argument_type[2] : var
-- argument_geometry[2] : x:16 , y:102 , w:123 , h:31
-- ##body##

function qrl_chip##011##(Mek, GB)
  PrintTraceMessage(GB, Mek, '##010##:##011##:Repair');
  PrintTracer(GB, Mek, '##012##');
  if enable_debugger then
    dbg();
  end;
  local err = false;
  if (c_Variable_Type_Mek ~= g_QRL_UserVariable_Type["##121##"]) then
    PrintErrorMessage(GB, Mek, '##010##:##011##:Repair:No target is selected.');
    err = true;
  end;
  if err then
    return '##031##';
  end;

  local NPC = LocatePilot(Mek);
  local Target = g_QRL_UserVariable["##121##"];
  switch = {
    default       = function() return  0; end;
    ['MechaTech'] = function() return  15; end;
    ['Medicine']  = function() return  16; end;
    ['FirstAid']  = function() return  20; end;
    ['BioTech']   = function() return  22; end;
    ['General']   = function() return  23; end;
  };
  local skill = (switch["##111##"] or switch.default)();
  if (skill <= 0) then
    PrintErrorMessage(GB, Mek, '##010##:##011##:Repair:BUG.');
    return '##031##';
  end;
  if (Mek_NAttValue_Skill(NPC, skill) <= 0) then
    return '##031##'; -- No Skill
  end;
  local MekRepairFuel = 0;
  local PilotRepairFuel = 0;
  if (nil ~= Mek) and (Mek ~= NPC) then
    if (nil ~= SeekGear(Mek, GG_RepairFuel, skill)) then
      MekRepairFuel = 1;
    end;
  end;
  if (nil ~= NPC) then
    if (nil ~= SeekGear(NPC, GG_RepairFuel, skill)) then
      PilotRepairFuel = 1;
    end;
  end;
  local TotalRepairFuel = MekRepairFuel + PilotRepairFuel;
  if  (TotalRepairableDamage(Target, skill) < 1) or (TotalRepairFuel <= 0) or (CharCurrentMental(Mek) < 1) then
    return '##031##'; -- Not Repairable
  end;
  if (3 < Range_MM(GB, Mek, Target)) then
    return '##031##'; -- Too Far
  end;

  g_QRL_SystemVariable["ExecQueue_Type"]               = c_ExecQueue_Type_Repair;
  g_QRL_SystemVariable["ExecQueue_Type_Repair_Target"] = Target;
  g_QRL_SystemVariable["ExecQueue_Type_Repair_Limit"]  = -1;
  g_QRL_SystemVariable["ExecQueue_Type_Repair_Skill"]  = skill;
  return '##021##';
end;

-- ##end##
-- [ End of File ]
