#!/usr/local/bin/luac53 -p --
--[[
--@brief  Quasi Robot Language; LuaChip
--@date   Sun,22 Nov,2015
--@date   Sun,13 Dec,2015
--@date   Fri,18 Aug,2017
--@date   Sun,03 Sep,2017
--@date   Fri,05 Jan,2018
--@date   Sun,02 Dec,2018
--@date   Tue,01 Jan,2019
--@date   Sat,16 Feb,2019
--@date   Sun,24 Feb,2019
--@date   Tue,07 Apr,2020
--@date   Tue,28 Apr,2020
--@date   Sat,19 Sep,2020
--@date   Sun,11 Oct,2020
--@date   Sat,17 Oct,2020
--@date   Sat,30 Oct,2021
--@date   Sun,06 Mar,2022
--@date   Fri,11 Mar,2022
--@date   Mon,09 Jan,2023
--@date   Mon,26 Jun,2023
--@date   Tue,27 Jun,2023
--@author Copyright(C)2015-2023 G-HAL
--]]

-- ##begin##
-- name : Attack with BV
-- size : 2 , 3
-- footprint :
-- ##
-- ##
-- ##
-- address :
-- chip_coordinates_tag : ##010##
-- chip_number_tag : ##011##
-- chip_number : 
-- chip_footprint_tag : ##012##
-- next_address_condition_true_coordinates_tag : ##020##
-- next_address_condition_true_tag : ##021##
-- next_address_condition_true : 0010033
-- argument : 3
-- argument_comment[1] : Weapon
-- argument[1] : wep
-- argument_tag[1] : ##111##
-- argument_type[1] : var
-- argument_geometry[1] : x:10 , y:60 , w:123 , h:31
-- argument_comment[2] : Enemy
-- argument[2] : ene
-- argument_tag[2] : ##121##
-- argument_type[2] : var
-- argument_geometry[2] : x:10 , y:102 , w:123 , h:31
-- argument_comment[3] : BV
-- argument[3] : Max
-- argument_tag[3] : ##131##
-- argument_type[3] : list
-- argument_list[3] : Max , Half , QTR , Off
-- argument_geometry[3] : x:35 , y:144 , w:98 , h:31
-- ##body##

function qrl_chip##011##(Mek, GB)
  PrintTraceMessage(GB, Mek, '##010##:##011##:Attack_with_BV');
  PrintTracer(GB, Mek, '##012##');
  if enable_debugger then
    dbg();
  end;
  local err = false;
  if (c_Variable_Type_Weapon ~= g_QRL_UserVariable_Type["##111##"]) then
    PrintErrorMessage(GB, Mek, '##010##:##011##:Attack_with_BV:No weapon is selected.');
    err = true;
  end;
  if (c_Variable_Type_Mek ~= g_QRL_UserVariable_Type["##121##"]) and (c_Variable_Type_Module ~= g_QRL_UserVariable_Type["##121##"]) then
    PrintErrorMessage(GB, Mek, '##010##:##011##:Attack_with_BV:No enemy is selected.');
    err = true;
  end;
  if err then
    return '##021##';
  end;

  if (NotDestroyed(g_QRL_UserVariable_Contents["##111##"]) and NotDestroyed(g_QRL_UserVariable_Contents["##121##"])) then
    g_QRL_SystemVariable["ExecQueue_Attack_Mode_AIAttacker"] = false;
    g_QRL_SystemVariable["ExecQueue_Attack_Weapon"] = g_QRL_UserVariable_Contents["##111##"];
    g_QRL_SystemVariable["ExecQueue_Attack_Target"] = g_QRL_UserVariable_Contents["##121##"];
    g_QRL_SystemVariable["ExecQueue_Attack_AtOp"] = 0;

    local function GetAtOp(Mek, GB, num)
      local gs = Mek_S(g_QRL_SystemVariable["ExecQueue_Attack_Weapon"]);
      local s_bv = Mek_Stat(g_QRL_SystemVariable["ExecQueue_Attack_Weapon"], STAT_Magazine);

      if ((GS_Ballistic == gs) or (GS_BeamGun == gs) )and (0 < s_bv) then
        g_QRL_SystemVariable["ExecQueue_Attack_AtOp"] = math.floor(s_bv / num);
        if (g_QRL_SystemVariable["ExecQueue_Attack_AtOp"] < 1) then
          g_QRL_SystemVariable["ExecQueue_Attack_AtOp"] = 1;
        end;
      elseif (GS_Missile == gs) then
        g_QRL_SystemVariable["ExecQueue_Attack_AtOp"] = math.floor(s_bv / num) - 1;
        if (g_QRL_SystemVariable["ExecQueue_Attack_AtOp"] < 0) then
          g_QRL_SystemVariable["ExecQueue_Attack_AtOp"] = 0;
        end;
      end;
    end;
    local switch = {
      default  = function(Mek, GB) PrintErrorMessage(GB, Mek, '##010##:##011##:Attack_with_BV:BUG.'); end;
      ["Max"]  = function(Mek, GB) GetAtOp(Mek, GB, 1); end;
      ["Half"] = function(Mek, GB) GetAtOp(Mek, GB, 2); end;
      ["QTR"]  = function(Mek, GB) GetAtOp(Mek, GB, 4); end;
      ["Off"]  = function(Mek, GB) g_QRL_SystemVariable["ExecQueue_Attack_AtOp"] = 0; end;
    };
    (switch["##131##"] or switch.default)(Mek, GB);
  end;
  return '##021##';
end;

-- ##end##
-- [ End of File ]
