#!/usr/local/bin/luac53 -p --
--[[
--@brief  Quasi Robot Language; LuaChip
--@date   Sun,06 Jul,2014 - Sun,01 Mar,2015
--@date   Tue,18 Aug,2015
--@date   Sun,30 Aug,2015
--@date   Tue,27 Oct,2015
--@date   Sun,13 Dec,2015
--@date   Sat,19 Dec,2015
--@date   Sun,27 Dec,2015
--@date   Fri,18 Aug,2017
--@date   Sun,03 Sep,2017
--@date   Fri,06 Apr,2018
--@date   Sat,07 Apr,2018
--@date   Sat,12 May,2018
--@date   Sun,02 Dec,2018
--@date   Tue,01 Jan,2019
--@date   Sat,23 Mar,2019
--@date   Sat,25 Jan,2020
--@date   Sun,26 Jan,2020
--@date   Tue,07 Apr,2020
--@date   Sat,18 Apr,2020
--@date   Thu,23 Apr,2020
--@date   Tue,28 Apr,2020
--@date   Sat,30 Oct,2021
--@date   Fri,11 Mar,2022
--@date   Tue,27 Jun,2023
--@author Copyright(C)2014-2023 G-HAL
--]]

-- ##begin##
-- name : AI Brain
-- size : 6 , 3
-- footprint :
-- ######
-- ######
-- ######
-- address :
-- chip_coordinates_tag : ##010##
-- chip_number_tag : ##011##
-- chip_number : 
-- chip_footprint_tag : ##012##
-- next_address_condition_true_coordinates_tag : ##020##
-- next_address_condition_true_tag : ##021##
-- next_address_condition_true : 0010033
-- argument : 0
-- ##body##

function qrl_chip##011##(Mek, GB)
  PrintTraceMessage(GB, Mek, '##010##:##011##:AI_Brain');
  PrintTracer(GB, Mek, '##012##');
  if enable_debugger then
    dbg();
  end;

  local O = Mek_NAttValue_Action(Mek, NAS_TimeLimit);
  if (0 < O) and (GB_ComTime(GB) <= (O + CalcMoveTime(Mek, GB))) then
    g_QRL_SystemVariable["ExecQueue_Type"] = c_ExecQueue_Type_PrepActionStopAndGearUp;
  elseif (GG_Mecha == Mek_G(Mek)) and ShouldEject(Mek, GB) then
    g_QRL_SystemVariable["ExecQueue_Type"] = c_ExecQueue_Type_Eject;
  else
    local O = Mek_NAttValue_EpisodeData(Mek, NAS_Orders);
    local switch = {
      default                  = function(Mek, GB) Seek_And_Destroy(Mek, GB); end;
      [NAV_SeekAndDestroy + 1] = function(Mek, GB) Seek_And_Destroy(Mek, GB); end;
      [NAV_GotoSpot + 1]       = function(Mek, GB) GOTO_SPOT(Mek, GB); end;
      [NAV_SeekEdge + 1]       = function(Mek, GB) GOTO_EDGE(Mek, GB); end;
      [NAV_Passive + 1]        = function(Mek, GB) PASSIVE(Mek, GB); end;
      [NAV_RunAway + 1]        = function(Mek, GB) RUNAWAY(Mek, GB); end;
      [NAV_Follow + 1]         = function(Mek, GB) FOLLOW(Mek, GB); end;
    };
    (switch[O + 1] or switch.default)(Mek, GB);

    if (Mek_NAttValue_EpisodeData(Mek, NAS_ChatterRecharge) < GB_ComTime(GB)) and (1 == math.random(1,80)) and IsSafeArea(GB) then
      NPC_CombatTaunt(GB, Mek, "CHAT_SAFE");
    end;
  end;

  ClearHotMaps();
  return '##021##';
end;

-- ##end##
-- [ End of File ]
