#!/usr/local/bin/luac53 -p --
--[[
--@brief  Quasi Robot Language; LuaChip
--@date   Sun,06 Sep,2020
--@date   Mon,21 Sep,2020
--@date   Sat,31 Oct,2020
--@date   Sat,30 Oct,2021
--@date   Fri,11 Mar,2022
--@date   Mon,09 Jan,2023
--@date   Mon,26 Jun,2023
--@date   Tue,27 Jun,2023
--@author Copyright(C)2020-2023 G-HAL
--]]

-- ##begin##
-- name : IF eq WeaponType of Weapon in the Array
-- size : 5 , 2
-- footprint :
-- #####
-- #####
-- address :
-- chip_coordinates_tag : ##010##
-- chip_number_tag : ##011##
-- chip_number : 
-- chip_footprint_tag : ##012##
-- next_address_condition_true_coordinates_tag : ##020##
-- next_address_condition_true_tag : ##021##
-- next_address_condition_true : 0010023
-- next_address_condition_false_coordinates_tag : ##030##
-- next_address_condition_false_tag : ##031##
-- next_address_condition_false : 0020023
-- argument : 1
-- argument_comment[1] : Weapon Type
-- argument[1] : Melee
-- argument_tag[1] : ##111##
-- argument_type[1] : list
-- argument_list[1] : Melee , EMelee , Ballistic , BeamGun , Missile , Grenade , Arm , Leg , Tail
-- argument_geometry[1] : x:104 , y:66 , w:265 , h:31
-- ##body##

function qrl_chip##011##(Mek, GB)
  PrintTraceMessage(GB, Mek, '##010##:##011##:IF_eq_WeaponType_of_Weapon_in_the_Array');
  PrintTracer(GB, Mek, '##012##');
  if enable_debugger then
    dbg();
  end;

  local function Check(Part, GG, GS)
    if ((GG == Mek_G(Part)) and (GS == Mek_S(Part))) then
      return true;
    end;
    return false;
  end;

  switch = {
    default       = function(Wep) return false; end;
    ["Melee"]     = function(Wep) return Check(Wep, GG_Weapon, GS_Melee    ); end;
    ["EMelee"]    = function(Wep) return Check(Wep, GG_Weapon, GS_EMelee   ); end;
    ["Ballistic"] = function(Wep) return Check(Wep, GG_Weapon, GS_Ballistic); end;
    ["BeamGun"]   = function(Wep) return Check(Wep, GG_Weapon, GS_BeamGun  ); end;
    ["Missile"]   = function(Wep) return Check(Wep, GG_Weapon, GS_Missile  ); end;
    ["Grenade"]   = function(Wep) return Check(Wep, GG_Ammo,   GS_Grenade  ); end;
    ["Arm"]       = function(Wep) return Check(Wep, GG_Module, GS_Arm      ); end;
    ["Leg"]       = function(Wep) return Check(Wep, GG_Module, GS_Leg      ); end;
    ["Tail"]      = function(Wep) return Check(Wep, GG_Module, GS_Tail     ); end;
  };
  local ret = (switch["##111##"] or switch.default)(g_QRL_SystemVariable["WeaponList"][g_QRL_SystemVariable["WeaponListPtr"]]);

  if ret then
    return '##021##';
  end;
  return '##031##';
end;

-- ##end##
-- [ End of File ]
