#!/usr/local/bin/luac53 -p --
--[[
--@brief  Quasi Robot Language; LuaChip
--@date   Sun,06 Sep,2020
--@date   Mon,21 Sep,2020
--@date   Sat,30 Oct,2021
--@date   Fri,11 Mar,2022
--@date   Mon,09 Jan,2023
--@date   Mon,26 Jun,2023
--@date   Tue,27 Jun,2023
--@author Copyright(C)2020-2023 G-HAL
--]]

-- ##begin##
-- name : IF eq MoveMode of the Friend in the Array
-- size : 5 , 2
-- footprint :
-- #####
-- #####
-- address :
-- chip_coordinates_tag : ##010##
-- chip_number_tag : ##011##
-- chip_number : 
-- chip_footprint_tag : ##012##
-- next_address_condition_true_coordinates_tag : ##020##
-- next_address_condition_true_tag : ##021##
-- next_address_condition_true : 0010023
-- next_address_condition_false_coordinates_tag : ##030##
-- next_address_condition_false_tag : ##031##
-- next_address_condition_false : 0020023
-- argument : 1
-- argument_comment[1] : Move Mode
-- argument[1] : Walk
-- argument_tag[1] : ##111##
-- argument_type[1] : list
-- argument_list[1] : Walk , Roll , Skim , Fly
-- argument_geometry[1] : x:104 , y:66 , w:265 , h:31
-- ##body##

function qrl_chip##011##(Mek, GB)
  PrintTraceMessage(GB, Mek, '##010##:##011##:IF_eq_MoveMode_of_the_Friend_in_the_Array');
  PrintTracer(GB, Mek, '##012##');
  if enable_debugger then
    dbg();
  end;

  if (MM_##111## == Mek_NAttValue_Action(g_QRL_SystemVariable["FriendMekList"][g_QRL_SystemVariable["FriendMekListPtr"]], NAS_MoveMode)) then
    return '##021##';
  end;
  return '##031##';
end;

-- ##end##
-- [ End of File ]
