#!/usr/local/bin/luac53 -p --
--[[
--@brief  Quasi Robot Language; LuaChip
--@date   Sun,09 Dec,2018
--@date   Tue,01 Jan,2019
--@date   Sun,20 Jan,2019
--@date   Fri,01 Feb,2019
--@date   Sat,16 Feb,2019
--@date   Sun,26 Jan,2020
--@date   Thu,23 Apr,2020
--@date   Tue,28 Apr,2020
--@date   Sun,13 Sep,2020
--@date   Sat,30 Oct,2021
--@date   Sun,06 Mar,2022
--@date   Fri,11 Mar,2022
--@date   Mon,09 Jan,2023
--@date   Mon,26 Jun,2023
--@date   Tue,27 Jun,2023
--@author Copyright(C)2018-2023 G-HAL
--]]

-- ##begin##
-- name : Search a Path to the Target
-- size : 4 , 2
-- footprint :
-- ####
-- ####
-- address :
-- chip_coordinates_tag : ##010##
-- chip_number_tag : ##011##
-- chip_number : 
-- chip_footprint_tag : ##012##
-- next_address_condition_true_coordinates_tag : ##020##
-- next_address_condition_true_tag : ##021##
-- next_address_condition_true : 0010023
-- next_address_condition_false_coordinates_tag : ##030##
-- next_address_condition_false_tag : ##031##
-- next_address_condition_false : 0010023
-- argument : 2
-- argument_comment[1] : Direction
-- argument[1] : d
-- argument_tag[1] : ##111##
-- argument_type[1] : var
-- argument_geometry[1] : x:16 , y:62 , w:123 , h:31
-- argument_comment[2] : Range
-- argument[2] : r
-- argument_tag[2] : ##121##
-- argument_type[2] : var
-- argument_geometry[2] : x:16 , y:96 , w:123 , h:31
-- ##body##

function qrl_chip##011##(Mek, GB)
  PrintTraceMessage(GB, Mek, '##010##:##011##:Search_a_Path_to_the_Target');
  PrintTracer(GB, Mek, '##012##');
  if enable_debugger then
    dbg();
  end;

  if (nil == g_QRL_SystemVariable["TargetMek"]) then 
    return '##031##';
  end;

  local GX, GY, GZ = GearCurrentLocation(g_QRL_SystemVariable["TargetMek"]);
  local HM = GetHotMap_XY(GB, GX, GY, HotMoveMode(Mek));

  local PX, PY, PZ = GearCurrentLocation(Mek);
  local RANGE = HotMap[HM][PX][PY];

  local Best = RANGE;
  local D = -1;
  local T;
  for T = 0, 7, 1 do
    if OnTheMap_XY(PX + AngDir_X[T + 1], PY + AngDir_Y[T + 1]) then
      if (HotMap[HM][PX + AngDir_X[T + 1]][PY + AngDir_Y[T + 1]] < Best) and (ColdMap[HM][PX + AngDir_X[T + 1]][PY + AngDir_Y[T + 1]] < 1) then
        Best = HotMap[HM][PX + AngDir_X[T + 1]][PY + AngDir_Y[T + 1]];
        D = T;
      end;
    end;
  end;
  if (-1 == D) then
    return '##031##';
  end;

  local CD = Mek_NAttValue_Location(Mek, NAS_D);
  local REL_D = reldir2dir(D, CD);

  g_QRL_UserVariable_Type["##111##"] = c_Variable_Type_Num;
  g_QRL_UserVariable_Contents["##111##"] = REL_D;
  g_QRL_UserVariable_Type["##121##"] = c_Variable_Type_Num;
  g_QRL_UserVariable_Contents["##121##"] = RANGE;

  return '##021##';
end;

-- ##end##
-- [ End of File ]
