#!/usr/local/bin/luac53 -p --
--[[
--@brief  Quasi Robot Language; LuaChip
--@date   Sun,25 Nov,2018
--@date   Sun,02 Dec,2018
--@date   Tue,01 Jan,2019
--@date   Sat,16 Feb,2019
--@date   Tue,28 Apr,2020
--@date   Sat,19 Sep,2020
--@date   Sat,30 Oct,2021
--@date   Sun,06 Mar,2022
--@date   Fri,11 Mar,2022
--@date   Mon,09 Jan,2023
--@date   Mon,26 Jun,2023
--@date   Tue,27 Jun,2023
--@author Copyright(C)2018-2023 G-HAL
--]]

-- ##begin##
-- name : Target the Mek by Variable
-- size : 3 , 1
-- footprint :
-- ###
-- address :
-- chip_coordinates_tag : ##010##
-- chip_number_tag : ##011##
-- chip_number : 
-- chip_footprint_tag : ##012##
-- next_address_condition_true_coordinates_tag : ##020##
-- next_address_condition_true_tag : ##021##
-- next_address_condition_true : 0010013
-- next_address_condition_false_coordinates_tag : ##030##
-- next_address_condition_false_tag : ##031##
-- next_address_condition_false : 0010013
-- argument : 1
-- argument_comment[1] : Mek
-- argument[1] : mek
-- argument_tag[1] : ##111##
-- argument_type[1] : var
-- argument_geometry[1] : x:81 , y:16 , w:123 , h:31
-- ##body##

function qrl_chip##011##(Mek, GB)
  PrintTraceMessage(GB, Mek, '##010##:##011##:Target_the_Mek_by_Variable');
  PrintTracer(GB, Mek, '##012##');
  if enable_debugger then
    dbg();
  end;
  if (c_Variable_Type_Mek ~= g_QRL_UserVariable_Type["##111##"]) then
    PrintErrorMessage(GB, Mek, '##010##:##011##:Target_the_Mek_by_Variable:No mek is selected.');
    return '##021##';
  end;

  if (nil ~= g_QRL_UserVariable_Contents["##111##"]) then
    g_QRL_SystemVariable["TargetMek"] = g_QRL_UserVariable_Contents["##111##"];
    return '##021##';
  end;
  g_QRL_SystemVariable["TargetMek"] = nil;
  return '##031##';
end;

-- ##end##
-- [ End of File ]
