#!/usr/local/bin/luac53 -p --
--[[
--@brief  Quasi Robot Language; LuaChip
--@date   Tue,15 Aug,2017
--@date   Fri,18 Aug,2017
--@date   Sun,03 Sep,2017
--@date   Sun,02 Dec,2018
--@date   Tue,01 Jan,2019
--@date   Sun,20 Jan,2019
--@date   Fri,01 Feb,2019
--@date   Sat,16 Feb,2019
--@date   Tue,28 Apr,2020
--@date   Tue,15 Sep,2020
--@date   Sat,30 Oct,2021
--@date   Sat,19 Feb,2022
--@date   Sun,06 Mar,2022
--@date   Mon,09 Jan,2023
--@date   Mon,26 Jun,2023
--@date   Tue,27 Jun,2023
--@author Copyright(C)2017-2023 G-HAL
--]]

-- ##begin##
-- name : IF le
-- size : 6 , 2
-- footprint :
-- ######
-- #  
-- address :
-- chip_coordinates_tag : ##010##
-- chip_number_tag : ##011##
-- chip_number : 
-- chip_footprint_tag : ##012##
-- next_address_condition_true_coordinates_tag : ##020##
-- next_address_condition_true_tag : ##021##
-- next_address_condition_true : 0020013
-- next_address_condition_false_coordinates_tag : ##030##
-- next_address_condition_false_tag : ##031##
-- next_address_condition_false : 0010023
-- argument : 2
-- argument_comment[1] : Left Parameter
-- argument[1] : var
-- argument_tag[1] : ##111##
-- argument_tag_raw[1] : ##112##
-- argument_type[1] : var-num
-- argument_type_selected[1] : ##113##
-- argument_geometry[1] : x:89 , y:16 , w:123 , h:31
-- argument_comment[2] : Right Parameter
-- argument[2] : var
-- argument_tag[2] : ##121##
-- argument_tag_raw[2] : ##122##
-- argument_type[2] : var-num
-- argument_type_selected[2] : ##123##
-- argument_geometry[2] : x:253 , y:16 , w:123 , h:31
-- ##body##

function qrl_chip##011##(Mek, GB)
  PrintTraceMessage(GB, Mek, '##010##:##011##:IF_le');
  PrintTracer(GB, Mek, '##012##');
  if enable_debugger then
    dbg();
  end;

  local argument_1_is_num = false;
  if (c_Argument_TypeName_Num == "##113##") then
    argument_1_is_num = true;
  elseif ((c_Argument_TypeName_Var == "##113##") and (c_Variable_Type_Num == g_QRL_UserVariable_Type["##112##"])) then
    argument_1_is_num = true;
  end;
  local argument_2_is_num = false;
  if (c_Argument_TypeName_Num == "##123##") then
    argument_2_is_num = true;
  elseif ((c_Argument_TypeName_Var == "##123##") and (c_Variable_Type_Num == g_QRL_UserVariable_Type["##122##"])) then
    argument_2_is_num = true;
  end;
  if (argument_1_is_num and argument_2_is_num) then
  else
    PrintErrorMessage(GB, Mek, '##010##:##011##:IF_le:Argument(s) type mismatch.');
    return '##031##';
  end;

  if (##111## <= ##121##) then
    return '##021##';
  end;
  return '##031##';
end;

-- ##end##
-- [ End of File ]
