#!/usr/local/bin/luac53 -p --
--[[
--@brief  Quasi Robot Language; LuaChip
--@date   Sun,04 Oct,2020
--@date   Sat,30 Oct,2021
--@date   Thu,30 Dec,2021
--@date   Sat,19 Feb,2022
--@date   Sun,06 Mar,2022
--@date   Mon,09 Jan,2023
--@date   Mon,26 Jun,2023
--@date   Tue,27 Jun,2023
--@author Copyright(C)2020-2023 G-HAL
--]]

-- ##begin##
-- name : Telecommunication Recv
-- size : 4 , 2
-- footprint :
-- ####
-- ####
-- address :
-- chip_coordinates_tag : ##010##
-- chip_number_tag : ##011##
-- chip_number : 
-- chip_footprint_tag : ##012##
-- next_address_condition_true_coordinates_tag : ##020##
-- next_address_condition_true_tag : ##021##
-- next_address_condition_true : 0010023
-- next_address_condition_false_coordinates_tag : ##030##
-- next_address_condition_false_tag : ##031##
-- next_address_condition_false : 0010023
-- argument : 2
-- argument_comment[1] : Channel
-- argument[1] : 100
-- argument_tag[1] : ##111##
-- argument_type[1] : num
-- argument_geometry[1] : x:150 , y:16 , w:123 , h:31
-- argument_comment[2] : Message
-- argument[2] : var
-- argument_tag[2] : ##121##
-- argument_type[2] : var
-- argument_geometry[2] : x:150 , y:94 , w:123 , h:31
-- ##body##

function qrl_chip##011##(Mek, GB)
  PrintTraceMessage(GB, Mek, '##010##:##011##:Telecommunication_Recv');
  PrintTracer(GB, Mek, '##012##');
  if enable_debugger then
    dbg();
  end;

  local t = Mek_SAttValue(Mek, (QRL_Telecommunication_TAG .. "##111##_TYPE"));
  local msg = Mek_SAttValue(Mek, (QRL_Telecommunication_TAG .. "##111##"));
  if (c_Variable_TypeName_GUID == t) then
    g_QRL_UserVariable_Type["##121##"] = c_Variable_Type_GUID;
    g_QRL_UserVariable_Contents["##121##"] = msg;
  elseif (c_Variable_TypeName_String == t) then
    g_QRL_UserVariable_Type["##121##"] = c_Variable_Type_String;
    g_QRL_UserVariable_Contents["##121##"] = msg;
  elseif (c_Variable_TypeName_Num == t) then
    g_QRL_UserVariable_Type["##121##"] = c_Variable_Type_Num;
    g_QRL_UserVariable_Contents["##121##"] = tonumber(msg);
  else
    PrintErrorMessage(GB, Mek, '##010##:##011##:Telecommunication_Recv:Illigal Message.');
    return '##031##';
  end;
  return '##021##';
end;

-- ##end##
-- [ End of File ]
