#!/usr/local/bin/luac53 -p --
--[[
--@brief  Quasi Robot Language
--@author Copyright(C)2015 G-HAL
--]]

local jit_mode = false;
if jit then
  jit_mode = true;
end;

require "LuaData/global_mod/global_mod";
require "LuaData/stamp";
require "LuaData/asvmacro";
require "LuaData/macro4qrl";
require "LuaData/lib";
require "LuaData/locale";
require "LuaData/aibrain";
define_global("A_Star", nil);
A_Star = require "LuaData/a_star";
require "LuaData/lib4qrl";

define_global("lua_bit", nil);
if package.loaded["bit"] then
  lua_bit = require 'bit';
elseif package.loaded["bit32"] then
  lua_bit = require 'bit32';
end;

define_const("Version_I18N_LuaContainer", "Heart 2022030801");



-- Debugger Function

local enable_debugger = false;
define_global("dbg");
if not jit_mode then
  dbg = require "LuaData/debugger/debugger";
  dbg.auto_where = false;
end;

function call_debugger(flag)
  if jit_mode then
  else
    if (0 == flag) then
      enable_debugger = false;
      dbg.auto_where = false;
    else
      enable_debugger = true;
      dbg.auto_where = 2;
    end;
  end;
  return;
end;



--- Chip Arrangement

define_const("Version_I18N_LuaChip", "Heart 2022031101");

-- ##begin##
-- name : BEGIN
-- address : 1 , 1
-- chip_number : 0001
-- next_address_condition_true : 0010013
-- ##body##

function qrl_chip0000(Mek, GB)
  return qrl_chip0001(Mek, GB);
end;

function qrl_chip0001(Mek, GB)
  PrintTraceMessage(GB, Mek, '001-001:0001:BEGIN');
  PrintTracer(GB, Mek, '001-001,');
  if enable_debugger then
    dbg();
  end;
  local ret = SetChipMode(GB, Mek, QRL_CHIPMODE_BEGIN);
  if ret then
    qrl_chip_exec(GB, Mek);
  end;
  return '0002';
end;

-- ##end##

-- ##begin##
-- name : AI Brain
-- address : 1 , 2
-- chip_number : 0002
-- next_address_condition_true : 0010033
-- ##body##

function qrl_chip0002(Mek, GB)
  PrintTraceMessage(GB, Mek, '001-002:0002:AI_Brain');
  PrintTracer(GB, Mek, '001-002,002-002,003-002,004-002,005-002,006-002,001-003,002-003,003-003,004-003,005-003,006-003,001-004,002-004,003-004,004-004,005-004,006-004,');
  if enable_debugger then
    dbg();
  end;

  local O = Mek_NAttValue_Action(Mek, NAS_TimeLimit);
  if (0 < O) and (GB_ComTime(GB) <= (O + CalcMoveTime(Mek, GB))) then
    g_QRL_SystemVariable["ExecQueue_Type"] = c_ExecQueue_Type_PrepActionStopAndGearUp;
  elseif (GG_Mecha == Mek_G(Mek)) and ShouldEject(Mek, GB) then
    g_QRL_SystemVariable["ExecQueue_Type"] = c_ExecQueue_Type_Eject;
  else
    local O = Mek_NAttValue_EpisodeData(Mek, NAS_Orders);
    local switch = {
      default                  = function(Mek, GB) Seek_And_Destroy(Mek, GB); end;
      [NAV_SeekAndDestroy + 1] = function(Mek, GB) Seek_And_Destroy(Mek, GB); end;
      [NAV_GotoSpot + 1]       = function(Mek, GB) GOTO_SPOT(Mek, GB); end;
      [NAV_SeekEdge + 1]       = function(Mek, GB) GOTO_EDGE(Mek, GB); end;
      [NAV_Passive + 1]        = function(Mek, GB) PASSIVE(Mek, GB); end;
      [NAV_RunAway + 1]        = function(Mek, GB) RUNAWAY(Mek, GB); end;
      [NAV_Follow + 1]         = function(Mek, GB) FOLLOW(Mek, GB); end;
    };
    (switch[O + 1] or switch.default)(Mek, GB);

    if (Mek_NAttValue_EpisodeData(Mek, NAS_ChatterRecharge) < GB_ComTime(GB)) and (1 == math.random(1,80)) and IsSafeArea(GB) then
      NPC_CombatTaunt(GB, Mek, "CHAT_SAFE");
    end;
  end;

  ClearHotMaps();
  return '0003';
end;

-- ##end##

-- ##begin##
-- name : EXECUTE
-- address : 1 , 5
-- chip_number : 0003
-- next_address_condition_true : 0010023
-- ##body##

function qrl_chip0003(Mek, GB)
  PrintTraceMessage(GB, Mek, '001-005:0003:EXECUTE');
  PrintTracer(GB, Mek, '001-005,002-005,001-006,002-006,');
  if enable_debugger then
    dbg();
  end;
  SetChipMode(GB, Mek, QRL_CHIPMODE_EXEC);

  qrl_chip_exec(GB, Mek);

  ClearHotMaps();
  return '0004';
end;

-- ##end##

-- ##begin##
-- name : END
-- address : 1 , 7
-- chip_number : 0004
-- ##body##

function qrl_chip0004(Mek, GB)
  PrintTraceMessage(GB, Mek, '001-007:0004:END');
  PrintTracer(GB, Mek, '001-007,');
  if enable_debugger then
    dbg();
  end;
  SetChipMode(GB, Mek, QRL_CHIPMODE_END);
  return '0000';
end;

-- ##end##

-- [ End of File ]
