#!/usr/local/bin/luac53 -p --
--[[
--@brief  Quasi Robot Language; Lua Library
--@date   Sun,06 Sep,2015
--@date   Sun,20 Sep,2015
--@date   Wed,28 Oct,2015 - Thu,29 Oct,2015
--@date   Sun,22 Nov,2015
--@date   Sun,13 Dec,2015
--@date   Sat,19 Dec,2015
--@date   Sun,27 Dec,2015
--@date   Sun,10 Jan,2016
--@date   Mon,17 Jul,2017
--@date   Tue,15 Aug,2017
--@date   Sun,03 Sep,2017
--@date   Fri,05 Jan,2018
--@date   Sat,14 Apr,2018
--@date   Sat,12 May,2018
--@date   Sat,24 Nov,2018
--@date   Sun,25 Nov,2018
--@date   Sun,02 Dec,2018
--@date   Sun,09 Dec,2018
--@date   Sat,25 Jan,2020
--@date   Sat,18 Apr,2020
--@date   Thu,23 Apr,2020
--@date   Sun,04 Oct,2020
--@date   Sun,11 Oct,2020
--@date   Sat,17 Oct,2020
--@date   Wed,21 Oct,2020
--@date   Tue,08 Mar,2022
--@author Copyright(C)2015-2022 G-HAL
--]]



-- Common Functions

function reldir2dir(target_dir, current_dir)
  -- target_dir, current_dir
  -- 5  6  7
  --  \ | /
  --   \|/
  -- 4--@--0
  --   /|\
  --  / | \
  -- 3  2  1
  local base_ang = current_dir * 45;
  local abs_ang = target_dir * 45;

  local a_rel = ((360 + abs_ang - base_ang) % 360);
  if (a_rel <= 180) then
    return a_rel;
  else
    return (a_rel - 360);
  end;
  --          front
  --       -45  0  +45
  --          \ | /
  --           \|/
  -- left -90 --@-- +90 right
  --           /|\
  --          / | \
  --      -135 180  +135
  --           rear
end;

function relpos2dir(x_rel, y_rel, z_rel, current_dir)
  if ((0 == x_rel) and (0 == y_rel)) then
    return 0;
  end;

  -- current_dir
  -- 5  6  7
  --  \ | /
  --   \|/
  -- 4--@--0
  --   /|\
  --  / | \
  -- 3  2  1
  local base_ang = current_dir * 45;

  local abs_theta = math.atan2(y_rel, x_rel);
  local abs_ang = (abs_theta * 180 / math.pi);

  local a_rel = ((360 + abs_ang - base_ang) % 360);
  if (a_rel <= 180) then
    return a_rel;
  else
    return (a_rel - 360);
  end;
  --          front
  --       -45  0  +45
  --          \ | /
  --           \|/
  -- left -90 --@-- +90 right
  --           /|\
  --          / | \
  --      -135 180  +135
  --           rear
end;

function GetModule(P)
  while (nil ~= P) do
    if (GG_Module == Mek_G(P)) then
      return P;
    end;
    P = Mek_Next(P);
  end;
  return P;
end;

-- [ End of File ]
