#!/usr/local/bin/luac53 -p --
--[[
--@brief  Quasi Robot Language; locale
--@date   Sun,19 Apr,2020
--@date   Wed,22 Apr,2020
--@date   Thu,23 Apr,2020
--@date   Sat,25 Apr,2020
--@date   Sun,04 Oct,2020
--@author Copyright(C)2020 G-HAL
--]]



define_const("LowShadow", -3);
define_const("HiShadow", 5);

local Shadow_Map = {};
local Shadow_Map_Update = 0;


function InitShadowMap_for_HotMap()
  local X, Y, Z;
  for X = 1, XMax, 1 do
    Shadow_Map[X] = {};
    for Y = 1, YMax, 1 do
      Shadow_Map[X][Y] = {};
      for Z = LowShadow, HiShadow, 1 do
        Shadow_Map[X][Y][Z] = 0;
      end;
    end;
  end;
  Shadow_Map_Update = 0;
  return;
end;

function UpdateShadowMap_for_HotMap(GB)
  local X, Y, Z;
  for X = 1, XMax, 1 do
    for Y = 1, YMax, 1 do
      for Z = LowShadow, HiShadow, 1 do
        Shadow_Map[X][Y][Z] = 0;
      end;
    end;
  end;

  local M = GB_Meks(GB);
  while (nil ~= M) do
    -- if (GG_DisposeGear < Mek_G(M)) then
      if (GG_MetaTerrain == Mek_G(M)) and NotDestroyed(M) then
        local X, Y = GearCurrentLocation(M);
        if OnTheMap_XY(X, Y) then
          for Z = LowShadow, HiShadow, 1 do
            if (Z <= Mek_Stat(M, STAT_Altitude)) then
              if (Mek_Stat(M, STAT_Pass) <= -100) then
                Shadow_Map[X][Y][Z] = -1;
              elseif (0 <= Shadow_Map[X][Y][Z]) then
                Shadow_Map[X][Y][Z] = Shadow_Map[X][Y][Z] + Mek_Stat(M, STAT_Obscurement);
              end;
            end;
          end;
        end;
      end;
    -- end;
    M = Mek_Next(M);
  end;

  Shadow_Map_Update = GB_ComTime(GB);
  return;
end;

function TileBlocksLOS_for_HotMap(GB, X, Y, Z)
  if (HiShadow < Z) then
    Z = HiShadow
  elseif (Z < LowShadow) then
    Z = LowShadow;
  end;
  if (Shadow_Map[X][Y][Z] < 0) then
    return true;
  end;
  return (Z < TerrMan_Altitude(GB_Map_Terr(GB, X, Y)));
end;

function IsBlocked_for_HotMap(Mek, GB, X, Y)
  local P_X, P_Y = GearCurrentLocation(Mek);
  local Special = "";
  if (nil ~= GB_Scene(GB)) then
    Special = string.upper(Mek_SAttValue(GB_Scene(GB), "SPECIAL"));
  end;

  if not OnTheMap_XY(X, Y) then
    return (nil ~= string.match(Special, SA_MapEdgeObstacle));

  elseif (P_X == X) and (P_Y == Y) then
    return false;

  elseif IsObstacle(GB, Mek, GB_Map_Terr(GB, X, Y)) then
    return true;

  else
    if IsMasterGear(Mek) and (GB_Scale(GB) <= Mek_Scale(Mek)) then
      local M = FindBlockerXYZ(GB, X, Y, MekAltitude(GB, Mek));
      if (nil ~= M) and (GB_Scale(GB) <= Mek_Scale(M)) and GearOperational(M) then
        return true;
      else
        return false;
      end;
    else
      return false;
    end;
  end;
  return true;
end;

function ForwardMoveBlocked_for_HotMap(Mek, GB)
  local P_X, P_Y, P_Z = GearCurrentLocation(Mek);
  local D = Mek_NAttValue_Location(Mek, NAS_D);
  local P2_X = P_X + AngDir_X[D + 1];
  local P2_Y = P_Y + AngDir_Y[D + 1];
  return IsBlocked_for_HotMap(Mek, GB, P2_X, P2_Y);
end;

function IsInCover_for_HotMap(GB, Master)
  if (Shadow_Map_Update < GB_ComTime(GB)) then
    UpdateShadowMap_for_HotMap(GB);
  end;

  if (nil ~= Mek_Parent(Master)) then
    Master = FindRoot(Master);
  end;

  local X, Y = GearCurrentLocation(Master);
  local Z = MekAltitude(GB, Master);

  local terr = GB_Map_Terr(GB, X, Y);
  if (Z < 0) then
    return true;
  elseif (TerrMan_Altitude(terr) < Z) then
    return false;
  else
    return (0 < TerrMan_Obscurement(terr)) or (0 < Shadow_Map[X][Y][Z]);
  end;
  return false;
end;

-- [ End of File ]
