/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.AbstractMapTester;
import com.google.common.collect.testing.WrongType;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import java.util.Map;

@GwtCompatible
public class MapContainsKeyTester<K, V>
extends AbstractMapTester<K, V> {
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testContains_yes() {
        MapContainsKeyTester.assertTrue((String)"containsKey(present) should return true", (boolean)this.getMap().containsKey(((Map.Entry)this.samples.e0).getKey()));
    }

    public void testContains_no() {
        MapContainsKeyTester.assertFalse((String)"containsKey(notPresent) should return false", (boolean)this.getMap().containsKey(((Map.Entry)this.samples.e3).getKey()));
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_QUERIES})
    public void testContains_nullNotContainedButAllowed() {
        MapContainsKeyTester.assertFalse((String)"containsKey(null) should return false", (boolean)this.getMap().containsKey(null));
    }

    @MapFeature.Require(absent={MapFeature.ALLOWS_NULL_QUERIES})
    public void testContains_nullNotContainedAndUnsupported() {
        this.expectNullKeyMissingWhenNullKeysUnsupported("containsKey(null) should return false or throw");
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEYS})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testContains_nonNullWhenNullContained() {
        this.initMapWithNullKey();
        MapContainsKeyTester.assertFalse((String)"containsKey(notPresent) should return false", (boolean)this.getMap().containsKey(((Map.Entry)this.samples.e3).getKey()));
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEYS})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testContains_nullContained() {
        this.initMapWithNullKey();
        MapContainsKeyTester.assertTrue((String)"containsKey(null) should return true", (boolean)this.getMap().containsKey(null));
    }

    public void testContains_wrongType() {
        try {
            MapContainsKeyTester.assertFalse((String)"containsKey(wrongType) should return false or throw", (boolean)this.getMap().containsKey((Object)WrongType.VALUE));
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }
}

