package com.sample;

import com.tangosol.net.CacheFactory;
import com.tangosol.net.NamedCache;


// use mysql;
// CREATE TABLE keyvalue (id varchar(10), value varchar(100), PRIMARY KEY (id));
//
public class Main {

	public static void main(String[] args) {
		Main main = new Main();
		main.execute();
	}

	private void execute() {

		String key = "k1";
		String value = "Hello World!";

		CacheFactory.ensureCluster();
		//NamedCache cache = CacheFactory.getCache("example-distributed");
		NamedCache cache = CacheFactory.getCache("test");

		cache.put(key, value);
		System.out.println((String) cache.get(key));
		
		for (int i = 0; i < 30; i++){
			try {
				Thread.sleep(1000);
				System.out.println("key=" + key + String.format("_%1$03d", i));
				cache.put(key + String.format("_%1$03d", i), value);
			} catch (InterruptedException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		
		CacheFactory.shutdown();
	}

}
