package shooting;

public class Enemy {

	public float x,y;
	public float vx,vy;
	public float appearX;
	public float direction, maxSpeed;
	public float size;
	public float roll,yaw,pitch;//yow：縦回転（ｙ軸）、roll：横回転（ｚ軸）、pitch：上下回転（ｘ軸）
	public float rollSpeed ;//縦回転するスピード
	public float yawSpeed ;//回転するスピード
	public float pitchSpeed ;//ピッチするスピード
	public int score;//そのエイリアンのスコア
	public float r, s, t, u;//内部で使用する汎用変数
	public int type;//typeはエイリアンのタイプを表す
	public int number;//そのグループ内での番号。
	public int state;//stateはエイリアンの状態を表す。
	public int appear;//出現するパターン（EnemyGroupのappearPatternをロードする）
	public int apperCount;//出現した回数
	public int apperLimit = 5;//〜回画面下に消えたらそのエイリアンは削除する。

	//コンストラクタ（EnemyGroupから作る）
	public Enemy(EnemyGroup g){

		type = g.createType;
		//0…コメット型
		//1…T2ウイルス型
		//2…ロケット型

		appear = g.appearPattern;
		//0…ランダムに発生
		//1…隊列を組んで発生
		//2…ロケットを狙ってランダムに発生

		state = 1;
		//0：まだ出現していない
		//1：画面に出現中
		//2：弾丸があたった
		//3：自分のロケットにあたった
		//4：画面外に出て消滅させるとき（ロケットがやられたあとなど）

		maxSpeed = g.getMaxSpeed();

		apperCount = 0;//画面下に消えたカウント。
		number = g.createNum;

		switch (type){
		case 0://コメット型
			switch (appear){
			//ランダムに発生させるときはここで座標やベクトルを定める。
			//隊列を組むときはグループオブジェクトに保存してある座標とベクトルを使う。
			case 0://random
				x = (float)(Math.random()*Main.width);//出現する場所はランダムに
				y = Main.height+30;//画面の少し上から出現する。
				vx = (float)(Math.random()* maxSpeed * 2)-maxSpeed;//横移動量は−５〜５の間で
				vy = (-maxSpeed /2) + (float)(-maxSpeed * Math.random());//落ちてくるスピード
				break;
			case 1://make a row
				x = g.x;
				y = g.y;
				vx = g.vx;
				vy = g.vy;
				break;
			case 2://狙ってくる
				x = (float)(Math.random()*Main.width);//出現する場所はランダムに
				y = Main.height+30;//画面の少し上から出現する。
				vx = (this.x - Main.x);
				vy = (this.y - Main.y);
				s = (-maxSpeed /2) + (float)(-maxSpeed * Math.random());
				float l = Distance(this.x, this.y, Main.x, Main.y);
				vx = vx /l *s;
				vy = vy /l *s;
				break;
			}

			roll = (float)(Math.random()*360);
			yaw = 0;
			rollSpeed = 3;//縦回転する。
			yawSpeed = 0;//横回転しない。

			size = 20;
			score = 10;

			break;

		case 1://T2ウイルスタイプ
			switch (appear){
			case 0://random
				x = (float)(Math.random()*Main.width);//出現する場所はランダムに
				y = Main.height+30;//画面の少し上から出現する。
				vx = (float)(Math.random()*maxSpeed *3)-maxSpeed * 1.5f;//横移動量
				vy = ((-maxSpeed /2) + (float)(-maxSpeed * Math.random()))* 0.4f;//落ちてくるスピード
				break;
			case 1://make a row
				x = g.x;
				y = g.y;
				vx = g.vx;
				vy = g.vy;
				s =  g.s;
				break;
			}

			roll = (float)(Math.random()*360);
			yaw = 0;
			rollSpeed = 3;
			yawSpeed = 0;

			size = 20;
			score = 20;
			break;
		case 2://ロケットタイプ
			switch (appear){
			case 0://random
				x = (float)(Math.random()*Main.width);//出現する場所はランダムに
				y = Main.height+30;//画面の少し上から出現する。
				vx = 0;
				vy = (-maxSpeed /2) + (float)(-maxSpeed * Math.random());//落ちてくるスピード
				s = (float)(Main.x - x);//加速度。

				break;
			case 1://make a row
				x = g.x;
				y = g.y;
				vx = 0;
				vy = -maxSpeed;
				s = (float)(Main.x - x);//加速度。
				break;
			}

			roll = (float)(Math.random()*360);
			yaw = 0;
			rollSpeed = 3;
			yawSpeed = 0;

			size = 20;
			score = 20;
			break;
		case 3://円運動型
			switch (appear){
			case 0://random
				x = (float)(Math.random()*Main.width);//出現する場所はランダムに
				y = Main.height+30;//画面の少し上から出現する。
				//ベクトルを定める。
				double vec;
				double spd;
				vec = (double)((Math.random()*90)+225)*Math.PI/180;
				spd = (double)(maxSpeed * 0.3);
				vx = (float)(Math.cos(vec)*spd);
				vy = (float)(Math.sin(vec)*spd);
				
				s = maxSpeed;//円の半径。
				r = 1.8f; //角度の増減分。
				u = 180;//（初期の）進行方向の角度
				// 1/2の確率で逆回転
				int rnd = (int)(Math.random()*2);
				if (rnd == 0){
					r = -r;
					u = -u;
				}
				break;
			case 1://make a row
				x = g.x;
				y = g.y;
				vx = g.vx;
				vy = g.vy;
				s = g.s;//円の半径
				r = g.round;//角度の増加分
				if ( r<0){
					u = -180;//（初期の）進行方向の角度
				}else{
					u = 180;//（初期の）進行方向の角度
				}
				
				
				break;
			}
			//横回転する(縦に揺れる）
			roll = 0;
			yaw = 0;//(float)(Math.random()*360);
			rollSpeed = 3;
			yawSpeed = 0;//3;

			size = 20;
			score = 10;
			
			break;
		}
	}

	public int update(float gx){

		//衝突判定
		//自分のロケットとの衝突判定
		float distance;
		distance = Distance(this.x, this.y, Main.x, Main.y);

		if ( distance < this.size + Main.rocketSize && Math.abs(Main.aileronRoll) != 3){
			//距離がこの敵のサイズとロケットのサイズの合計より小さいなら衝突。エルロンロール中は判定しない。
			//自分のロケットが破壊された処理
			this.state = 3;
		}//end if

		//弾丸との衝突判定
		for ( int i=0; i<Main.bulletNum; i++){
			if (Main.bullet[i].bulletState){//弾丸は発射されている時にのみ判定をする。
				distance = Distance(this.x, this.y, Main.bullet[i].bulletX, Main.bullet[i].bulletY);

				if (distance < this.size + Main.bulletSize){
					//敵自身が破壊された処理
					this.state = 2;//2:破壊された（弾があたった）
					Main.bullet[i].bulletState = false;//bulletを消す。
				}//end if(弾があたったか？)
			}//end if(弾は発射されているか？)
		}//for i
		//移動処理

		boolean screenOut = false;

		switch (type){

		case 0:////////////////////////////彗星型/////////////
			//x座標の加算と画面外に出た時の処理
			this.x = this.x + this.vx * Main.move;

			if (this.x > Main.width){
				this.x = 0;
				screenOut = true;
			}
			if (this.x < 0-this.size){
				this.x = Main.width;
				screenOut = true;
			}

			//y座標の加算と画面外に出た時の処理
			this.y = this.y + this.vy * Main.move;

			if (this.y < 0 -this.size -100){
				this.y = Main.height + this.size;
				this.t = -1;
				//もし列を組んで出現するパターンであるならば
				//上から出てくるときのx座標はグループのx座標とする。
				//画面下に出たことをt=-1で知らせる。
				if (this.appear == 1 ){
					this.x = gx;
				}
				// 狙ってくるときは再度画面上から出現するときベクトルを更新して再び狙いを定める。
				if (this.appear == 2){
					this.vx = (this.x - Main.x);
					this.vy = (this.y - Main.y);
					this.s = (-maxSpeed /2) + (float)(-maxSpeed * Math.random());
					float l = Distance(this.x, this.y, Main.x, Main.y);
					this.vx = vx /l *s;
					this.vy = vy /l *s;
				}
				this.apperCount ++;
				screenOut = true;
			}

			this.roll = this.roll + this.rollSpeed;
			if ( this.roll > 360){
				this.roll = this.roll - 360;
			}
			this.direction = DegAtan(this.vx, this.vy) +90;
			if (this.direction > 360) this.direction = this.direction - 360;

			break;

		case 1:////////////////////////////T2ウイルス型/////////////
			//x座標の加算と画面外に出た時の処理
			r ++;
			if (r > 10800 ) r -= 10800;

			this.vx = (float)(Math.sin(r/30) * 8f) + s;
			if (this.vx > maxSpeed * 1.5f) this.vx = maxSpeed * 1.5f;
			if (this.vx < -maxSpeed * 1.5f) this.vx = -maxSpeed *1.5f;

			this.x = this.x + this.vx * Main.move;
			if (this.x > Main.width){
				this.x = 0;
				screenOut = true;
			}
			if (this.x < 0-this.size){
				this.x = Main.width;
				screenOut = true;
			}
			//y座標の加算と画面外に出た時の処理
			this.y = this.y + this.vy * Main.move;
			if (this.y < 0 -this.size -100){
				this.y = Main.height + this.size;
				this.t = -1;
				//もし列を組んで出現するパターンであるならば
				//上から出てくるときのx座標はグループのx座標とする。
				//画面下に出たことをt=-1で知らせる。
				if (this.appear == 1 ){
					this.x = gx;
				}
				this.apperCount ++;
				screenOut = true;
			}

			this.roll = this.roll + this.rollSpeed;
			if ( this.roll > 360){
				this.roll = this.roll - 360;
			}
			break;
		case 2:////////////////////////////ロケット型/////////////
			//x座標の加算と画面外に出た時の処理
			this.x = this.x + this.vx * Main.move;
			this.vx = this.vx + this.s/7000;//ちょっとずつ向きを変える
			if (this.vx < -maxSpeed * 1.3f) this.vx = -maxSpeed *1.3f;
			if (this.vx > maxSpeed  * 1.3f) this.vx = maxSpeed  *1.3f;

			if (this.x > Main.width){
				this.x = 0;
				screenOut = true;
			}
			if (this.x < 0-this.size){
				this.x = Main.width;
				screenOut = true;
			}
			//y座標の加算と画面外に出た時の処理
			this.y = this.y + this.vy * Main.move;
			if (this.y < 0 -this.size -100){
				this.t = -1;
				//もし列を組んで出現するパターンであるならば
				//上から出てくるときのx座標はグループのx座標とする。
				//画面下に出たことをt=-1で知らせる。
				if (this.appear == 1 ){
					this.x = gx;
				}
				this.y = Main.height + this.size;
				this.vx = 0;
				this.s = (int)(Main.x - x);
				this.apperCount ++;
				screenOut = true;
			}

			this.roll = this.roll + this.rollSpeed;
			if ( this.roll > 360){
				this.roll = this.roll - 360;
			}

			this.direction = DegAtan(this.vx, this.vy) +90;
			if (this.direction > 360) this.direction = this.direction - 360;

			break;
		case 3:////////////////////////////円運動型/////////////
			//x座標の加算と画面外に出た時の処理
			float ox,oy;//円運動用のベクトル
			// s:円の半径
			// r:角度の増加分
			// u:進行方向の角度
			double upi;
			upi = u * Math.PI/180;
			ox = (float)(Math.cos(upi)*s);
			oy = (float)(Math.sin(upi)*s);
			u = u + r;
			if ( u>360 ) u = u - 360;
			
			this.x = this.x + ox + this.vx * Main.move;
			
			if (this.x > Main.width){
				this.x = 0;
				screenOut = true;
			}
			if (this.x < 0-this.size){
				this.x = Main.width;
				screenOut = true;
			}
			//y座標の加算と画面外に出た時の処理
			this.y = this.y + oy + this.vy * Main.move;
			if (this.y < 0 -this.size -100){
				this.t = -1;
				//もし列を組んで出現するパターンであるならば
				//上から出てくるときのx座標はグループのx座標とする。
				//画面下に出たことをt=-1で知らせる。
				if (this.appear == 1 ){
					this.x = gx;
				}
				this.y = Main.height + this.size;
				this.apperCount ++;
				screenOut = true;
			}

			/*this.yaw = this.yaw + this.yawSpeed;
			if ( this.yaw > 360){
				this.yaw = this.yaw - 360;*/
			this.roll = this.roll + this.rollSpeed;
			if (this.roll > 80 ){
				this.rollSpeed = -this.rollSpeed;
			}
			if (this.roll < -80 ){
				this.rollSpeed = -this.rollSpeed;
			}

			this.direction = DegAtan(this.vx + ox, this.vy + oy) +90;
			if (this.direction > 360) this.direction = this.direction - 360;

			break;
		}
		if (Main.game == 2 && screenOut ) state = 4;//自分のロケットがやられているか
		if (this.apperCount > this.apperLimit ) state = 4;//画面にapperLimit(5)回出現した時は消える。

		return state;
	}//end of update
	//(x0, y0)から(x, y)）までの距離を求める
	public float Distance(float x0, float y0, float x, float y){
		float a;
		a = (float)(Math.sqrt(Math.pow(x0 -x, 2) + Math.pow(y0 -y, 2)));
		return a;
	}
	//（ｘ，ｙ）から角度を求める
	public static float DegAtan(float x, float y){
		float d;
		//角度が垂直か水平のときの処理　さらにvx=0のときはtanが計算できない
		if (x == 0){
			if (y>0){
				d = 90;
			}else{
				d = 270;
			}
			if (y == 0) {
				if (x > 0){
					d = 0;
				}else{
					d = 180;
				}
			}
			//tanの逆関数で角度をもとめる
		}else{
			d = (float)(Math.atan(y/x)*180/(Math.PI));
			if (x < 0 ) d += 180;//第2,3事象
			if (x > 0 && y < 0) d += 360;//第４事象
		}
		//もし(x,y)=(0,0)ならば計算できないとして-1を返す
		if (x == 0 && y == 0){
			d = -1;
		}
		return d;
	}

}





