package shooting;

import java.util.ArrayList;

public class EnemyGroup {

	int createType;
	int num;//敵を作る数（保存用）
	int firstShotCount;//初出現で撃ち落とした数をカウントする。
	boolean firstShot;//初出現ボーナス用のフラグ
	int createNum;//敵を作る数（カウントダウン用）
	int appearPattern;
	int count;//連続して隊列を組むなどの時に使用するカウンタ
	int interval = 10;//連続発生のインターバル
	int life;//グループの寿命
	float x, y, vx, vy;
	float s,round;
	int maxSpeed;

	//敵
	public ArrayList<Enemy> enemy = new ArrayList<Enemy>(); 
	public static int groupLife;

	/////////////////コンストラクタ////////////////////////
	EnemyGroup(int a, int  b, int c){// a=createNum, b=life, c=MaxSpeed

		createType = (int)(Math.random()*4);
		createNum = a;//このグループで発生させるエイリアンの数
		num = a;
		firstShotCount = 0;
		firstShot = true;
		life = b;//次のグループが出現するまでの時間
		maxSpeed = c;//最大速度

		//隊列を組むときのための座標を定める。
		x = (float)(Math.random()*Main.width);//出現する場所はランダムに
		y = Main.height+30;//画面の少し上から出現する。

		switch (createType){
		case 0://彗星型
			int r = (int)(Math.random()*100);
			if ( r < 30 ) {
				appearPattern = 1;//確率30%で隊列を組む。
				//隊列を組むときのためのベクトルをつくる。
				vx = (float)(Math.random()* getMaxSpeed() * 2)- getMaxSpeed();//横移動量は−５〜５の間で
				vy = -getMaxSpeed();//落ちてくるスピードは一定。
			}
			else{
				appearPattern = 0;// 70%の確率でランダム出現
				firstShot = false;
			}
			if (Main.score > 1000 && (Math.random()*5000/( Main.score + 1)) < 1f ){
				appearPattern = 2;// スコアが高くなると狙ってくる確率が高くなる。
			}
			break;

		case 1://T2ウイルス型
			r = (int)(Math.random()*100);
			if ( r < 70 ) {
				appearPattern = 1;//確率70%で隊列を組む
				vx = 0;
				vy = (-getMaxSpeed() - (float)(Math.random()*3))* 0.4f;
				s = (int)(Math.random()*4)-2;
			}
			else{
				appearPattern = 0;//確率30%でランダム出現
				firstShot = false;

			}

			break;
		case 2://ロケット型
			r = (int)(Math.random()*100);
			if ( r < 70 ) {
				appearPattern = 1;//確率70%で隊列を組む
				vx = 0;
				vy = -getMaxSpeed();
			}
			else{
				appearPattern = 0;//確率30%でランダム出現
				firstShot = false;

			}

			break;
		case 3://円運動型
			r = (int)(Math.random()*100);
			if ( r < 70 ) {
				appearPattern = 1;//確率70%で隊列を組む
				//ベクトルを定める。
				double vec;
				double spd;
				vec = (double)((Math.random()*90)+225)*Math.PI/180;
				spd = (double)(maxSpeed * 0.4);
				vx = (float)(Math.cos(vec)*spd);
				vy = (float)(Math.sin(vec)*spd);
				
				s = maxSpeed;//円の半径。
				round = 1.8f; //角度の増減分。
				// 1/2の確率で逆回転
				int rnd = (int)(Math.random()*2);
				if (rnd == 0){
					round = -round;
				}
			}
			else{
				appearPattern = 0;//確率30%でランダム出現
				firstShot = false;
			}
			break;
		}
		count = 0;
	}

	////////////////////////発生させる判断/////////////////////
	public boolean Appear(int creNum){
		boolean bl = false;

		if (Main.game == 1){
			//出現させるか決める。ゲームのプレイ中に限る。
			switch (appearPattern){
			case 0://乱数で 1/30で出現
				int a = (int)(Math.random()*30);
				if (a < 1 && creNum > 0) {
					bl = true;
				}
				break;

			case 1://　列を作って出現
				count ++;
				if (count > interval){
					count = 0;
				}
				if (count == 0 && creNum > 0){
					bl = true;
				}
				break;
			case 2://狙って出現（彗星型）
				a = (int)(Math.random()*30);
				if (a < 1 && creNum > 0) {
					bl = true;
				}
				break;
			}// end switch
		}// end if
		return bl;
	}
	public int getLife() {
		return this.life;
	}
	public void decLife() {
		this.life --;
	}
	//そのグループのすべての敵がスクリーンから出ていたらtrueを返す
	public static boolean isAllScreenOut(EnemyGroup g) {
		boolean bl = true;
		for (int i=0; i<g.enemy.size(); i++){
			if (g.enemy.get(i).state != 0) {
				bl = false;
			}
		}
		return bl;
	}
	public int getMaxSpeed() {
		return maxSpeed;
	}
}
