package shooting;

/*ObjectLoader改
 * 
 * 桃缶たべたいさんのところからのコピペ。
 * jarファイルにするにあたり、linuxとwindowsでちゃんと動くことを
 * 考慮して改造。
 * ★バッファリーダーをgetResourceを使うようにした。
 * ★インプットストリームリーダに文字コード”UTF-8”を指定するようにした。
 * 
 * jarファイルでも動くようにするにあたり、
 * モデルリソースを格納するmodelsフォルダはソースフォルダと同じディレクトリに。
 * テクスチャーを格納するimagesフォルダはプロジェクト内に配置する。
 * 
 * 2015/2/18　yosimasa
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

import shooting.Model.DisplayList;
import shooting.Model.Material;
 
public class ObjectLoader {
    private static final String DEFAULT_IMAGES_DIR = "images";
 
    /**
     *  渡されたファイルパスの OBJ ファイルを読み込み、Model インスタンスとして返す
     */
    public static Model load(String filePath) throws IOException {
    	filePath = "models/" + filePath;
        Model           model = new Model(DEFAULT_IMAGES_DIR);
        DisplayList     displayList = null;
        File            file = new File(filePath);
        BufferedReader  br = null;
        String          line;
         
        //  テキストファイルなので 1 行ずつ読み込んでパースしていく
        try {
            //br = new BufferedReader(new FileReader(file));
        	br = new BufferedReader(new InputStreamReader
             		(ObjectLoader.class.getResourceAsStream(filePath),"UTF-8"));
              
            while ((line = br.readLine()) != null) {
                String[]    tokens = line.split(" ");
                 
                if ((tokens.length == 4) && (tokens[0].equals("v"))) {
                    //  頂点座標としてパースする
                    float   x = Float.valueOf(tokens[1]);
                    float   y = Float.valueOf(tokens[2]);
                    float   z = Float.valueOf(tokens[3]);
                 
                    model.addVertex(x, y ,z);
                } else if ((tokens.length == 3) && (tokens[0].equals("vt"))) {
                    //  テクスチャー座標としてパースする
                    float   x = Float.valueOf(tokens[1]);
                    float   y = Float.valueOf(tokens[2]);
 
                    model.addTextureVertex(x, y);
                } else if ((tokens.length == 4) && (tokens[0].equals("vn"))) {
                    //  法線としてパースする
                    float   x = Float.valueOf(tokens[1]);
                    float   y = Float.valueOf(tokens[2]);
                    float   z = Float.valueOf(tokens[3]);
                     
                    model.addNormal(x, y ,z);
                } else if ((tokens.length == 4) && (tokens[0].equals("f"))) {
                    //  面（頂点の集合）としてパースする
                    String[]    data1 = tokens[1].split("/");
                    String[]    data2 = tokens[2].split("/");
                    String[]    data3 = tokens[3].split("/");
 
                    int     vertex1Index = Integer.valueOf(data1[0]);
                    int     vertex2Index = Integer.valueOf(data2[0]);;
                    int     vertex3Index = Integer.valueOf(data3[0]);;
 
                    int     textureVertex1Index = intIfExists(data1[1]);
                    int     textureVertex2Index = intIfExists(data2[1]);;
                    int     textureVertex3Index = intIfExists(data3[1]);;
 
                    int     normal1Index = Integer.valueOf(data1[2]);;
                    int     normal2Index = Integer.valueOf(data2[2]);;
                    int     normal3Index = Integer.valueOf(data3[2]);;
 
                    displayList.addFace(
                            vertex1Index, vertex2Index, vertex3Index,
                            textureVertex1Index, textureVertex2Index, textureVertex3Index,
                            normal1Index, normal2Index, normal3Index);  
                  
                } else if ((tokens.length == 2) && (tokens[0].equals("mtllib"))) {
                    //  mtl ファイルからマテリアルを読み込む
                    loadMaterials(file.getParent(), tokens[1], model);
                } else if ((tokens.length == 2) && (tokens[0].equals("usemtl"))) {
                    //  面に適用するマテリアルの指定を読み込む
                    displayList.setMaterialName(tokens[1]);
                } else if ((tokens.length == 2) && (tokens[0].equals("o"))) {
                    //  オブジェクトとして読み込む
                    displayList = model.createDisplayList();
                }
            }
        } finally {
            if (br != null) {
                try {
                    br.close();
                } catch (IOException e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
            }
        }
         
        return model;
    }
     
    /**
     *  渡されたファイルパスの mtl ファイルを読み込み、Model インスタンスに追加する
     */
    private static void loadMaterials(String parentDir, String filePath, Model model) throws IOException {
        Material        material = null;
        BufferedReader  br = null;
        String          line;
         
        //  ファイルパスは、OBJ ファイルの場所を基点として扱う
        if (parentDir == null) {
            parentDir = "";
        } else if (0 < parentDir.length()) {
            parentDir = parentDir + "/";
        }
 
        //  テキストファイルなので 1 行ずつ読み込んでパースしていく
        try {
            //br = new BufferedReader(new FileReader(parentDir + filePath));
        	//System.out.println("parentDir="+parentDir);
        	//System.out.println("filePath ="+filePath);
        	br = new BufferedReader(new InputStreamReader
             		(ObjectLoader.class.getResourceAsStream(parentDir + filePath),"UTF-8"));
        	
            while ((line = br.readLine()) != null) {
                String[]    tokens = line.split(" ");
 
                if ((tokens.length == 2) && (tokens[0].equals("newmtl"))) {
                    //  マテリアル名を読み込む
                    material = model.createMaterial(tokens[1]);
                } else if ((tokens.length == 2) && (tokens[0].equals("map_Kd"))) {
                    //  テクスチャーのファイル名を読み込む
                    material.setTextureName(tokens[1]);
                }
            }
        } finally {
            if (br != null) {
                try {
                    br.close();
                } catch (IOException e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
            }
        }
    }
 
    private static int intIfExists(String value) {
        try {
            return Integer.parseInt(value);
        } catch(NumberFormatException e) {
            return -1;
        }
    }
 
}