/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc;

import com.illposed.osc.OSCPacket;
import com.illposed.osc.utility.OSCJavaToByteArrayConverter;
import java.math.BigInteger;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class OSCBundle
extends OSCPacket {
    public static final BigInteger SECONDS_FROM_1900_to_1970 = new BigInteger("2208988800");
    public static final Date TIMESTAMP_IMMEDIATE = new Date(0L);
    protected Date timestamp;
    protected Vector packets;

    public OSCBundle() {
        this(null, TIMESTAMP_IMMEDIATE);
    }

    public OSCBundle(Date date) {
        this(null, date);
    }

    public OSCBundle(OSCPacket[] oSCPacketArray) {
        this(oSCPacketArray, TIMESTAMP_IMMEDIATE);
    }

    public OSCBundle(OSCPacket[] oSCPacketArray, Date date) {
        if (null != oSCPacketArray) {
            this.packets = new Vector(oSCPacketArray.length);
            for (int i = 0; i < oSCPacketArray.length; ++i) {
                this.packets.add(oSCPacketArray[i]);
            }
        } else {
            this.packets = new Vector();
        }
        this.timestamp = date;
        this.init();
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date date) {
        this.timestamp = date;
    }

    public void addPacket(OSCPacket oSCPacket) {
        this.packets.add(oSCPacket);
    }

    public OSCPacket[] getPackets() {
        OSCPacket[] oSCPacketArray = new OSCPacket[this.packets.size()];
        this.packets.toArray(oSCPacketArray);
        return oSCPacketArray;
    }

    protected void computeTimeTagByteArray(OSCJavaToByteArrayConverter oSCJavaToByteArrayConverter) {
        if (null == this.timestamp || this.timestamp == TIMESTAMP_IMMEDIATE) {
            oSCJavaToByteArrayConverter.write(0);
            oSCJavaToByteArrayConverter.write(1);
            return;
        }
        long l = this.timestamp.getTime();
        long l2 = l / 1000L;
        long l3 = l2 + SECONDS_FROM_1900_to_1970.longValue();
        long l4 = l % 1000L * 0x100000000L / 1000L;
        oSCJavaToByteArrayConverter.write((int)l3);
        oSCJavaToByteArrayConverter.write((int)l4);
    }

    protected void computeByteArray(OSCJavaToByteArrayConverter oSCJavaToByteArrayConverter) {
        oSCJavaToByteArrayConverter.write("#bundle");
        this.computeTimeTagByteArray(oSCJavaToByteArrayConverter);
        Enumeration enumeration = this.packets.elements();
        while (enumeration.hasMoreElements()) {
            OSCPacket oSCPacket = (OSCPacket)enumeration.nextElement();
            byte[] byArray = oSCPacket.getByteArray();
            oSCJavaToByteArrayConverter.write(byArray.length);
            oSCJavaToByteArrayConverter.write(byArray);
        }
        this.byteArray = oSCJavaToByteArrayConverter.toByteArray();
    }
}

