/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc.test;

import com.illposed.osc.OSCMessage;
import com.illposed.osc.utility.OSCByteArrayToJavaConverter;
import com.illposed.osc.utility.OSCJavaToByteArrayConverter;
import java.math.BigInteger;
import junit.framework.TestCase;

public class OSCMessageTest
extends TestCase {
    public OSCMessageTest(String string) {
        super(string);
    }

    private void checkResultEqualsAnswer(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            OSCMessageTest.fail((String)("Result and answer aren't the same length " + byArray.length + " vs " + byArray2.length));
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            String string = "Didn't convert correctly: " + i;
            string = string + " result: " + byArray[i];
            string = string + " answer: " + byArray2[i];
            OSCMessageTest.fail((String)string);
        }
    }

    public void testDecreaseVolume() {
        Object[] objectArray = new Object[]{new Integer(1), new Float(0.2)};
        OSCMessage oSCMessage = new OSCMessage("/sc/mixer/volume", objectArray);
        byte[] byArray = new byte[]{47, 115, 99, 47, 109, 105, 120, 101, 114, 47, 118, 111, 108, 117, 109, 101, 0, 0, 0, 0, 44, 105, 102, 0, 0, 0, 0, 1, 62, 76, -52, -51};
        byte[] byArray2 = oSCMessage.getByteArray();
        this.checkResultEqualsAnswer(byArray2, byArray);
    }

    public void testIncreaseVolume() {
        Object[] objectArray = new Object[]{new Integer(1), new Float(1.0)};
        OSCMessage oSCMessage = new OSCMessage("/sc/mixer/volume", objectArray);
        byte[] byArray = new byte[]{47, 115, 99, 47, 109, 105, 120, 101, 114, 47, 118, 111, 108, 117, 109, 101, 0, 0, 0, 0, 44, 105, 102, 0, 0, 0, 0, 1, 63, -128, 0, 0};
        byte[] byArray2 = oSCMessage.getByteArray();
        this.checkResultEqualsAnswer(byArray2, byArray);
    }

    public void testPrintStringOnStream() {
        OSCJavaToByteArrayConverter oSCJavaToByteArrayConverter = new OSCJavaToByteArrayConverter();
        oSCJavaToByteArrayConverter.write("/example1");
        oSCJavaToByteArrayConverter.write(100);
        byte[] byArray = new byte[]{47, 101, 120, 97, 109, 112, 108, 101, 49, 0, 0, 0, 0, 0, 0, 100};
        byte[] byArray2 = oSCJavaToByteArrayConverter.toByteArray();
        this.checkResultEqualsAnswer(byArray2, byArray);
    }

    public void testRun() {
        OSCMessage oSCMessage = new OSCMessage("/sc/run", null);
        byte[] byArray = new byte[]{47, 115, 99, 47, 114, 117, 110, 0, 44, 0, 0, 0};
        byte[] byArray2 = oSCMessage.getByteArray();
        this.checkResultEqualsAnswer(byArray2, byArray);
    }

    public void testStop() {
        OSCMessage oSCMessage = new OSCMessage("/sc/stop", null);
        byte[] byArray = new byte[]{47, 115, 99, 47, 115, 116, 111, 112, 0, 0, 0, 0, 44, 0, 0, 0};
        byte[] byArray2 = oSCMessage.getByteArray();
        this.checkResultEqualsAnswer(byArray2, byArray);
    }

    public void testCreateSynth() {
        OSCMessage oSCMessage = new OSCMessage("/s_new");
        oSCMessage.addArgument(new Integer(1001));
        oSCMessage.addArgument("freq");
        oSCMessage.addArgument(new Float(440.0));
        byte[] byArray = new byte[]{47, 115, 95, 110, 101, 119, 0, 0, 44, 105, 115, 102, 0, 0, 0, 0, 0, 0, 3, -23, 102, 114, 101, 113, 0, 0, 0, 0, 67, -36, 0, 0};
        byte[] byArray2 = oSCMessage.getByteArray();
        this.checkResultEqualsAnswer(byArray2, byArray);
    }

    public void testSendBigInteger() {
        Object[] objectArray;
        OSCMessage oSCMessage = new OSCMessage("/dummy");
        BigInteger bigInteger = new BigInteger("1001");
        oSCMessage.addArgument(bigInteger);
        byte[] byArray = oSCMessage.getByteArray();
        OSCByteArrayToJavaConverter oSCByteArrayToJavaConverter = new OSCByteArrayToJavaConverter();
        OSCMessage oSCMessage2 = (OSCMessage)oSCByteArrayToJavaConverter.convert(byArray, byArray.length);
        if (!oSCMessage2.getAddress().equals("/dummy")) {
            OSCMessageTest.fail((String)"Send Big Integer did not receive the correct address");
        }
        if ((objectArray = oSCMessage2.getArguments()).length != 1) {
            OSCMessageTest.fail((String)("Send Big Integer should have 1 argument, not " + objectArray.length));
        }
        if (!(objectArray[0] instanceof BigInteger)) {
            OSCMessageTest.fail((String)("arguments[0] should be a BigInteger, not " + objectArray[0]));
        }
        if (!new BigInteger("1001").equals(objectArray[0])) {
            OSCMessageTest.fail((String)("Instead of BigInteger(1001), received " + objectArray[0]));
        }
    }

    public void testSendArray() {
        Object[] objectArray;
        OSCMessage oSCMessage = new OSCMessage("/dummy");
        Float[] floatArray = new Float[]{new Float(10.0), new Float(100.0)};
        oSCMessage.addArgument(floatArray);
        byte[] byArray = oSCMessage.getByteArray();
        OSCByteArrayToJavaConverter oSCByteArrayToJavaConverter = new OSCByteArrayToJavaConverter();
        OSCMessage oSCMessage2 = (OSCMessage)oSCByteArrayToJavaConverter.convert(byArray, byArray.length);
        if (!oSCMessage2.getAddress().equals("/dummy")) {
            OSCMessageTest.fail((String)"Send Array did not receive the correct address");
        }
        if ((objectArray = oSCMessage2.getArguments()).length != 1) {
            OSCMessageTest.fail((String)("Send Array should have 1 argument, not " + objectArray.length));
        }
        if (!(objectArray[0] instanceof Object[])) {
            OSCMessageTest.fail((String)("arguments[0] should be a Object array, not " + objectArray[0]));
        }
        for (int i = 0; i < 2; ++i) {
            Object[] objectArray2 = (Object[])objectArray[0];
            if (floatArray[i].equals(objectArray2[i])) continue;
            OSCMessageTest.fail((String)("Array element " + i + " should be " + floatArray[i] + " not " + objectArray2[i]));
        }
    }
}

