/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc.utility;

import com.illposed.osc.OSCBundle;
import com.illposed.osc.OSCListener;
import com.illposed.osc.OSCMessage;
import com.illposed.osc.OSCPacket;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class OSCPacketDispatcher {
    private Hashtable addressToClassTable = new Hashtable();

    public void addListener(String string, OSCListener oSCListener) {
        this.addressToClassTable.put(string, oSCListener);
    }

    public void dispatchPacket(OSCPacket oSCPacket) {
        if (oSCPacket instanceof OSCBundle) {
            this.dispatchBundle((OSCBundle)oSCPacket);
        } else {
            this.dispatchMessage((OSCMessage)oSCPacket);
        }
    }

    public void dispatchPacket(OSCPacket oSCPacket, Date date) {
        if (oSCPacket instanceof OSCBundle) {
            this.dispatchBundle((OSCBundle)oSCPacket);
        } else {
            this.dispatchMessage((OSCMessage)oSCPacket, date);
        }
    }

    private void dispatchBundle(OSCBundle oSCBundle) {
        Date date = oSCBundle.getTimestamp();
        OSCPacket[] oSCPacketArray = oSCBundle.getPackets();
        for (int i = 0; i < oSCPacketArray.length; ++i) {
            this.dispatchPacket(oSCPacketArray[i], date);
        }
    }

    private void dispatchMessage(OSCMessage oSCMessage) {
        this.dispatchMessage(oSCMessage, null);
    }

    private void dispatchMessage(OSCMessage oSCMessage, Date date) {
        Enumeration enumeration = this.addressToClassTable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.equals(oSCMessage.getAddress())) continue;
            OSCListener oSCListener = (OSCListener)this.addressToClassTable.get(string);
            oSCListener.acceptMessage(date, oSCMessage);
        }
    }
}

