# Set WCEVERSION and WCELDVERSION
!IF "$(OSVERSION)"=="WCE200"
WCEVERSION=200
WCELDVERSION=2.00
!ELSEIF "$(OSVERSION)"=="WCE201"
WCEVERSION=201
WCELDVERSION=2.01
!ELSEIF "$(OSVERSION)"=="WCE210"
WCEVERSION=210
WCELDVERSION=2.10
!ELSEIF "$(OSVERSION)"=="WCE211"
WCEVERSION=211
WCELDVERSION=2.11
!ELSEIF "$(OSVERSION)"=="WCE212"
WCEVERSION=212
WCELDVERSION=2.12
!ELSEIF "$(OSVERSION)"=="WCE300"
WCEVERSION=300
WCELDVERSION=3.00
!ELSE
!ERROR Unexpected OSVERSION environment variable value
!ENDIF

# Set WCEPLATFORM to PLATFORM, with spaces replaced with underscores, and uppercased
!IF "$(PLATFORM)"=="MS HPC"
WCEPLATFORM=MS_HPC
!ELSEIF "$(PLATFORM)"=="MS HPC Pro"
WCEPLATFORM=MS_HPC_PRO
!ELSEIF "$(PLATFORM)"=="ms palm size pc"
WCEPLATFORM=MS_PALM_SIZE_PC
!ELSEIF "$(PLATFORM)"=="ms pocket pc"
WCEPLATFORM=MS_POCKET_PC_2000
!ELSEIF "$(PLATFORM)"=="Pocket PC 2002"
WCEPLATFORM=MS_POCKET_PC_2002
!ENDIF

# Set WCETARGETCPU, WCETARGETCPUDEFS and WCETARGETDEFS
WCETARGETDEFS=-DWCEPLATFORM=$(WCEPLATFORM)
!IF "$(TARGETCPU)"=="X86"
WCETARGETCPU=X86
WCETARGETCPUDEFS=-Dx86 -D_X86_
WCELDFLAGS=/nodefaultlib:oldnames.lib coredll.lib corelibc.lib
!ELSEIF "$(TARGETCPU)"=="X86EM" || "$(TARGETCPU)"=="X86EMnset CFG=none"
WCETARGETCPU=X86
WCETARGETCPUDEFS=-Dx86 -D_X86_
WCETARGETDEFS=$(WCETARGETDEFS) -D_WIN32_WCE_EMULATION
!ELSEIF "$(TARGETCPU)"=="SH3"
WCETARGETCPU=$(TARGETCPU)
WCETARGETCPUDEFS=-DSH3 -D_SH3_ -DSHx
!ELSEIF "$(TARGETCPU)"=="SH4"
WCETARGETCPU=$(TARGETCPU)
WCETARGETCPUDEFS=-DSH4 -D_SH4_ -DSHx
!ELSEIF "$(TARGETCPU)"=="R4100" || "$(TARGETCPU)"=="R4111" || "$(TARGETCPU)"=="R4300"
WCETARGETCPU=$(TARGETCPU)
WCETARGETCPUDEFS=-DMIPS -D_MIPS_ -DMIPS_R4000
!ELSE
WCETARGETCPU=$(TARGETCPU)
WCETARGETCPUDEFS=-D$(TARGETCPU) -D_$(TARGETCPU)_
!ENDIF
WCETARGETDEFS=$(WCETARGETDEFS) $(WCETARGETCPUDEFS) -DUNDER_CE=$(WCEVERSION) -D_WIN32_CE=$(WCEVERSION)

# Set CPU type for link
!IF "$(WCETARGETCPU)"=="X86"
WCELDMACHINE=IX86
!ELSE
WCELDMACHINE=$(WCETARGETCPU)
!ENDIF
