/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.automata;

import java.io.InvalidClassException;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.misc.Utils;
import org.antlr.v4.runtime.atn.ATN;
import org.antlr.v4.runtime.atn.ATNSimulator;
import org.antlr.v4.runtime.atn.ATNState;
import org.antlr.v4.runtime.atn.ActionTransition;
import org.antlr.v4.runtime.atn.AtomTransition;
import org.antlr.v4.runtime.atn.BlockStartState;
import org.antlr.v4.runtime.atn.DecisionState;
import org.antlr.v4.runtime.atn.LoopEndState;
import org.antlr.v4.runtime.atn.PredicateTransition;
import org.antlr.v4.runtime.atn.RangeTransition;
import org.antlr.v4.runtime.atn.RuleStartState;
import org.antlr.v4.runtime.atn.RuleTransition;
import org.antlr.v4.runtime.atn.SetTransition;
import org.antlr.v4.runtime.atn.Transition;
import org.antlr.v4.runtime.misc.IntegerList;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.misc.IntervalSet;
import org.antlr.v4.tool.Grammar;
import org.antlr.v4.tool.Rule;

public class ATNSerializer {
    public Grammar g;
    public ATN atn;
    public List<IntervalSet> sets = new ArrayList<IntervalSet>();

    public ATNSerializer(Grammar g, ATN atn) {
        this.g = g;
        this.atn = atn;
    }

    /*
     * WARNING - void declaration
     */
    public IntegerList serialize() {
        IntegerList data = new IntegerList();
        data.add(ATNSimulator.SERIALIZED_VERSION);
        switch (this.g.getType()) {
            case 30: {
                data.add(2);
                break;
            }
            case 43: 
            case 78: {
                data.add(1);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Invalid grammar type.");
            }
        }
        data.add(this.g.getMaxTokenType());
        int nedges = 0;
        IntegerList nonGreedyStates = new IntegerList();
        data.add(this.atn.states.size());
        for (ATNState s : this.atn.states) {
            if (s == null) {
                data.add(0);
                continue;
            }
            int stateType = s.getStateType();
            if (s instanceof DecisionState && ((DecisionState)s).nonGreedy) {
                nonGreedyStates.add(s.stateNumber);
            }
            data.add(stateType);
            data.add(s.ruleIndex);
            if (s.getStateType() == 12) {
                data.add(((LoopEndState)s).loopBackState.stateNumber);
            } else if (s instanceof BlockStartState) {
                data.add(((BlockStartState)s).endState.stateNumber);
            }
            if (s.getStateType() != 7) {
                nedges += s.getNumberOfTransitions();
            }
            for (int i = 0; i < s.getNumberOfTransitions(); ++i) {
                Transition t = s.transition(i);
                int edgeType = Transition.serializationTypes.get(t.getClass());
                if (edgeType != 7 && edgeType != 8) continue;
                SetTransition st = (SetTransition)t;
                this.sets.add(st.set);
            }
        }
        data.add(nonGreedyStates.size());
        for (int i = 0; i < nonGreedyStates.size(); ++i) {
            data.add(nonGreedyStates.get(i));
        }
        int nrules = this.atn.ruleToStartState.length;
        data.add(nrules);
        for (int r = 0; r < nrules; ++r) {
            RuleStartState ruleStartState = this.atn.ruleToStartState[r];
            data.add(ruleStartState.stateNumber);
            if (!this.g.isLexer()) continue;
            data.add(this.atn.ruleToTokenType[r]);
            String string = this.g.rules.getKey(r);
            Rule rule = this.g.getRule(string);
            data.add(rule.actionIndex);
        }
        int nmodes = this.atn.modeToStartState.size();
        data.add(nmodes);
        if (nmodes > 0) {
            for (ATNState aTNState : this.atn.modeToStartState) {
                data.add(aTNState.stateNumber);
            }
        }
        int nsets = this.sets.size();
        data.add(nsets);
        for (IntervalSet set : this.sets) {
            data.add(set.getIntervals().size());
            for (Interval I : set.getIntervals()) {
                data.add(I.a);
                data.add(I.b);
            }
        }
        data.add(nedges);
        boolean bl = false;
        for (ATNState s : this.atn.states) {
            if (s == null || s.getStateType() == 7) continue;
            for (int i = 0; i < s.getNumberOfTransitions(); ++i) {
                Transition t = s.transition(i);
                if (this.atn.states.get(t.target.stateNumber) == null) {
                    throw new IllegalStateException("Cannot serialize a transition to a removed state.");
                }
                int src = s.stateNumber;
                int trg = t.target.stateNumber;
                int edgeType = Transition.serializationTypes.get(t.getClass());
                int arg1 = 0;
                int arg2 = 0;
                int arg3 = 0;
                switch (edgeType) {
                    case 3: {
                        trg = ((RuleTransition)t).followState.stateNumber;
                        arg1 = ((RuleTransition)t).target.stateNumber;
                        arg2 = ((RuleTransition)t).ruleIndex;
                        break;
                    }
                    case 4: {
                        PredicateTransition pt = (PredicateTransition)t;
                        arg1 = pt.ruleIndex;
                        arg2 = pt.predIndex;
                        arg3 = pt.isCtxDependent ? 1 : 0;
                        break;
                    }
                    case 2: {
                        arg1 = ((RangeTransition)t).from;
                        arg2 = ((RangeTransition)t).to;
                        break;
                    }
                    case 5: {
                        arg1 = ((AtomTransition)t).label;
                        break;
                    }
                    case 6: {
                        ActionTransition at = (ActionTransition)t;
                        arg1 = at.ruleIndex;
                        arg2 = at.actionIndex;
                        arg3 = at.isCtxDependent ? 1 : 0;
                        break;
                    }
                    case 7: {
                        void var7_18;
                        arg1 = var7_18++;
                        break;
                    }
                    case 8: {
                        void var7_18;
                        arg1 = var7_18++;
                        break;
                    }
                }
                data.add(src);
                data.add(trg);
                data.add(edgeType);
                data.add(arg1);
                data.add(arg2);
                data.add(arg3);
            }
        }
        int ndecisions = this.atn.decisionToState.size();
        data.add(ndecisions);
        for (DecisionState decStartState : this.atn.decisionToState) {
            data.add(decStartState.stateNumber);
        }
        for (int i = 1; i < data.size(); ++i) {
            assert (data.get(i) >= -1 && data.get(i) < 65535);
            int value = data.get(i) + 2 & 0xFFFF;
            if (value == 65535) {
                value = -1;
            }
            data.set(i, value);
        }
        return data;
    }

    public String decode(char[] data) {
        int version;
        data = (char[])data.clone();
        for (int i = 1; i < data.length; ++i) {
            data[i] = (char)(data[i] - 2);
        }
        StringBuilder buf = new StringBuilder();
        int p = 0;
        if ((version = ATNSimulator.toInt(data[p++])) != ATNSimulator.SERIALIZED_VERSION) {
            String reason = String.format("Could not deserialize ATN with version %d (expected %d).", version, ATNSimulator.SERIALIZED_VERSION);
            throw new UnsupportedOperationException(new InvalidClassException(ATN.class.getName(), reason));
        }
        int grammarType = ATNSimulator.toInt(data[p++]);
        int maxType = ATNSimulator.toInt(data[p++]);
        buf.append("max type ").append(maxType).append("\n");
        int nstates = ATNSimulator.toInt(data[p++]);
        for (int i = 1; i <= nstates; ++i) {
            int stype;
            if ((stype = ATNSimulator.toInt(data[p++])) == 0) continue;
            int ruleIndex = ATNSimulator.toInt(data[p++]);
            String arg = "";
            if (stype == 12) {
                int loopBackStateNumber = ATNSimulator.toInt(data[p++]);
                arg = " " + loopBackStateNumber;
            } else if (stype == 4 || stype == 5 || stype == 3) {
                int endStateNumber = ATNSimulator.toInt(data[p++]);
                arg = " " + endStateNumber;
            }
            buf.append(i - 1).append(":").append(ATNState.serializationNames.get(stype)).append(" ").append(ruleIndex).append(arg).append("\n");
        }
        int numNonGreedyStates = ATNSimulator.toInt(data[p++]);
        for (int i = 0; i < numNonGreedyStates; ++i) {
            int stateNumber = ATNSimulator.toInt(data[p++]);
        }
        int nrules = ATNSimulator.toInt(data[p++]);
        for (int i = 0; i < nrules; ++i) {
            int s = ATNSimulator.toInt(data[p++]);
            if (this.g.isLexer()) {
                int arg1 = ATNSimulator.toInt(data[p++]);
                int arg2 = ATNSimulator.toInt(data[p++]);
                buf.append("rule ").append(i).append(":").append(s).append(" ").append(arg1).append(",").append(arg2).append('\n');
                continue;
            }
            buf.append("rule ").append(i).append(":").append(s).append('\n');
        }
        int nmodes = ATNSimulator.toInt(data[p++]);
        for (int i = 0; i < nmodes; ++i) {
            int s = ATNSimulator.toInt(data[p++]);
            buf.append("mode ").append(i).append(":").append(s).append('\n');
        }
        int nsets = ATNSimulator.toInt(data[p++]);
        for (int i = 1; i <= nsets; ++i) {
            int nintervals = ATNSimulator.toInt(data[p++]);
            buf.append(i - 1).append(":");
            for (int j = 1; j <= nintervals; ++j) {
                if (j > 1) {
                    buf.append(", ");
                }
                buf.append(this.getTokenName(ATNSimulator.toInt(data[p]))).append("..").append(this.getTokenName(ATNSimulator.toInt(data[p + 1])));
                p += 2;
            }
            buf.append("\n");
        }
        int nedges = ATNSimulator.toInt(data[p++]);
        for (int i = 1; i <= nedges; ++i) {
            int src = ATNSimulator.toInt(data[p]);
            int trg = ATNSimulator.toInt(data[p + 1]);
            int ttype = ATNSimulator.toInt(data[p + 2]);
            int arg1 = ATNSimulator.toInt(data[p + 3]);
            int arg2 = ATNSimulator.toInt(data[p + 4]);
            int arg3 = ATNSimulator.toInt(data[p + 5]);
            buf.append(src).append("->").append(trg).append(" ").append(Transition.serializationNames.get(ttype)).append(" ").append(arg1).append(",").append(arg2).append(",").append(arg3).append("\n");
            p += 6;
        }
        int ndecisions = ATNSimulator.toInt(data[p++]);
        for (int i = 1; i <= ndecisions; ++i) {
            int s = ATNSimulator.toInt(data[p++]);
            buf.append(i - 1).append(":").append(s).append("\n");
        }
        return buf.toString();
    }

    public String getTokenName(int t) {
        if (t == -1) {
            return "EOF";
        }
        if (this.g != null) {
            return this.g.getTokenDisplayName(t);
        }
        return String.valueOf(t);
    }

    public static String getSerializedAsString(Grammar g, ATN atn) {
        return new String(ATNSerializer.getSerializedAsChars(g, atn));
    }

    public static IntegerList getSerialized(Grammar g, ATN atn) {
        return new ATNSerializer(g, atn).serialize();
    }

    public static char[] getSerializedAsChars(Grammar g, ATN atn) {
        return Utils.toCharArray(ATNSerializer.getSerialized(g, atn));
    }

    public static String getDecoded(Grammar g, ATN atn) {
        IntegerList serialized = ATNSerializer.getSerialized(g, atn);
        char[] data = Utils.toCharArray(serialized);
        return new ATNSerializer(g, atn).decode(data);
    }
}

