package jp.sourceforge.masasa.architecture.framework.validation.validator;

import java.lang.annotation.Annotation;
import java.util.StringTokenizer;

import jp.sourceforge.masasa.architecture.framework.validation.annotation.CheckUrl;
import jp.sourceforge.masasa.architecture.framework.validation.util.StringUtil;

import org.apache.commons.validator.GenericValidator;
import org.apache.commons.validator.UrlValidator;

/**
 * Checks if a field has a valid url. Four optional variables can be specified to configure url validation.
 *
 * @author masasa.
 * @see org.apache.struts.validator.FieldChecks#validateUrl(Object, org.apache.commons.validator.ValidatorAction,
 *      org.apache.commons.validator.Field, org.apache.struts.action.ActionMessages,
 *      org.apache.commons.validator.Validator, javax.servlet.http.HttpServletRequest)
 */
@SuppressWarnings("javadoc")
public class ValidateUrl implements IValidator {

    /**
     * Checks if a field has a valid url. Four optional variables can be specified to configure url validation.
     *
     * @param anno
     *            バリデーションに対応するアノテーション.
     * @param targetValue
     *            検証値.
     * @param lineObject
     *            Beanが所属するオブジェクト.
     * @return バリデーション結果.
     *         <ul>
     *         <li><code>true</code>:エラーなし.</li>
     *         <li><code>false</code>:エラーあり.</li>
     *         </ul>
     * @see jp.sourceforge.masasa.architecture.framework.validation.validator.IValidator #validate(java
     *      .lang.annotation.Annotation, java.lang.String, java.lang.Object)
     */
    @Override
    public boolean validate(final Annotation anno, final String targetValue, final Object lineObject) {
        CheckUrl resolver = (CheckUrl) anno;
        if (!resolver.verifyWhenNull() && targetValue == null) return true;
        int options = 0;
        if (resolver.allowallschemes()) options += UrlValidator.ALLOW_ALL_SCHEMES;
        if (resolver.allow2slashes()) options += UrlValidator.ALLOW_2_SLASHES;
        if (resolver.nofragments()) options += UrlValidator.NO_FRAGMENTS;
        if (options == 0 && resolver.schemes() == null) return GenericValidator.isUrl(targetValue);
        String[] schemes = null;
        if (resolver.schemes() != null) {
            StringTokenizer st = new StringTokenizer(StringUtil.concatSchemes(resolver.schemes()), ","); //$NON-NLS-1$
            schemes = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                schemes[i++] = st.nextToken().trim();
            }
        }
        return new UrlValidator(schemes, options).isValid(targetValue);
    }

}
