package jp.sourceforge.masasa.architecture.framework.db;

import java.sql.SQLException;

import com.ibatis.sqlmap.client.SqlMapClient;

public abstract class AbstractDbAccess {

	/**
	 * SqlMapClient.
	 */
	protected final SqlMapClient sqlMapClient;

	/**
	 * コンストラクタ.
	 */
	public AbstractDbAccess() {
		sqlMapClient = SqlMapConfigLoader.getSqlMapInstance();
	}

	/**
	 * トランザクションを開始します.
	 */
	public void startTransaction() {
		try {
			sqlMapClient.startTransaction();
		} catch (SQLException e) {
			e.printStackTrace();
		}
	}

	/**
	 * トランザクションをコミットします.
	 */
	public void commitTransaction() {
		try {
			sqlMapClient.commitTransaction();
		} catch (SQLException e) {
			e.printStackTrace();
		}
	}

	/**
	 * トランザクションを終了します.
	 */
	public void endTransaction() {
		try {
			sqlMapClient.endTransaction();
		} catch (SQLException e) {
			e.printStackTrace();
		}
	}

}
