/**
 *
 */
package jp.sourceforge.masasa.architecture.framework.db.read;

import java.sql.SQLException;
import java.util.List;

import jp.sourceforge.masasa.architecture.framework.db.AbstractDbAccess;
import jp.sourceforge.masasa.architecture.framework.db.MstGItemBean;

/**
 */
public class MstGItemReader extends AbstractDbAccess {

	/**
	 * MST_G_ITEMのカラム名を返却します.
	 * 
	 * @return MST_G_ITEMのカラム名.
	 * @throws SQLException
	 */
	public List<String> getColumnNames() throws SQLException {
		return sqlMapClient.queryForList("SEARCH_MST_G_ITEM_COLUMN"); //$NON-NLS-1$
	}

	/**
	 * MST_G_ITEMの検索結果を返却します.
	 * 
	 * @return MST_G_ITEMの検索結果.
	 * @throws SQLException
	 */
	public List<MstGItemBean> getBeans() throws SQLException {
		return sqlMapClient.queryForList("SEARCH_MST_G_ITEM"); //$NON-NLS-1$
	}
}
