package jp.sourceforge.masasa.architecture.framework.validation;

import java.util.ArrayList;
import java.util.List;

import jp.sourceforge.masasa.architecture.framework.validation.annotation.CheckDate;
import junit.framework.TestCase;

import org.apache.commons.validator.ValidatorException;
import org.junit.Test;

/**
 * @see org.apache.commons.validator.DateTest
 */
public class CheckDateTest extends TestCase {

	/**
	 * Tests the date validation.
	 */
	@Test
	public void testValidDate1() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new Data("2005/12/01"));
		Validator validator = new Validator();
		validator.validate(list);
		assertTrue(validator.getErrors().isEmpty());
	}

	/**
	 * Tests the date validation.
	 */
	@Test
	public void testValidDate2() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new DataVerifyWhenNull());
		Validator validator = new Validator();
		validator.validate(list);
		assertFalse(validator.getErrors().isEmpty());
	}

	/**
	 * Tests the date validation.
	 */
	@Test
	public void testInvalidDate1() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new Data("2005/12as/01"));
		Validator validator = new Validator();
		validator.validate(list);
		assertFalse(validator.getErrors().isEmpty());
	}

	/**
	 * Tests the date validation.
	 */
	@Test
	public void testInvalidDate2() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new DataVerifyWhenNull());
		Validator validator = new Validator();
		validator.validate(list);
		assertFalse(validator.getErrors().isEmpty());
	}

	public class Data implements ITestData {
		private static final long serialVersionUID = 7750313458231016510L;
		@CheckDate(datePattern = "yyyy/MM/dd")
		private String data;

		public Data() {
		}

		public Data(String data) {
			this.data = data;
		}

		public String getData() {
			return data;
		}

		public void setData(String data) {
			this.data = data;
		}
	}

	public class DataVerifyWhenNull implements ITestData {
		private static final long serialVersionUID = -6978465978724376721L;
		@CheckDate(verifyWhenNull = true, datePattern = "yyyy/MM/dd")
		private String data;

		public DataVerifyWhenNull() {
		}

		public DataVerifyWhenNull(String data) {
			this.data = data;
		}

		public String getData() {
			return data;
		}

		public void setData(String data) {
			this.data = data;
		}
	}
}
