package jp.sourceforge.masasa.architecture.framework.validation.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import jp.sourceforge.masasa.architecture.framework.validation.enumeration.CheckRulesEnum;
import jp.sourceforge.masasa.architecture.framework.validation.validator.IValidator;

import org.apache.commons.validator.UrlValidator;

/**
 * URL型チェックルール用アノテーション.
 * 
 * @author masasa.
 * @see CheckRulesEnum#UrlCheck
 */
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
@ValidateResolver(CheckRulesEnum.UrlCheck)
public @interface CheckUrl {
    /**
     * チェック対象の値がnullの場合にチェックするか否か.
     * <ul>
     * <li><code>true</code>:チェックする.</li>
     * <li><code>false</code>:チェックしない.バリデータ(
     * {@link IValidator#validate(java.lang.annotation.Annotation, String, Object)} )はエラーなし(<code>true</code>)を返却する.</li>
     * </ul>
     */
    boolean verifyWhenNull() default false;

    /**
     * Allows all validly formatted schemes to pass validation instead of supplying a set of valid schemes.
     * 
     * @see UrlValidator#ALLOW_ALL_SCHEMES
     */
    boolean allowallschemes();

    /**
     * Allow two slashes in the path component of the URL.
     * 
     * @see UrlValidator#ALLOW_2_SLASHES
     */
    boolean allow2slashes();

    /**
     * Enabling this options disallows any URL fragments.
     * 
     * @see UrlValidator#NO_FRAGMENTS
     */
    boolean nofragments();

    /**
     * Pass in one or more url schemes to consider valid, passing in a null will default to "http,https,ftp" being
     * valid. If a non-null schemes is specified then all valid schemes must be specified. Setting the ALLOW_ALL_SCHEMES
     * option will ignore the contents of schemes.
     * 
     * @see UrlValidator#defaultSchemes
     */
    String[] schemes();
}
