/**
 *
 */
package jp.sourceforge.masasa.architecture.framework;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.StringUtils;

/**
 * 文字列操作に関するユーティリティクラス. <br>
 * その他のユーティリティも包含しているので、ちゃんと使う場合はクラス分けすること！
 *
 * @author masasa.
 */
public class StringUtil {

	/**
	 * Stringリスト(<code>List<String></code>)をString配列リスト(
	 * <code>List<String[]></code>)に変換して返却します.
	 *
	 * @param list
	 *            Stringリスト(<code>List<String></code>).
	 * @return <code>List<String[]></code>.
	 */
	public static List<String[]> getArrayFromStringList(List<String> list) {
		List<String[]> rv = new ArrayList<String[]>();
		rv.add(list.toArray(new String[list.size()]));
		return rv;
	}

	/**
	 * Objectリスト(<code>List<Object></code>)をString配列リスト(
	 * <code>List<String[]></code>)に変換して返却します.
	 *
	 * @param list
	 *            Objectリスト(<code>List<Object></code>)
	 * @return <code>List<String[]></code>.
	 */
	public static List<String[]> getArrayFromBeanList(List list) {
		List<String[]> rv = new ArrayList<String[]>();
		List<String> child;
		for (Object object : list) {
			child = new ArrayList<String>();
			for (Field field : object.getClass().getDeclaredFields()) {
				if ("serialVersionUID".equals(field.getName())) {
					continue;
				}
				child.add(MethodAccessUtil.doInvoke(object, field));
			}
			rv.add(child.toArray(new String[child.size()]));
		}
		return rv;
	}

	/**
	 * String配列リスト(List<String[]>)を指定された型( <code>Class<T></code>)のリストに変換して返却します.<br>
	 * 例外をCatchしているが、本来は呼び出し元でCatchすべき。ここでは、簡易版のためここでやっている.
	 *
	 * @param <T> 指定型.
	 * @param clz 対象クラス.
	 * @param list 変換元.
	 * @return リスト.
	 */
	public static <T> List<T> getList(Class<T> clz, List<String[]> list) {
		Object object;
		List rv = new ArrayList();
		try {
			Field[] fields;
			String[] strings;
			Method method;
			String[] split;
			for (int i = 0; i < list.size(); i++) {
				object = clz.newInstance();
				fields = clz.getDeclaredFields();
				strings = list.get(i);
				for (int j = 0; j < fields.length; j++) {
					if ("serialVersionUID".equals(fields[j].getName())) {
						continue;
					}
					Class[] paramTypes = { Class.forName(fields[j].getType().getName()) };
					method = clz.getMethod("set" + StringUtils.capitalize(fields[j].getName()), paramTypes);
					if ("java.lang.String".equals(paramTypes[0].getName())) {
						method.invoke(object, new String[] { strings[j - 1] });
					} else if ("java.sql.Date".equals(paramTypes[0].getName())) {
						split = null;
						if (strings[j - 1].contains("/")) {
							split = strings[j - 1].split("/");
						} else if (strings[j - 1].contains("-")) {
							split = strings[j - 1].split("-");
						}
						if (split == null) {
							method.invoke(object, new Date[] { null });
						} else {
							method.invoke(object,
									new Date[] { new Date(Integer.parseInt(split[0]), Integer.parseInt(split[1]),
											Integer.parseInt(split[2])) });
						}
					}
				}
				rv.add(object);
			}
		} catch (InstantiationException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			e.printStackTrace();
		} catch (SecurityException e) {
			e.printStackTrace();
		} catch (NoSuchMethodException e) {
			e.printStackTrace();
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
		}
		return rv;
	}
}
