/**
 *
 */
package jp.sourceforge.masasa.architecture.framework.csv.read;

import java.io.Serializable;

import jp.sourceforge.masasa.architecture.framework.validation.annotation.CheckByte;
import jp.sourceforge.masasa.architecture.framework.validation.annotation.CheckCreditCard;
import jp.sourceforge.masasa.architecture.framework.validation.annotation.CheckDate;
import jp.sourceforge.masasa.architecture.framework.validation.annotation.CheckDouble;
import jp.sourceforge.masasa.architecture.framework.validation.annotation.CheckDoubleRange;
import jp.sourceforge.masasa.architecture.framework.validation.annotation.CheckEmail;
import jp.sourceforge.masasa.architecture.framework.validation.annotation.CheckFloat;
import jp.sourceforge.masasa.architecture.framework.validation.annotation.CheckFloatRange;
import jp.sourceforge.masasa.architecture.framework.validation.annotation.CheckIntRange;
import jp.sourceforge.masasa.architecture.framework.validation.annotation.CheckInteger;
import jp.sourceforge.masasa.architecture.framework.validation.annotation.CheckLong;
import jp.sourceforge.masasa.architecture.framework.validation.annotation.CheckMask;
import jp.sourceforge.masasa.architecture.framework.validation.annotation.CheckMaxLength;
import jp.sourceforge.masasa.architecture.framework.validation.annotation.CheckMinLength;
import jp.sourceforge.masasa.architecture.framework.validation.annotation.CheckRequired;
import jp.sourceforge.masasa.architecture.framework.validation.annotation.CheckRequiredIf;
import jp.sourceforge.masasa.architecture.framework.validation.annotation.CheckShort;
import jp.sourceforge.masasa.architecture.framework.validation.annotation.CheckUrl;
import jp.sourceforge.masasa.architecture.framework.validation.enumeration.FieldTestEnum;

/**
 */
public class ReadDTO implements Serializable {
	private static final long serialVersionUID = -6436638628253525926L;
	@CheckByte
	private String validateByte;
	@CheckCreditCard
	private String validateCreditCard;
	@CheckDate(datePattern = "yyyy/MM/dd", datePatternStrict = "yyyy/MM/dd")
	private String validateDate;
	@CheckDouble
	private String validateDouble;
	@CheckDoubleRange(min = 10.0, max = 100.0)
	private String validateDoubleRange;
	@CheckEmail
	private String validateEmail;
	@CheckFloat
	private String validateFloat;
	@CheckFloatRange(min = 10, max = 100)
	private String validateFloatRange;
	@CheckInteger
	private String validateInteger;
	@CheckIntRange(min = 10, max = 100)
	private String validateIntRange;
	@CheckLong
	private String validateLong;
	@CheckMask(mask = "^([0-9]|[a-z]|[A-Z])*$")
	private String validateMask;
	@CheckMaxLength(maxlength = 10)
	private String validateMaxLength;
	@CheckMinLength(minlength = 10)
	private String validateMinLength;
	@CheckRequired
	private String validateRequired;
	@CheckRequiredIf(field = { "validateRequired" }, fieldTest = { FieldTestEnum.FIELD_TEST_EQUAL }, fieldValue = { "10" })
	private String validateRequiredIf;
	@CheckShort
	private String validateShort;
	@CheckUrl(allowallschemes = false, allow2slashes = true, nofragments = false, schemes = { "http", "ftp" })
	private String validateUrl;

	// @CheckValidWhen(test="")
	// private String validateValidWhen;
	public String getValidateByte() {
		return validateByte;
	}

	public void setValidateByte(String validateByte) {
		this.validateByte = validateByte;
	}

	public String getValidateCreditCard() {
		return validateCreditCard;
	}

	public void setValidateCreditCard(String validateCreditCard) {
		this.validateCreditCard = validateCreditCard;
	}

	public String getValidateDate() {
		return validateDate;
	}

	public void setValidateDate(String validateDate) {
		this.validateDate = validateDate;
	}

	public String getValidateDouble() {
		return validateDouble;
	}

	public void setValidateDouble(String validateDouble) {
		this.validateDouble = validateDouble;
	}

	public String getValidateDoubleRange() {
		return validateDoubleRange;
	}

	public void setValidateDoubleRange(String validateDoubleRange) {
		this.validateDoubleRange = validateDoubleRange;
	}

	public String getValidateEmail() {
		return validateEmail;
	}

	public void setValidateEmail(String validateEmail) {
		this.validateEmail = validateEmail;
	}

	public String getValidateFloat() {
		return validateFloat;
	}

	public void setValidateFloat(String validateFloat) {
		this.validateFloat = validateFloat;
	}

	public String getValidateFloatRange() {
		return validateFloatRange;
	}

	public void setValidateFloatRange(String validateFloatRange) {
		this.validateFloatRange = validateFloatRange;
	}

	public String getValidateInteger() {
		return validateInteger;
	}

	public void setValidateInteger(String validateInteger) {
		this.validateInteger = validateInteger;
	}

	public String getValidateIntRange() {
		return validateIntRange;
	}

	public void setValidateIntRange(String validateIntRange) {
		this.validateIntRange = validateIntRange;
	}

	public String getValidateLong() {
		return validateLong;
	}

	public void setValidateLong(String validateLong) {
		this.validateLong = validateLong;
	}

	public String getValidateMask() {
		return validateMask;
	}

	public void setValidateMask(String validateMask) {
		this.validateMask = validateMask;
	}

	public String getValidateMaxLength() {
		return validateMaxLength;
	}

	public void setValidateMaxLength(String validateMaxLength) {
		this.validateMaxLength = validateMaxLength;
	}

	public String getValidateMinLength() {
		return validateMinLength;
	}

	public void setValidateMinLength(String validateMinLength) {
		this.validateMinLength = validateMinLength;
	}

	public String getValidateRequired() {
		return validateRequired;
	}

	public void setValidateRequired(String validateRequired) {
		this.validateRequired = validateRequired;
	}

	public String getValidateRequiredIf() {
		return validateRequiredIf;
	}

	public void setValidateRequiredIf(String validateRequiredIf) {
		this.validateRequiredIf = validateRequiredIf;
	}

	public String getValidateShort() {
		return validateShort;
	}

	public void setValidateShort(String validateShort) {
		this.validateShort = validateShort;
	}

	public String getValidateUrl() {
		return validateUrl;
	}

	public void setValidateUrl(String validateUrl) {
		this.validateUrl = validateUrl;
	}

}
