package jp.sourceforge.masasa.architecture.framework.csv.write;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.SQLException;

import jp.sourceforge.masasa.architecture.framework.Constants;
import jp.sourceforge.masasa.architecture.framework.StringUtil;
import jp.sourceforge.masasa.architecture.framework.db.read.MstGItemReader;
import au.com.bytecode.opencsv.CSVWriter;

public class SampleCSVWriter {

	/**
	 * @param args
	 * @throws IOException
	 * @throws SQLException
	 * @throws IOException
	 * @throws SQLException
	 */
	public static void main(String[] args) throws IOException, SQLException {
		// ストリームのインスタンスを生成する
		OutputStream outputStream = new FileOutputStream(Constants.FILE_NAME);
		// ストリームのライターインスタンスを生成する
		OutputStreamWriter streamWriter = new OutputStreamWriter(outputStream, Constants.DEFAULT_CHARSET);
		// CSVライターインスタンスを生成する
		CSVWriter writer = new CSVWriter(streamWriter, CSVWriter.DEFAULT_SEPARATOR, CSVWriter.DEFAULT_QUOTE_CHARACTER);
		MstGItemReader reader = new MstGItemReader();
		try {
			/*
			 * 取得なので本来トランザクション管理は不要
			 */
			// トランザクション開始
			reader.startTransaction();
			writer.writeAll(StringUtil.getArrayFromStringList(reader.getColumnNames()));
			writer.writeAll(StringUtil.getArrayFromBeanList(reader.getBeans()));
		} finally {
			// トランザクションを終了
			// コミットがコールされていない場合、自動的にロールバックを行い
			// トランザクションを終了させる。コミットがコールされている場合は
			// そのままトランザクションを終了させる。
			reader.endTransaction();
		}
		writer.flush();
		writer.close();

	}
}
