package jp.sourceforge.masasa.architecture.framework.db;

import java.io.Serializable;
import java.sql.Date;

import jp.sourceforge.masasa.architecture.framework.validation.annotation.CheckDate;
import jp.sourceforge.masasa.architecture.framework.validation.annotation.CheckMask;
import jp.sourceforge.masasa.architecture.framework.validation.annotation.CheckMaxLength;
import jp.sourceforge.masasa.architecture.framework.validation.annotation.CheckRequired;

/**
 */
public class MstGItemBean implements Serializable {
	private static final long serialVersionUID = 3013224000879309848L;
	@CheckRequired
	// 必須
	@CheckMaxLength(maxlength = 20)
	// 最大20文字
	@CheckMask(mask = "^([0-9]|[a-z]|[A-Z])*$")
	// 半角英数字のみ
	private String cdItem;
	@CheckMaxLength(maxlength = 8)
	// 最大8文字
	private String dtsStart;
	@CheckMaxLength(maxlength = 8)
	// 最大8文字
	private String dtsEnd;
	@CheckMaxLength(maxlength = 60)
	// 最大60文字
	private String nmItem;
	@CheckMaxLength(maxlength = 30)
	// 最大30文字
	private String nmItemShort;
	@CheckMaxLength(maxlength = 10)
	// 最大10文字
	private String cdCategory;
	@CheckMaxLength(maxlength = 30)
	// 最大30文字
	private String segSpecification;
	@CheckMaxLength(maxlength = 14)
	// 最大14文字
	private String cdJan;
	@CheckMaxLength(maxlength = 5)
	// 最大5文字
	private String untUnit;
	@CheckMaxLength(maxlength = 240)
	// 最大240文字
	private String txtNote;
	@CheckMaxLength(maxlength = 20)
	// 最大20文字
	private String idCrtUsr;
	@CheckDate(datePattern = "yyyy-MM-dd")
	// 日付型
	private Date dttCrtDat;
	@CheckMaxLength(maxlength = 20)
	// 最大20文字
	private String idUpdUsr;
	@CheckDate(datePattern = "yyyy-MM-dd")
	// 日付型
	private Date dttUpdDat;
	@CheckMaxLength(maxlength = 1)
	// 最大1文字
	private String flgDelete;
	@CheckMaxLength(maxlength = 10)
	// 最大10文字
	private String cdManagementOrganization;
	@CheckMaxLength(maxlength = 20)
	// 最大20文字
	private String cdGItemPartNumber;
	@CheckMaxLength(maxlength = 10)
	// 最大10文字
	private String cdGItemColor;
	@CheckMaxLength(maxlength = 10)
	// 最大10文字
	private String cdGItemRevision;
	@CheckMaxLength(maxlength = 40)
	// 最大40文字
	private String noProgram;
	@CheckMaxLength(maxlength = 5)
	// 最大5文字
	private String segConsumptionTax;

	public String getCdCategory() {
		return cdCategory;
	}

	public void setCdCategory(String cdCategory) {
		this.cdCategory = cdCategory;
	}

	public String getCdGItemColor() {
		return cdGItemColor;
	}

	public void setCdGItemColor(String cdGItemColor) {
		this.cdGItemColor = cdGItemColor;
	}

	public String getCdGItemPartNumber() {
		return cdGItemPartNumber;
	}

	public void setCdGItemPartNumber(String cdGItemPartNumber) {
		this.cdGItemPartNumber = cdGItemPartNumber;
	}

	public String getCdGItemRevision() {
		return cdGItemRevision;
	}

	public void setCdGItemRevision(String cdGItemRevision) {
		this.cdGItemRevision = cdGItemRevision;
	}

	public String getCdItem() {
		return cdItem;
	}

	public void setCdItem(String cdItem) {
		this.cdItem = cdItem;
	}

	public String getCdJan() {
		return cdJan;
	}

	public void setCdJan(String cdJan) {
		this.cdJan = cdJan;
	}

	public String getCdManagementOrganization() {
		return cdManagementOrganization;
	}

	public void setCdManagementOrganization(String cdManagementOrganization) {
		this.cdManagementOrganization = cdManagementOrganization;
	}

	public String getDtsEnd() {
		return dtsEnd;
	}

	public void setDtsEnd(String dtsEnd) {
		this.dtsEnd = dtsEnd;
	}

	public String getDtsStart() {
		return dtsStart;
	}

	public void setDtsStart(String dtsStart) {
		this.dtsStart = dtsStart;
	}

	public Date getDttCrtDat() {
		return dttCrtDat;
	}

	public void setDttCrtDat(Date dttCrtDat) {
		this.dttCrtDat = dttCrtDat;
	}

	public Date getDttUpdDat() {
		return dttUpdDat;
	}

	public void setDttUpdDat(Date dttUpdDat) {
		this.dttUpdDat = dttUpdDat;
	}

	public String getFlgDelete() {
		return flgDelete;
	}

	public void setFlgDelete(String flgDelete) {
		this.flgDelete = flgDelete;
	}

	public String getIdCrtUsr() {
		return idCrtUsr;
	}

	public void setIdCrtUsr(String idCrtUsr) {
		this.idCrtUsr = idCrtUsr;
	}

	public String getIdUpdUsr() {
		return idUpdUsr;
	}

	public void setIdUpdUsr(String idUpdUsr) {
		this.idUpdUsr = idUpdUsr;
	}

	public String getNmItem() {
		return nmItem;
	}

	public void setNmItem(String nmItem) {
		this.nmItem = nmItem;
	}

	public String getNmItemShort() {
		return nmItemShort;
	}

	public void setNmItemShort(String nmItemShort) {
		this.nmItemShort = nmItemShort;
	}

	public String getNoProgram() {
		return noProgram;
	}

	public void setNoProgram(String noProgram) {
		this.noProgram = noProgram;
	}

	public String getSegConsumptionTax() {
		return segConsumptionTax;
	}

	public void setSegConsumptionTax(String segConsumptionTax) {
		this.segConsumptionTax = segConsumptionTax;
	}

	public String getSegSpecification() {
		return segSpecification;
	}

	public void setSegSpecification(String segSpecification) {
		this.segSpecification = segSpecification;
	}

	public String getTxtNote() {
		return txtNote;
	}

	public void setTxtNote(String txtNote) {
		this.txtNote = txtNote;
	}

	public String getUntUnit() {
		return untUnit;
	}

	public void setUntUnit(String untUnit) {
		this.untUnit = untUnit;
	}

}