package jp.sourceforge.masasa.architecture.framework.validation;

import java.util.ArrayList;
import java.util.List;

import jp.sourceforge.masasa.architecture.framework.validation.annotation.CheckInteger;
import junit.framework.TestCase;

import org.apache.commons.validator.ValidatorException;
import org.junit.Test;

/**
 * @see org.apache.commons.validator.IntegerTest
 */
public class CheckIntegerTest extends TestCase {

	/**
	 * Tests the integer validation.
	 */
	@Test
	public void testInteger1() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new Data("0"));
		Validator validator = new Validator();
		validator.validate(list);
		assertTrue(validator.getErrors().isEmpty());
	}

	/**
	 * Tests the integer validation.
	 */
	@Test
	public void testInteger2() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new DataVerifyWhenNull("0"));
		Validator validator = new Validator();
		validator.validate(list);
		assertTrue(validator.getErrors().isEmpty());
	}

	/**
	 * Tests the integer validation.
	 */
	@Test
	public void testIntegerMin1() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new Data(new Integer(Integer.MIN_VALUE).toString()));
		Validator validator = new Validator();
		validator.validate(list);
		assertTrue(validator.getErrors().isEmpty());
	}

	/**
	 * Tests the integer validation.
	 */
	@Test
	public void testIntegerMin2() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new DataVerifyWhenNull(new Integer(Integer.MIN_VALUE).toString()));
		Validator validator = new Validator();
		validator.validate(list);
		assertTrue(validator.getErrors().isEmpty());
	}

	/**
	 * Tests the integer validation.
	 */
	@Test
	public void testIntegerMax1() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new Data(new Integer(Integer.MAX_VALUE).toString()));
		Validator validator = new Validator();
		validator.validate(list);
		assertTrue(validator.getErrors().isEmpty());
	}

	/**
	 * Tests the integer validation.
	 */
	@Test
	public void testIntegerMax2() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new DataVerifyWhenNull(new Integer(Integer.MAX_VALUE).toString()));
		Validator validator = new Validator();
		validator.validate(list);
		assertTrue(validator.getErrors().isEmpty());
	}

	/**
	 * Tests the integer validation failure.
	 */
	@Test
	public void testIntegerFailure1() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new Data());
		Validator validator = new Validator();
		validator.validate(list);
		assertTrue(validator.getErrors().isEmpty());
	}

	/**
	 * Tests the integer validation failure.
	 */
	@Test
	public void testIntegerFailure2() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new DataVerifyWhenNull());
		Validator validator = new Validator();
		validator.validate(list);
		assertFalse(validator.getErrors().isEmpty());
	}

	/**
	 * Tests the int validation failure.
	 */
	@Test
	public void testIntBeyondMin1() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new Data(Integer.MIN_VALUE + "1"));
		Validator validator = new Validator();
		validator.validate(list);
		assertFalse(validator.getErrors().isEmpty());
	}

	/**
	 * Tests the int validation failure.
	 */
	@Test
	public void testIntBeyondMin2() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new DataVerifyWhenNull(Integer.MIN_VALUE + "1"));
		Validator validator = new Validator();
		validator.validate(list);
		assertFalse(validator.getErrors().isEmpty());
	}

	/**
	 * Tests the int validation failure.
	 */
	public void testIntBeyondMax1() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new Data(Integer.MAX_VALUE + "1"));
		Validator validator = new Validator();
		validator.validate(list);
		assertFalse(validator.getErrors().isEmpty());
	}

	/**
	 * Tests the int validation failure.
	 */
	public void testIntBeyondMax2() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new DataVerifyWhenNull(Integer.MAX_VALUE + "1"));
		Validator validator = new Validator();
		validator.validate(list);
		assertFalse(validator.getErrors().isEmpty());
	}

	public class  Data implements ITestData {
		private static final long serialVersionUID = 1282969251009230946L;
		@CheckInteger
		private String data;

		public Data() {
		}

		public Data(String data) {
			this.data = data;
		}

		public String getData() {
			return data;
		}

		public void setData(String data) {
			this.data = data;
		}
	}

	public class  DataVerifyWhenNull implements ITestData {
		private static final long serialVersionUID = -5038621233264842879L;
		@CheckInteger(verifyWhenNull = true)
		private String data;

		public DataVerifyWhenNull() {
		}

		public DataVerifyWhenNull(String data) {
			this.data = data;
		}

		public String getData() {
			return data;
		}

		public void setData(String data) {
			this.data = data;
		}
	}
}
