package jp.sourceforge.masasa.architecture.framework.validation;

import java.util.ArrayList;
import java.util.List;

import jp.sourceforge.masasa.architecture.framework.validation.annotation.CheckLong;
import junit.framework.TestCase;

import org.apache.commons.validator.ValidatorException;
import org.junit.Test;

/**
 * @see org.apache.commons.validator.LongTest
 */
public class CheckLongTest extends TestCase {

	/**
	 * Tests the long validation.
	 */
	@Test
	public void testLong1() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new Data("0"));
		Validator validator = new Validator();
		validator.validate(list);
		assertTrue(validator.getErrors().isEmpty());
	}

	/**
	 * Tests the long validation.
	 */
	@Test
	public void testLong2() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new DataVerifyWhenNull("0"));
		Validator validator = new Validator();
		validator.validate(list);
		assertTrue(validator.getErrors().isEmpty());
	}

	/**
	 * Tests the long validation.
	 */
	@Test
	public void testLongMin1() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new Data(new Long(Long.MIN_VALUE).toString()));
		Validator validator = new Validator();
		validator.validate(list);
		assertTrue(validator.getErrors().isEmpty());
	}

	/**
	 * Tests the long validation.
	 */
	@Test
	public void testLongMin2() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new DataVerifyWhenNull(new Long(Long.MIN_VALUE).toString()));
		Validator validator = new Validator();
		validator.validate(list);
		assertTrue(validator.getErrors().isEmpty());
	}

	/**
	 * Tests the long validation.
	 */
	@Test
	public void testLongMax1() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new Data(new Long(Long.MAX_VALUE).toString()));
		Validator validator = new Validator();
		validator.validate(list);
		assertTrue(validator.getErrors().isEmpty());
	}

	/**
	 * Tests the long validation.
	 */
	@Test
	public void testLongMax2() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new DataVerifyWhenNull(new Long(Long.MAX_VALUE).toString()));
		Validator validator = new Validator();
		validator.validate(list);
		assertTrue(validator.getErrors().isEmpty());
	}

	/**
	 * Tests the long validation failure.
	 */
	@Test
	public void testLongFailure1() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new Data());
		Validator validator = new Validator();
		validator.validate(list);
		assertTrue(validator.getErrors().isEmpty());
	}

	/**
	 * Tests the long validation failure.
	 */
	@Test
	public void testLongFailure2() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new DataVerifyWhenNull());
		Validator validator = new Validator();
		validator.validate(list);
		assertFalse(validator.getErrors().isEmpty());
	}

	/**
	 * Tests the long validation failure.
	 */
	@Test
	public void testLongBeyondMin1() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new Data(Long.MIN_VALUE + "1"));
		Validator validator = new Validator();
		validator.validate(list);
		assertFalse(validator.getErrors().isEmpty());
	}

	/**
	 * Tests the long validation failure.
	 */
	@Test
	public void testLongBeyondMin2() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new DataVerifyWhenNull(Long.MIN_VALUE + "1"));
		Validator validator = new Validator();
		validator.validate(list);
		assertFalse(validator.getErrors().isEmpty());
	}

	/**
	 * Tests the long validation failure.
	 */
	public void testLongBeyondMax1() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new Data(Long.MAX_VALUE + "1"));
		Validator validator = new Validator();
		validator.validate(list);
		assertFalse(validator.getErrors().isEmpty());
	}

	/**
	 * Tests the long validation failure.
	 */
	public void testLongBeyondMax2() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new DataVerifyWhenNull(Long.MAX_VALUE + "1"));
		Validator validator = new Validator();
		validator.validate(list);
		assertFalse(validator.getErrors().isEmpty());
	}

	public class  Data implements ITestData {
		private static final long serialVersionUID = 1282969251009230946L;
		@CheckLong
		private String data;

		public Data() {
		}

		public Data(String data) {
			this.data = data;
		}

		public String getData() {
			return data;
		}

		public void setData(String data) {
			this.data = data;
		}
	}

	public class  DataVerifyWhenNull implements ITestData {
		private static final long serialVersionUID = -5038621233264842879L;
		@CheckLong(verifyWhenNull = true)
		private String data;

		public DataVerifyWhenNull() {
		}

		public DataVerifyWhenNull(String data) {
			this.data = data;
		}

		public String getData() {
			return data;
		}

		public void setData(String data) {
			this.data = data;
		}
	}
}
