package jp.sourceforge.masasa.architecture.framework.validation.enumeration;

/**
 * {@link org.apache.struts.validator.FieldChecks} に定義されているRequiredIf用の条件式を定義します.
 */
@SuppressWarnings("javadoc")
public enum FieldTestEnum {
    /**
     * {@link org.apache.struts.validator.FieldChecks#FIELD_TEST_NULL}.
     * 
     * @see org.apache.struts.validator.FieldChecks#FIELD_TEST_NULL
     */
    FIELD_TEST_NULL("NULL"), //$NON-NLS-1$
    /**
     * {@link org.apache.struts.validator.FieldChecks#FIELD_TEST_NOTNULL}.
     * 
     * @see org.apache.struts.validator.FieldChecks#FIELD_TEST_NOTNULL
     */
    FIELD_TEST_NOTNULL("NOTNULL"), //$NON-NLS-1$
    /**
     * {@link org.apache.struts.validator.FieldChecks#FIELD_TEST_EQUAL}.
     * 
     * @see org.apache.struts.validator.FieldChecks#FIELD_TEST_EQUAL
     */
    FIELD_TEST_EQUAL("EQUAL"); //$NON-NLS-1$

    /**
     * {@link org.apache.struts.validator.FieldChecks} に定義されているRequiredIf用の条件式.
     */
    private String value;

    /**
     * コンストラクタ.
     * 
     * @param value
     *            {@link org.apache.struts.validator.FieldChecks} に定義されているRequiredIf用の条件式.
     */
    @SuppressWarnings("hiding")
    private FieldTestEnum(final String value) {
        this.value = value;
    }

    /**
     * {@link org.apache.struts.validator.FieldChecks} に定義されているRequiredIf用の条件式を返却します.
     * 
     * @return {@link org.apache.struts.validator.FieldChecks} に定義されているRequiredIf用の条件式.
     */
    public String getValue() {
        return this.value;
    }
}
