package jp.sourceforge.masasa.architecture.framework.validation;

/**
 * 入力チェック結果を保持するクラス.
 *
 * @author masasa.
 */
public class ValidateResult {
    /** 行番号. */
    private final int line;
    /** フィールド名. */
    private final String fieldName;
    /** フィールド値. */
    private final String targetValue;
    /** チェックルール. */
    private final String checkRule;
    /** 入力チェック結果. */
    private final boolean valid;

    /**
     * @param line
     *            行番号.
     * @param fieldName
     *            フィールド名.
     * @param targetValue
     *            フィールド値.
     * @param checkRule
     *            チェックルール.
     * @param valid
     *            入力チェック結果.
     */
    @SuppressWarnings("hiding")
    public ValidateResult(final int line, final String fieldName, final String targetValue, final String checkRule,
            final boolean valid) {
        this.line = line;
        this.fieldName = fieldName;
        this.targetValue = targetValue;
        this.checkRule = checkRule;
        this.valid = valid;
    }

    /**
     * 行番号を返却します.
     *
     * @return 行番号.
     */
    public int getLine() {
        return this.line;
    }

    /**
     * フィールド名を返却します.
     *
     * @return フィールド名.
     */
    public String getFieldName() {
        return this.fieldName;
    }

    /**
     * フィールド値を返却します.
     *
     * @return フィールド値.
     */
    public String getTargetValue() {
        return this.targetValue;
    }

    /**
     * チェックルールを返却します.
     *
     * @return チェックルール.
     */
    public String getCheckRule() {
        return this.checkRule;
    }

    /**
     * 入力チェック結果を返却します.
     *
     * @return 入力チェック結果.
     */
    public boolean isValid() {
        return this.valid;
    }

}
