package jp.sourceforge.masasa.architecture.framework.validation.util;

/**
 * 文字列操作に関するユーティリティクラス.
 * 
 * @author masasa.
 */
public final class StringUtil {

    /**
     * コンストラクタ. <br>
     * インスタンス生成不可.
     */
    private StringUtil() {
        // do nothing
    }

    /**
     * 文字列が空か否かを検証します.
     * 
     * @param str
     *            対象文字列.
     * @return 検証結果.
     *         <ul>
     *         <li><code>true</code>:空.</li>
     *         <li><code>false</code>:上記以外.</li>
     *         </ul>
     */
    public static boolean isEmpty(final String str) {
        return str == null || str.length() == 0;
    }

    /**
     * 文字列が空か否かを検証します.
     * 
     * @param str
     *            対象文字列.
     * @return 検証結果.
     *         <ul>
     *         <li><code>true</code>:空以外.</li>
     *         <li><code>false</code>:上記以外.</li>
     *         </ul>
     */
    public static boolean isNotEmpty(final String str) {
        return !isEmpty(str);
    }

    /**
     * 最大桁数で0詰めします.
     * 
     * @param val
     *            対象値.
     * @param maxLength
     *            表示桁数.
     * @return 0詰めした文字列.
     */
    public static String paddingZero(final int val, final int maxLength) {
        return String.format("%0" + maxLength //$NON-NLS-1$
                + "d", Integer.valueOf(val)); //$NON-NLS-1$
    }

    /**
     * スキーマ文字列を連結します.
     * 
     * @param schemes
     *            スキーマ配列.
     * @return スキーマ配列を","で連結した文字列.
     */
    public static String concatSchemes(final String[] schemes) {
        StringBuilder buf = new StringBuilder();
        for (String scheme : schemes) {
            buf.append(scheme);
            buf.append(","); //$NON-NLS-1$
        }
        String rv = buf.toString();
        if (rv.endsWith(",")) { //$NON-NLS-1$
            return rv.substring(0, rv.length() - 1);
        }
        return rv;
    }

}
