"""
System Name: Vasyworks
Project Name: vacancy
Encoding: UTF-8
Copyright (C) 2020 Yasuhiro Yamamoto
"""
from django.conf import settings
from django import forms
from django.contrib.auth.forms import AuthenticationForm
from django.contrib.auth import authenticate
from django.utils.translation import gettext, gettext_lazy as _


class LoginForm(AuthenticationForm):
    error_messages = {
        'invalid_login': 'ログインに失敗しました。会社コード、ユーザID、パスワードをご確認ください。',
        'inactive': 'ログインに失敗しました。ユーザが有効ではありません。',
    }

    def __init__(self, request=None, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self.field_order = ['username', 'password']

        self.fields["username"].widget.attrs['placeholder'] = 'ユーザID'
        self.fields["password"].widget.attrs['placeholder'] = 'パスワード'
        for field in self.fields.values():
            field.widget.attrs['class'] = 'form-control'

    def clean(self):
        username = self.cleaned_data.get('username')
        password = self.cleaned_data.get('password')

        if username is not None and password:
            self.user_cache = authenticate(
                self.request,
                username=username,
                password=password,
            )
            if self.user_cache is None:
                raise self.get_invalid_login_error()
            else:
                self.confirm_login_allowed(self.user_cache)

        return self.cleaned_data

    def get_invalid_login_error(self):
        return forms.ValidationError(
            self.error_messages['invalid_login'],
            code='invalid_login',
        )
