/**
 * MCE ツールバーにボタンを追加します。
 */
( function()
{
	tinymce.create( "tinymce.plugins.VCSearchButtons",
	{
		getInfo : function()
		{
			return { longname:"VC Search", author: "wackey", authorurl: "http://musilog.net/", infourl: "http://review.web-service-api.jp/", version: "1.1" };
		},

		init : function( ed, url )
		{
			var t = this;
			t.editor = ed;

			ed.addCommand('LS', function() {
				ed.windowManager.open({
					file : url + '/ext_mce/ls.htm',
					width : 400 + parseInt(ed.getLang('ls.delta_width', 0)),
					height : 200+ parseInt(ed.getLang('ls.delta_height', 0)),
					inline : 1
				}, {
					plugin_url : url
				});
			});
			
			ed.addCommand( 'VC', function()
			{
				ed.windowManager.open({
					file : url + '/ext_mce/vc.htm',
					width : 400 + parseInt(ed.getLang('vc.delta_width', 0)),
					height : 200+ parseInt(ed.getLang('vc.delta_height', 0)),
					inline : 1
				}, {
					plugin_url : url
				});
			});
			ed.addCommand( 'RK', function()
			{
				ed.windowManager.open({
					file : url + '/ext_mce/rk.htm',
					width : 400 + parseInt(ed.getLang('rk.delta_width', 0)),
					height : 200+ parseInt(ed.getLang('rk.delta_height', 0)),
					inline : 1
				}, {
					plugin_url : url
				});
			});
			ed.addCommand( 'AM', function()
			{
				ed.windowManager.open({
					file : url + '/ext_mce/am.htm',
					width : 400 + parseInt(ed.getLang('am.delta_width', 0)),
					height : 200+ parseInt(ed.getLang('am.delta_height', 0)),
					inline : 1
				}, {
					plugin_url : url
				});
			});
			ed.addCommand( 'YS', function()
			{
				ed.windowManager.open({
					file : url + '/ext_mce/ys.htm',
					width : 400 + parseInt(ed.getLang('ys.delta_width', 0)),
					height : 200+ parseInt(ed.getLang('ys.delta_height', 0)),
					inline : 1
				}, {
					plugin_url : url
				});
			});
			ed.addCommand( 'YA', function()
			{
				ed.windowManager.open({
					file : url + '/ext_mce/ya.htm',
					width : 400 + parseInt(ed.getLang('ya.delta_width', 0)),
					height : 200+ parseInt(ed.getLang('ya.delta_height', 0)),
					inline : 1
				}, {
					plugin_url : url
				});
			});



			ed.addButton( 'LS', { title: "LS", cmd: 'LS', image : url + "/mce_img/ls.gif" });
			ed.addButton( 'VC', { title: "VC", cmd: 'VC', image : url + "/mce_img/vc.gif" });
			ed.addButton( 'RK', { title: "RK", cmd: 'RK', image : url + "/mce_img/rk.gif" });
			ed.addButton( 'AM', { title: "AM", cmd: 'AM', image : url + "/mce_img/am.gif" });
			ed.addButton( 'YS', { title: "YS", cmd: 'YS', image : url + "/mce_img/ys.gif" });
			ed.addButton( 'YA', { title: "YA", cmd: 'YA', image : url + "/mce_img/ya.gif" });



		},

	});

	tinymce.PluginManager.add( "VCSearchButtons", tinymce.plugins.VCSearchButtons );
} )();
