$:.unshift('vikiwiki')
$:.unshift('vikiwiki/lib')

require 'ftools'
require 'extension/file'
require 'vikiwikisys'

def input(question, answer, sel=nil)
	x = ''
	print question
	if sel then
		sel.each_with_index{|elm, i|
			print "\n%d. %s" % [i, elm]
		}
		print " (now %d. %s)" % [sel.index(answer), answer] unless answer.empty?
	else
		print " (now %s)" % answer unless answer.empty?
	end
	loop do
		print " > "
		x = $fin.gets
		break unless x
		x.chomp!
		next if /^\#/ === x
		break unless x.empty? and answer.empty?
	end
	puts x if $fin != STDIN
	unless x.to_s.strip.empty? then
		if sel then
			x = sel[x.to_i] if /^\d+$/ === x
			puts "=> You selected #{x}."
		end
		answer.replace(x)
	end
	$fout.puts answer if $fout
	return answer
end

def inputpath(question, answer)
	input question, answer
	answer.gsub!(/\\/, '/')
end

def setup_system(cmd)
	rubycmd = "ruby -K#{$KCODE[0].chr.downcase} "
	rubycmd << "-d " if $DEBUG
	rubycmd << cmd.strip
	puts rubycmd
	system(rubycmd)
end

$POSDESC      = ""
$WORK_HOME    = nil
$fin          = STDIN
$fout         = nil

if $0 == __FILE__ then
	$WORK_CGIFILE = nil
	while prm = ARGV.shift do
		case prm
		when '-i' then
			$fin = File::open(ARGV.shift, "r")
		when '-o' then
			$fout = File::open(ARGV.shift, "w")
		when /^[^\-]/ then
			$WORK_CGIFILE = prm.gsub(/\\/, '/')
		else
			raise "Invalid parameter. #{prm}"
		end
	end
end

if $WORK_CGIFILE and File::exist?($WORK_CGIFILE) then
	$WORK_LOCALFILE = $WORK_CGIFILE
	$CONF = Hash::new
	script = File::readlines($WORK_CGIFILE).join
	if script.include?('VikiWiki::Sys::new') then
		puts "The CGI file is new version."
		cf = '{'
		script.each{|line|
			case line
			when /^\$/ then
				next if /^\$SAFE/ === line
				eval(line)
			when /=>/ then
				cf << line
			end
		}
		cf << '}'
		$CONF.update(eval(cf))
	elsif script.include?('VikiWikiConf') then
		puts "The CGI file is old version."
		script.each{|line|
			if /^([A-Z]+)\s*=\s*(.+)$/ === line then
				$CONF[$1] = eval($2)
			end
		}
		$VIKIWIKIRUBY = $CONF['RUBYPATH']
		$VIKIWIKITMP = $CONF['TMP']
	else
		raise 'The VikiWiki script is too old.'
	end

	ENV['REQUEST_METHOD'] = 'GET'
	sys = VikiWiki::Sys::new($WORK_CGIFILE, $CONF)

else

	if $0 == __FILE__ then
		SETUP_FOR = ['This Machine', 'FTP']
		USE_FOR = ['Normal', 'CMS', 'StaticWiki', 'DirectEdit']
		AUTHTYPE = ['none', 'www', 'vikiwiki', 'form']

		$WORK_SETUP_FOR = SETUP_FOR[0].dup
		input "Setup for ", $WORK_SETUP_FOR, SETUP_FOR

		if $WORK_SETUP_FOR == 'FTP' then
			$POSDESC = ' on FTP server'
			$WORK_ADMIN = 'hogehoge'
			$WORK_PUBLIC = "/home/#{$WORK_ADMIN}/public_html"
			$WORK_HOME = '/~' + $WORK_ADMIN
			$WORK_VIKIWIKIDIR = "#{File::dirname($WORK_PUBLIC)}/vikiwiki"
			$WORK_RUBYPATH = '/usr/bin/env ruby'
		else
			$WORK_ADMIN = ENV['USERNAME'] || ENV['USER'] || ENV['REMOTE_USER'] || 'hogehoge'
			$WORK_LOCALHOME = ENV['HOME'] || (/mswin/i === RUBY_PLATFORM ? "C:/home/#{$WORK_ADMIN}" : "/home/#{$WORK_ADMIN}")
			$WORK_PUBLIC = "#{$WORK_LOCALHOME}/public_html"
			$WORK_HOME = '/~' + $WORK_ADMIN
			$WORK_VIKIWIKIDIR = Dir::pwd
			if /mswin/i === RUBY_PLATFORM then
				$WORK_RUBYPATH = 'c:/ruby/bin/ruby.exe'
				ENV['PATH'].split(';').each{|path|
					file = path.gsub(/\\/, '/')+'/'+'ruby.exe'
					next unless File::exist?(file)
					$WORK_RUBYPATH = file
					break
				}
			else
				$WORK_RUBYPATH = '/usr/bin/ruby'
				ENV['PATH'].split(':').each{|path|
					file = path+'/'+'ruby'
					next unless File::exist?(file)
					$WORK_RUBYPATH = file
					break
				}
			end
		end

		inputpath "Input your home path on WWW.", $WORK_HOME
		inputpath "Input your directory for #{$WORK_HOME}.", $WORK_PUBLIC
		inputpath "Input path for VikiWiki#{$POSDESC}.", $WORK_VIKIWIKIDIR

		$WORK_FOLDER = 'newfolder'
		$WORK_TMP = $WORK_VIKIWIKIDIR+'/tmp'

		$VIKIWIKIDIR = $WORK_VIKIWIKIDIR+'/vikiwiki'
		$CONF = VikiWiki::CONF.dup
		$CONF['ENCODING'] = USEconv::encoding($KCODE)
		$CONF['ADMIN']    = $WORK_ADMIN.downcase
		$CONF['AUTHOR']   = $WORK_ADMIN.dup
		$WORK_USE_FOR = USE_FOR[0].dup

		$LOOP = false
		loop {
			input     "Use for ", $WORK_USE_FOR, USE_FOR
			input     "Select authorization type ", $CONF['AUTHTYPE'], AUTHTYPE
			input     "Input administrator account.", $CONF['ADMIN']
			input     "Input your name.", $CONF['AUTHOR']
			input     "Input your mail address.", $CONF['ADDRESS']
			input     "Input LANG.", $CONF['LANG']
			inputpath "Input ruby path#{$POSDESC}.", $WORK_RUBYPATH
			input     "Input top page name.", $CONF['TOPPAGE']
			input     "Input wiki folder name.", $WORK_FOLDER
			$WORK_CGIFILE = "#{$WORK_PUBLIC}/#{$WORK_FOLDER}/vikiwiki.cgi" unless $WORK_CGIFILE
			inputpath "Input `local' path of CGI#{$POSDESC}.", $WORK_CGIFILE
			$CONF['SCRIPT_NAME'] = $WORK_CGIFILE.sub($WORK_PUBLIC, $WORK_HOME) unless $LOOP
			inputpath "Input URI of CGI.", $CONF['SCRIPT_NAME']
			inputpath "Input temporary directory#{$POSDESC}.", $WORK_TMP

			if $WORK_USE_FOR != 'Normal' then
				unless $LOOP then
					if $WORK_USE_FOR == 'CMS' then
						$CONF['STATICDIR'] = "#{$WORK_PUBLIC}/static"
					else
						$CONF['STATICDIR'] = "#{File::dirname($WORK_CGIFILE)}/static"
					end
				end
				inputpath "Input static directory(full path)#{$POSDESC}.", $CONF['STATICDIR']
				$CONF['STATICURI'] = $CONF['STATICDIR'].sub($WORK_PUBLIC, $WORK_HOME)  unless $LOOP
				inputpath "Input URI of static directory(full path).", $CONF['STATICURI']

				if $WORK_USE_FOR == 'DirectEdit' then
					unless $WORK_REMOTEPATH then
						$WORK_LOCALPATH = File::dirname($WORK_CGIFILE)
						$WORK_REMOTEPATH = 'file://hogehoge.hoge/'+$WORK_LOCALPATH
						$WORK_REMOTEPATH = 'file://hogehoge.hoge'+$' if /^[^\/]*/ === $WORK_LOCALPATH
					end
					inputpath "Input path browsable from client for #{$WORK_LOCALPATH}.", $WORK_REMOTEPATH
					$CONF['FILEEXT'] = 'wiki' unless $LOOP
					inputpath "Input file extension.", $CONF['FILEEXT']
				end
			end

			sure = 'n'
			input "Are you sure? (y/n)", sure
			break if sure[0].chr == 'y'
			$LOOP = true
		}

		$WORK_LOCALFILE = $WORK_CGIFILE
		if $WORK_SETUP_FOR == 'FTP' then
			$WORK_LOCALFILE = $WORK_CGIFILE.sub($WORK_PUBLIC, Dir::pwd)
			File::mkpath(File::dirname($WORK_LOCALFILE))
		end

		$VIKIWIKIRUBY = $WORK_RUBYPATH
		$VIKIWIKITMP = $WORK_TMP

	end

	$RENAMES = {
		'CmsLayoutPage' => nil,
		'CmsStaticLayout' => nil,
		'StaticWikiLayoutPage' => nil,
	}
	$RENAMES['FrontPage'] = $CONF['TOPPAGE'] if $CONF['TOPPAGE'] != 'FrontPage'

	case $WORK_USE_FOR
	when 'CMS' then
		$CONF['STATICIMG']   = "sync"
		$CONF['STATICTHEME'] = "sync"
		$CONF['STATICTITLE'] = "alias"
		$CONF['STATICWIKI']  = nil
		$RENAMES['CmsLayoutPage'] = 'LayoutPage'
		$RENAMES['CmsStaticLayout'] = 'StaticLayout'
	when 'StaticWiki' then
		$CONF['STATICIMG']   = 'share'
		$CONF['STATICTHEME'] = 'share'
		$CONF['STATICTITLE'] = 'alias'
		$CONF['STATICWIKI']  = true
		$RENAMES['StaticWikiLayoutPage'] = 'LayoutPage'
	when 'DirectEdit' then
		$CONF['STATICIMG']   = 'share'
		$CONF['STATICTHEME'] = 'share'
		$CONF['STATICTITLE'] = 'alias'
		$CONF['STATICWIKI']  = true
		$RENAMES['StaticWikiLayoutPage'] = 'LayoutPage'
		reg = Regexp::new('^'+Regexp::escape($WORK_LOCALPATH), Regexp::IGNORECASE)
		path = $WORK_REMOTEPATH
		$CONF['EDITFILEFROM'] = reg
		$CONF['EDITFILETO']  = path
		$CONF['FILEMODE']    = '660'
	end

	$CONF.delete_if{|k,v| v.to_s.empty?}

	raise "File already exists." if FileTest::exists?($WORK_LOCALFILE)

	ENV['REQUEST_METHOD'] = 'GET'
	sys = VikiWiki::Sys::new($WORK_CGIFILE, $CONF)

	dir = File::dirname(File::expand_path($WORK_LOCALFILE))
	puts "Generating folder '#{dir}'..."
	Dir::copy('master', dir)
	textdir = [dir, VikiWiki::TEXTNAM].path
	langdir = [textdir, sys['LANG']].path
	Dir::foreach(langdir){|sfile|
		next if /^\.+$/ === sfile
		tfile = sfile
		felms = sfile.split(/\./)
		if $RENAMES.value?(felms[0]) then
			File::unlink("#{langdir}/#{sfile}".untaint)
			next
		end
		if $RENAMES.key?(felms[0]) then
			if $RENAMES[felms[0]].nil? then
				File::unlink("#{langdir}/#{sfile}".untaint)
				next
			end
			felms[0] = $RENAMES[felms[0]]
		end
		felms.last.replace(sys['FILEEXT'])
		tfile = felms.join('.').untaint
		puts tfile
		File::rename("#{langdir}/#{sfile}".untaint, "#{textdir}/#{tfile}".untaint)
	}
	Dir::unlink(langdir)
	puts "Finished."

	if stadir = sys['STATICDIR'] then
		print "Making static directory '#{stadir}'..."
		File::mkpath(sys['STATICDIR'])
		dyn = [dir, VikiWiki::IMGNAM].path
		sta = [stadir, VikiWiki::IMGNAM].path
		Dir::copy(dyn, sta) if /^copy|sync$/ === sys['STATICIMG']
		dyn = [dir, VikiWiki::THEMENAM].path
		sta = [stadir, VikiWiki::THEMENAM].path
		Dir::copy(dyn, sta) if /^copy|sync$/ === sys['STATICTHEME']
		puts "Finished."
	end

end

print "Generating CGI script '#{$WORK_LOCALFILE}'..."
sys.config($CONF)
puts "Finished."

if $WORK_SETUP_FOR != 'FTP' then
	unless File::exist?($VIKIWIKITMP) then
		print "Making temporary directory '#{$VIKIWIKITMP}'..."
		Dir::mkdir($VIKIWIKITMP)
		puts "Finished."
	end
end

case $WORK_USE_FOR
when 'StaticWiki', 'DirectEdit' then
	$WORK_STATIC = ""
	$WORK_STATIC = File::basename($CONF['STATICDIR']) if $WORK_SETUP_FOR == 'FTP'
	setup_system("tool/static.rb -qxd #{$WORK_LOCALFILE} #{$CONF['SCRIPT_NAME']} #{$WORK_STATIC}")
end

# Change VikiWiki::CVS to DiffCVS.
setup_system("tool/chgdiffcvs.rb #{sys['TEXTDIR']} #{sys['FILEEXT']}")

puts
puts "======== END ========"
puts "Please edit CGI script '#{$WORK_LOCALFILE}' if you want to setup particuraly."

if $WORK_SETUP_FOR == 'FTP' then
	puts "Transport folder '#{dir}' to '#{File::dirname($WORK_CGIFILE)}' on FTP server."
end

$fin.close if $fin
$fout.close if $fout
