dir = File::expand_path(File::dirname(__FILE__.gsub(/\\/, '/'))+'/../vikiwiki')
$:.unshift(dir)
$:.unshift(dir+'/lib')
require 'vikiwikiparser'
require 'useconv'

STYLES = {
	'v' => 'VikiWikiStyle',
	'a' => 'AsWikiStyle',
	'f' => 'FreeStyleWikiStyle',
	'h' => 'HikiStyle',
	'j' => 'JapaneseStyle',
	'p' => 'PukiWikiStyle',
	't' => 'TikiStyle',
	'y' => 'YukiWikiStyle',
}
STYLES.default = 'VikiWikiStyle'

def sty(str)
	return nil unless str
	return STYLES.default unless /^([A-Za-z])(\d*)$/ === str
	chr, vl = $1, $2
	str = STYLES[chr.downcase]
	str = str.sub(/Style$/, "#{vl}Style") if vl
	return str
end

def param(argv)
	#raise "too few parameter #{argv.size}" if argv.size < 2
	p = ARGV.shift
	p = "-V" unless p
	raise "invalid style parameter #{p}" unless /^\-([A-Z]\d*)([a-z]\d*)?$/ === p
	fs, ts = sty($1), sty($2)
	p = ARGV.shift
	fc, tc = nil
	if p and p[0].chr == '-' then
		raise "invalid code parameter #{p}" unless /^\-([A-Z])([a-z])?$/ === p
		fc, tc = $1.downcase, $2.downcase
		fc = USEconv::cnvmethod(fc, $KCODE)
		tc = USEconv::cnvmethod($KCODE, tc)
		p = ARGV.shift
	end
	file = p || STDIN
	return fs, ts, fc, tc, file
end

if $0 == __FILE__ then

begin
	fs, ts, fc, tc, file = param(ARGV)
rescue
	prms = STYLES.keys.sort.join
	puts $!
	puts <<USAGE
Usage: #{$0} -{#{prms.upcase}}{#{prms.downcase}} -{SEU}{seu} [path]
USAGE
	exit(-1)
end

if file == STDIN then
	puts "(Input #{fs.name} text.)"
	text = ''
	while gets; text << $_; end
else
	text = File::readlines(file).join
end
text = fc.call(text) if fc
if ts then
	text = VikiWiki::Parser::trans_text(nil, text, fs, ts)
else
	text = VikiWiki::Parser::trans_html(nil, text, fs)
end
text = tc.call(text) if tc
print text

end
