require 'vikiwikiplugin'

module VikiWiki
	module Plugins
		class Calc
			include BaseModule
			def ondesc; <<DSC; end
The plugin can calcurate values in the page.
{{{
#calc {set|sum|avg|max|min|count|aname} {ident} [value]
}}}
DSC

			def safe; 5 ; end
			def onview
				mode, ident, value = @prms
				ident = Regexp::new($1) if /^\/(.+)\/$/ === ident
				case mode
				when 'set' then
					res = value
				when 'aname' then
					@sys.page.node.each_node('plugin'){|node|
						next unless node.getAttribute('name') == 'aname'
						next unless ident === node[0].text
						res = node[1].text
						break
					}
				else
					vals = Array::new
					@sys.page.node.each_node('plugin'){|node|
						next unless node.getAttribute('name') == 'calc'
						next unless node[0].text == 'set'
						next unless ident === node[1].text
						val = node[2].text if node[2]
						vals << (/^[\-\+]?\d+$/ === val ? val.to_i : val.to_f)
					}
					case mode
					when 'sum' then
						res = 0
						vals.each{|val| res += val}
					when 'avg' then
						res = 0
						vals.each{|val| res += val}
						res /= vals.size.to_f
					when 'max' then
						res = vals.first
						vals.each{|val| res = val if res < val}
					when 'min' then
						res = vals.first
						vals.each{|val| res = val if res > val}
					when 'count' then
						res = vals.size
					end
				end
				return CGI::element('span', {'class'=>'value'}, res.to_s)
			end
		end
	end
end
