#include <stdio.h>
#include <string.h>
#include <limits.h>  /* NAME_MAX, PATH_MAX */
#include <dirent.h>  /* opendir() */

#include "paclist.h"
#include "fbcolors.h"
#include "inrole.h"

static void find_paclist_in_dir(pac *cue_last, const char *role_path);

void find_paclist_in_role(pac *cue_last, const char *roledir_path, char preset_role[ROLE_PRESET_AMOUNT_MAX][ROLE_NAME_MAX], char optional_role[ROLE_OPTIONAL_AMOUNT_MAX][ROLE_NAME_MAX])
{
	int i;
	char role_path[PATH_MAX+1];

	/* optional_roleͥ -> preset_roleꤷin_role_pathoptional_roleǾ񤭤 */
	for (i=0; preset_role[i][0] != '\0'; i++) {
		sprintf(role_path, "%s/_%s", roledir_path, preset_role[i]);
		find_paclist_in_dir(cue_last, role_path);
	}
	for (i=0; optional_role[i][0] != '\0'; i++) {
		sprintf(role_path, "%s/%s", roledir_path, optional_role[i]);
		find_paclist_in_dir(cue_last, role_path);
	}
}

static void find_paclist_in_dir(pac *cue_last, const char *role_path)
{
	DIR *roledir;
	struct dirent *roledir_line;
	int dirlen;
	char using_pac_name[NAME_MAX+1];
	pac *found_pac;

	if ( (roledir = opendir(role_path)) == NULL ) {
		fprintf(stderr, "%sCan't open role directory %s. This role is ignored.%s\n", FB_WARN, role_path, FB_NORMAL);
		return;
	}
	while ( (roledir_line = readdir(roledir)) != NULL ) {
		dirlen = strlen(roledir_line->d_name);
		if (dirlen < 6) { continue; }
		if (strcmp(&roledir_line->d_name[ dirlen - 5 ], ".conf") != 0)
			continue;  /* 5ʸ".conf"ǤϤʤ */

		strcpy(using_pac_name, roledir_line->d_name);
		using_pac_name[ dirlen - 4 ] = 'p';  /* *.conf -> *.pac */
		using_pac_name[ dirlen - 3 ] = 'a';
		using_pac_name[ dirlen - 2 ] = 'c';
		using_pac_name[ dirlen - 1 ] = '\0';

		found_pac = paclist_search_by_dirname(cue_last->next, using_pac_name); /* cue_last_LASTʤΤǡcue_last->nextϤ */
		if (found_pac == NULL) {
			fprintf(stderr, "%sThe pac coresponds to %s is not found.%s\n", FB_WARN, roledir_line->d_name, FB_NORMAL);
			continue;
		}
		strcpy(found_pac->in_role_path, role_path);
		found_pac->use = Yes;
	}
}

